/*
 * TableChooserPanel.java
 *
 * Created on June 4, 2007, 1:35 PM
 */

package org.netbeans.modules.edm.editor.graph.components;

import java.util.List;

import org.netbeans.modules.sql.framework.model.SQLDBTable;

/**
 *
 * @author  karthikeyan s
 */
public class TableChooserPanel extends javax.swing.JPanel {
    
    private List<SQLDBTable> dbTables;
    /** Creates new form TableChooserPanel */
    public TableChooserPanel(List<SQLDBTable> tables) {
        initComponents();
        dbTables = tables;
        populateTables();
    }
    
    public SQLDBTable getSelectedTable() {
        return dbTables.get(tablesCombo.getSelectedIndex());
    }
    
    private void populateTables() {
        tablesCombo.removeAllItems();
        SQLDBTable[] tbls = dbTables.toArray(new SQLDBTable[0]);
        for(SQLDBTable table : tbls) {
            tablesCombo.addItem(table.getDisplayName());
        }
        if(tablesCombo.getModel().getSize() != 0) {
            tablesCombo.setSelectedIndex(0);
        }
    }    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        tablesCombo = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();

        setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(TableChooserPanel.class, "border.title_1"))); // NOI18N

        jLabel1.setText(org.openide.util.NbBundle.getMessage(TableChooserPanel.class, "jLabel1.text")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .add(18, 18, 18)
                .add(tablesCombo, 0, 109, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(tablesCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JComboBox tablesCombo;
    // End of variables declaration//GEN-END:variables
    
}
