/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.edm.editor.widgets.property;

import org.netbeans.modules.edm.editor.dataobject.MashupDataObject;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;

import org.netbeans.modules.sql.framework.model.TargetTable;

/**
 *
 * @author Nithya R
 */
public class TargetTableNode extends AbstractNode {
    
    private TargetTable tgtTable;
    
    private MashupDataObject mObj;
    
    public TargetTableNode(TargetTable obj,MashupDataObject dObj) {
        super(Children.LEAF);
        tgtTable = (TargetTable) obj;
        mObj = dObj;
    }
    
    @Override
    public boolean canCopy() {
        return false;
    }
    
    @Override
    public boolean canRename() {
        return false;
    }
    
    @Override
    public boolean canCut() {
        return false;
    }
    
    @Override
    public boolean canDestroy() {
        return true;
    }
    
    /** Creates a property sheet. */
    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.createPropertiesSet();
        Sheet.Set expset = sheet.createExpertSet();
        set.setDisplayName("Basic");
        set.setExpert(false);
        expset.setDisplayName("Expert");
        expset.setExpert(true);
        try {
            PropertySupport.Reflection stmtTypeProp = new PropertySupport.Reflection(
                    this.tgtTable, String.class,
                    "getStrStatementType", "setStrStatementType");
            stmtTypeProp.setName("Statement Type");
            stmtTypeProp.setPropertyEditorClass(
                    PropertyEditorManager.getPropertyEditor("TARGET_STMT_TYPE"));
            set.put(stmtTypeProp);
             
            PropertySupport.Reflection targetjoinConditionProp = new PropertySupport.Reflection(
                    this.tgtTable.getJoinCondition(), String.class,
                    "getConditionText", "setConditionText");
            targetjoinConditionProp.setName("Target Join Condition");
            targetjoinConditionProp.setPropertyEditorClass(
                    PropertyEditorManager.getPropertyEditor("TARGET_JOIN_CONDITION"));
            set.put(targetjoinConditionProp);  
            
            PropertySupport.Reflection outerFilterConditionProp = new PropertySupport.Reflection(
                    this.tgtTable.getFilterCondition(), String.class,
                    "getConditionText", "setConditionText");
            outerFilterConditionProp.setName("Outer Filter Condition");
            outerFilterConditionProp.setPropertyEditorClass(
                    PropertyEditorManager.getPropertyEditor("OUTER_FILTER_CONDITION"));
            set.put(outerFilterConditionProp); 
            
            PropertySupport.Reflection nameProp = new PropertySupport.Reflection(this.tgtTable,
                    String.class, "getDisplayName","setDisplayName");
            nameProp.setName("Table Name");
            set.put(nameProp);  
              
            PropertySupport.Reflection databaseModelNameProp = new PropertySupport.Reflection(this.tgtTable.getParent(),
                    String.class, "getModelName",null);
            databaseModelNameProp.setName("Database Model Name");
            set.put(databaseModelNameProp);  
            
            PropertySupport.Reflection aliasNameProp = new PropertySupport.Reflection(this.tgtTable,
                    String.class,"getAliasName","setAliasName");
            aliasNameProp.setName("Alias Name");
            expset.put(aliasNameProp);  
            
            PropertySupport.Reflection createTargetTableProp = new PropertySupport.Reflection(this.tgtTable,
                    Boolean.class,"isCreateTargetTable" ,null);
            createTargetTableProp.setName("Create Target Table");
            expset.put(createTargetTableProp); 
            
            PropertySupport.Reflection truncateBeforeLoadProp = new PropertySupport.Reflection(this.tgtTable,
                    Boolean.class,"isTruncateBeforeLoad" ,null);
            truncateBeforeLoadProp.setName("Truncate Before Load");
            expset.put(truncateBeforeLoadProp); 
            
            PropertySupport.Reflection batchSizeProp = new PropertySupport.Reflection(this.tgtTable,
                    Integer.class,"getBatchSize" , null);
            batchSizeProp.setName("Batch Size");
            expset.put(batchSizeProp);                        
        } catch (Exception ex) {
            ErrorManager.getDefault().notify(ex);
        }
        sheet.put(set);
        sheet.put(expset);
        return sheet;
    }
    
     public TargetTable getTargetTable() {
        return this.tgtTable;
    }
    
    public MashupDataObject getMashupDataObject() {
        return mObj;
    } 
}
