/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package org.netbeans.modules.aspect.editor.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

/**
 *
 * @author karthikeyan s
 */
public class Util {
    
    /** Creates a new instance of Util */
    public Util() {
    }
    
    public static List<Advice> getSortedAdviceList(List<Advice> adviceList) {
        Iterator it = adviceList.iterator();
        SortedMap<Integer, Advice> map = new TreeMap<Integer, Advice>();
        while(it.hasNext()) {
            Advice adv = (Advice)it.next();
            map.put(Integer.parseInt(adv.getOrderNo()), adv);
        }
        
        // make sure id starts from 1.
        it = map.keySet().iterator();
        int i = 1;
        while(it.hasNext()) {
            Integer id = (Integer) it.next();
            ((Advice)map.get(id)).setOrderNo(String.valueOf(i++));
        }        
        return new ArrayList<Advice>(map.values());
    }
    
    public static List<Aspect> getSortedAspectList(List<Aspect> aspectList) {
        Iterator it = aspectList.iterator();
        SortedMap<Integer, Aspect> map = new TreeMap<Integer, Aspect>();
        while(it.hasNext()) {
            Aspect asp = (Aspect)it.next();
            map.put(Integer.parseInt(asp.getID()), asp);
        }
        
        // make sure id starts from 1.
        it = map.keySet().iterator();
        int i = 1;
        while(it.hasNext()) {
            Integer id = (Integer) it.next();
            ((Aspect)map.get(id)).setID(String.valueOf(i++));
        }        
        return new ArrayList<Aspect>(map.values());        
    }
    
    public static Advice getLastAdvice(List<Advice> adviceList) {
        Iterator it = adviceList.iterator();
        SortedMap<Integer, Advice> map = new TreeMap<Integer, Advice>();
        while(it.hasNext()) {
            Advice adv = (Advice)it.next();
            map.put(Integer.parseInt(adv.getOrderNo()), adv);
        }
        return map.get(map.lastKey());
    }
    
    public static List<Output> getSortedOutputList(List<Output> outputList) {
        Iterator it = outputList.iterator();
        SortedMap<Integer, Output> map = new TreeMap<Integer, Output>();
        while(it.hasNext()) {
            Output out = (Output)it.next();
            map.put(Integer.parseInt(out.getId()), out);
        }
        
        // make sure id starts from 1.
        it = map.keySet().iterator();
        int i = 1;
        while(it.hasNext()) {
            Integer id = (Integer) it.next();
            ((Output)map.get(id)).setId(String.valueOf(i++));
        }
        
        return new ArrayList<Output>(map.values());
    }
    
    public static void makeSpaceforDefaultOutput(Aspect aspect) {
        List<Output> outs = aspect.getOutputs();
        Iterator it = getSortedOutputList(outs).iterator();
        int id = 2;
        while(it.hasNext()) {
            Output out = (Output)it.next();
            out.setId(String.valueOf(id++));
        }
        aspect.setOutputs(outs);
    }
    
    public static Output getMatchingOutput(String id, Aspect aspect) {
        Iterator it = aspect.getOutputs().iterator();
        while(it.hasNext()) {
            Output out = (Output) it.next();
            if(out.getId().equals(id)) {
                return out;
            }
        }
        return null;
    }    

    public static List<Advice> makeSpaceforAdvice(List<Advice> list, int i) {
        list = getSortedAdviceList(list);
        Iterator it = list.iterator();
        while(it.hasNext()) {
            Advice adv = (Advice)it.next();
            if(Integer.parseInt(adv.getOrderNo()) >= i ) {
                adv.setOrderNo(String.valueOf(i + 1));
            }
        }
        return list;
    }
}