/* *************************************************************************
 *
 *          Copyright (c) 2005, SeeBeyond Technology Corporation,
 *          All Rights Reserved
 *
 *          This program, and all the routines referenced herein,
 *          are the proprietary properties and trade secrets of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 *          Except as provided for by license agreement, this
 *          program shall not be duplicated, used, or disclosed
 *          without  written consent signed by an officer of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 ***************************************************************************/
package org.netbeans.modules.aspect.project.anttasks;

import javax.xml.namespace.QName;

public class AspectMapEntry {
    public static final String REQUEST_REPLY_SERVICE = "requestReplyService";
    public static final String FILTER_ONE_WAY = "filterOneWay";
    public static final String FILTER_REQUEST_REPLY = "filterRequestReply";
    
    public static final String INPUT_MESSAGE_TYPE = "input";
    public static final String OUTPUT_MESSAGE_TYPE = "output";
    public static final String REPLY_MESSAGE_TYPE = "reply";
    
    private String mType;
    private QName mPartnerLink;
    private QName mPortType;
    private String mRoleName;
    
    /**
     * Creates a new instance of PortMapEntry
     */
    private AspectMapEntry(String type,
            QName partnerLink,
            QName portType,
            String roleName) {
        mType = type;
        mPartnerLink = partnerLink;
        mPortType = portType;
        mRoleName = roleName;
    }
    
    public static AspectMapEntry newProvidesEndpointEntry(QName partnerLink,
            QName portType,
            String roleName) {
        return new AspectMapEntry(INPUT_MESSAGE_TYPE,
                partnerLink,
                portType,
                roleName);
    }
    
    public static AspectMapEntry newConsumesEndpointEntry(QName partnerLink,
            QName portType,
            String roleName) {
        
        return new AspectMapEntry(OUTPUT_MESSAGE_TYPE,
                partnerLink,
                portType,
                roleName);
    }
    
    public String getType() {
        assert mType != null;
        return mType;
    }
    
    public QName getPartnerLink() {
        assert mPartnerLink != null;
        return mPartnerLink;
    }
    
    public QName getPortType() {
        return mPortType;
    }
    
    public String getRoleName() {
        return mRoleName;
    }    
}