package org.netbeans.modules.wsdlextensions.ldap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.naming.NamingException;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.netbeans.modules.wsdlextensions.ldap.ldif.LdifObjectClass;
import org.openide.WizardDescriptor;

public final class ServerBrowserVisualPanelStep2 extends JPanel {
    
    /** Creates new form ServerBrowserVisualPanel2 */
    public ServerBrowserVisualPanelStep2() {
        initComponents();
    }
    
    public String getName() {
        return "Browse LDAP Server";
    }
    
    public void read(List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); i++) {
                String item = (String) list.get(i);
                ((SortedListModel) jListObjClass.getModel()).addElement(item);
            }
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane = new javax.swing.JScrollPane();
        jListObjClass = new javax.swing.JList();
        jScrollPane3 = new javax.swing.JScrollPane();
        jListAttributes = new javax.swing.JList();
        jScrollPane4 = new javax.swing.JScrollPane();
        jListSelectedObjects = new javax.swing.JList();
        jButtonSelect = new javax.swing.JButton();
        jButtonUnSelect = new javax.swing.JButton();

        jListObjClass.setBorder(javax.swing.BorderFactory.createTitledBorder("namelist"));
        jListObjClass.setModel(new SortedListModel());
        jListObjClass.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jListObjClassValueChanged(evt);
            }
        });
        jScrollPane.setViewportView(jListObjClass);

        jListAttributes.setModel(new SortedListModel());
        jScrollPane3.setViewportView(jListAttributes);

        jListSelectedObjects.setModel(new SortedListModel());
        jScrollPane4.setViewportView(jListSelectedObjects);

        org.openide.awt.Mnemonics.setLocalizedText(jButtonSelect, ">");
        jButtonSelect.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jButtonSelectMouseClicked(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(jButtonUnSelect, "<");
        jButtonUnSelect.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jButtonUnSelectMouseClicked(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 140, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(18, 18, 18)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jButtonSelect)
                    .add(jButtonUnSelect))
                .add(18, 18, 18)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(jScrollPane4, 0, 0, Short.MAX_VALUE)
                    .add(jScrollPane3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 128, Short.MAX_VALUE))
                .add(18, 18, 18))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap(174, Short.MAX_VALUE)
                .add(jButtonSelect)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(jButtonUnSelect)
                .add(69, 69, 69))
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(jScrollPane3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 108, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(19, 19, 19)
                        .add(jScrollPane4, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jScrollPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 260, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(19, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
private void jButtonUnSelectMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButtonUnSelectMouseClicked
    // TODO add your handling code here:
//GEN-LAST:event_jButtonUnSelectMouseClicked
    Object[] selected = jListSelectedObjects.getSelectedValues();    
    List list  = new ArrayList();
    ListModel model = jListSelectedObjects.getModel();
        for (int i = 0; i < model.getSize(); i++) {
            list.add(model.getElementAt(i));
        }
    
    for  (int i = 0; i < selected.length; i++) {
        String item = (String) selected[i];
        ((SortedListModel) jListObjClass.getModel()).addElement(item);
        list.remove(item);
    }

    jListSelectedObjects.setListData(new Vector(list));
    revalidate();
    repaint();
}

private void jButtonSelectMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButtonSelectMouseClicked
        // TODO add your handling code here:
    Object[] selected = jListSelectedObjects.getSelectedValues();//GEN-LAST:event_jButtonSelectMouseClicked
    
    Object[] newselected = jListObjClass.getSelectedValues();
    List list  = new ArrayList();
    ListModel model = jListSelectedObjects.getModel();
        for (int i = 0; i < model.getSize(); i++) {
            list.add(model.getElementAt(i));
        }
    for (int i = 0; i < newselected.length; i++) {
        list.add(newselected[i]);
    }

    jListSelectedObjects.removeAll();
    jListSelectedObjects.setListData(new Vector(list));

        for (int i = 0; i < newselected.length; i++) {
            String item = (String) newselected[i];
            //((SortedListModel) jListSelectedObjects.getModel()).addElement(item);
            ((SortedListModel) jListObjClass.getModel()).removeElement(item);
        }

    this.revalidate();
    this.repaint();
}

    private void jListObjClassValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jListObjClassValueChanged
    String objName = (String) jListObjClass.getSelectedValue();//GEN-LAST:event_jListObjClassValueChanged
        try {
            LdifObjectClass obj = ServerUtil.getObjectClass(objName);
            List mays = obj.getMay();
            List musts = obj.getMust();
            Vector listData = new Vector();
            if (musts != null) {
/*                for (int i = 0; i < musts.size(); i++) {
                    String item = (String) musts.get(i);
                    SortedListModel model = (SortedListModel) jListAttributes.getModel();
                    model.addElement("* " + item);
                    jListAttributes.setModel(model);
                }*/
                for (int i = 0; i < musts.size(); i++) {
                    String item = (String) musts.get(i);
                    listData.add("* " + item);
                }
            }
            if (mays != null) {
/*                for (int i = 0; i < mays.size(); i++) {
                    String item = (String) mays.get(i);
                    ((SortedListModel) jListAttributes.getModel()).addElement(item);
                }*/
                listData.addAll(mays);
            }
            jListAttributes.setListData(listData);
        } catch (NamingException ex) {
            ex.printStackTrace();
        }
    }
    
    public void store(WizardDescriptor wd) {
        Map objs = new HashMap();
        jListSelectedObjects.getModel().getSize();
        try {
            for (int i = 0; i < jListSelectedObjects.getModel().getSize(); i++) {
                String objName = (String) jListSelectedObjects.getModel().getElementAt(i);
                objs.put(objName, ServerUtil.getObjectClass(objName));
            }
            
            wd.putProperty("LDAP_OBJCLASS_LIST", objs);
        } catch (NamingException ex) {
            ex.printStackTrace();
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonSelect;
    private javax.swing.JButton jButtonUnSelect;
    private javax.swing.JList jListAttributes;
    private javax.swing.JList jListObjClass;
    private javax.swing.JList jListSelectedObjects;
    private javax.swing.JScrollPane jScrollPane;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane4;
    // End of variables declaration//GEN-END:variables
    
}

