/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.script.project.wizard.element;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import org.openide.DialogDescriptor;

/**
 * @author Raghunadh
 * 
 */
abstract class Dialog {

  protected Dialog(String title) {
    myTitle = title;
  }

  protected abstract void create(String name);
  
  private JPanel createPanel() {
    JPanel panel = new JPanel(new GridBagLayout());
    GridBagConstraints c = new GridBagConstraints();
    c.anchor = GridBagConstraints.NORTHWEST;
    c.fill = GridBagConstraints.HORIZONTAL;
    c.weightx = 1.0;
    c.gridx = 0;

    // name
    panel.add(createNamePanel(), c);

    return panel;
  }

  private JComponent createNamePanel() {
    JPanel panel = new JPanel(new GridBagLayout());
    GridBagConstraints c = new GridBagConstraints();
    c.anchor = GridBagConstraints.WEST;

    // text
    c.gridy++;
    c.insets = new Insets(8, 0, 3, 0);
    JLabel label = new javax.swing.JLabel(org.openide.util.NbBundle.getMessage(getClass(),"LBL_Name")); // NOI18N
    panel.add(label, c);

    c.insets = new Insets(8, 8, 3, 0);
    c.fill = GridBagConstraints.HORIZONTAL;
    c.weightx = 1.0;
    myName = new JTextField();
    label.setLabelFor(myName);
    panel.add(myName, c);

    return panel;
  }

  protected boolean checkName(String name) {
    myDescriptor.setClosingOptions(
      new Object [] { 
        DialogDescriptor.CANCEL_OPTION
      }
    );

    if (name.length() == 0) {
      return false;
    }
    myDescriptor.setClosingOptions(
      new Object [] { 
        DialogDescriptor.OK_OPTION,
        DialogDescriptor.CANCEL_OPTION
      }
    );
    return true;
  }

  private String myTitle;
  private JTextField myName;
  private DialogDescriptor myDescriptor;
  private static final int TEXT_WIDTH = 150;
}
