/*
 * TaskDefinitionMultiViewElement.java
 * 
 * Created on May 24, 2007, 3:09:23 PM
 * 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.netbeans.modules.worklist.editor.multiview.notification;

import java.beans.PropertyChangeEvent;
import org.netbeans.modules.worklist.dataloader.WorklistDataObject;
import org.netbeans.modules.worklist.editor.multiview.TaskSelectionModel;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/**
 *
 * @author radval
 */
public class NotificationMultiViewElement extends ToolBarMultiViewElement implements java.beans.PropertyChangeListener {

    private WorklistDataObject dObj;
    
    private SectionView view;
    private ToolBarDesignEditor comp;
    private NotificationPanelFactory factory;
    private javax.swing.Action addAction, removeAction;
    private boolean needInit=true;
    private int index;
    private TaskSelectionModel taskSelectionModel;
    
    private RequestProcessor.Task repaintingTask;
   
    private static final String HELP_ID_PREFIX=WorklistDataObject.HELP_ID_PREFIX_ASSIGNMENT;
    
    static final String NOTIFICATION_PANEL = "Notification";
    
    
    
    public NotificationMultiViewElement(final WorklistDataObject dObj, 
                                        int index,
                                        TaskSelectionModel taskSelectionModel) {
        super(dObj);
        this.dObj=dObj;
        this.index=index;
        this.taskSelectionModel = taskSelectionModel;
        
         comp = new ToolBarDesignEditor();
        factory = new NotificationPanelFactory(comp, dObj);
        addAction = new AddAction(dObj,NbBundle.getMessage(NotificationMultiViewElement.class,"LBL_addNotification"));
        removeAction = new RemoveAction(NbBundle.getMessage(NotificationMultiViewElement.class,"LBL_remove"));
        setVisualEditor(comp);
        view = new ServletsView();
        comp.setContentView(view);
        repaintingTask = RequestProcessor.getDefault().create(new Runnable() {
            public void run() {
                javax.swing.SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        repaintView();
                    }
                });
            }
        });
    }

    public SectionView getSectionView() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void propertyChange(PropertyChangeEvent evt) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
    private void repaintView() {
        
        Object lastActive = comp.getLastActive();
        if (lastActive!=null) {
            ((SectionView)view).openPanel(lastActive);
        } else {
            ServletsView servletsView = (ServletsView)view;
            Node initialNode = servletsView.getServletsNode();
            Children ch = initialNode.getChildren();
            if (ch.getNodesCount()>0) 
                initialNode = ch.getNodes()[0];
            servletsView.selectNode(initialNode);
        }
        view.checkValidity();
        //ritdObj.checkParseable();
    }
    
    
    class ServletsView extends SectionView {
        private SectionContainer servletsCont;
        private Node servletsNode;
        
        ServletsView () {
            super(factory);
            String[] servlets = new String[] {NOTIFICATION_PANEL};
            Node[] nodes = new Node[servlets.length];
            Children ch = new Children.Array();
            for (int i=0;i<nodes.length;i++) {
                nodes[i] = new UsersNode(this, servlets[i]);
            }
            ch.add(nodes);
            
            servletsNode = new SectionContainerNode(ch);
            
            servletsCont = new SectionContainer(this,servletsNode,
                NbBundle.getMessage(NotificationMultiViewElement.class,"TTL_notifications"),false);
            servletsCont.setHeaderActions(new javax.swing.Action[]{addAction});
            
            Children servletsChildren = new Children.Array();
            servletsChildren.add(new Node[]{servletsNode});
            
            
            AbstractNode root = new AbstractNode(servletsChildren);
            SectionPanel[] pan = new SectionPanel[servlets.length];
            for (int i=0;i<nodes.length;i++) {
                pan[i] = new SectionPanel(this, nodes[i], getServletTitle(servlets[i]),servlets[i]);
                pan[i].setHeaderActions(new javax.swing.Action[]{removeAction});
                servletsCont.addSection(pan[i]);
            }
            

            addSection(servletsCont);
            //root.setDisplayName("<Servlets>");
            servletsNode.setDisplayName(NbBundle.getMessage(NotificationMultiViewElement.class,"TTL_notifications"));
            servletsNode.setName(HELP_ID_PREFIX+"servletsNode"); //NOI18N
            setRoot(root);
        }
        
        Node getServletsNode() {
            return servletsNode;
        }
        
        SectionContainer getServletsContainer(){
            return servletsCont;
        }
        
        String getServletTitle(String servlet) {
            String servletName=servlet;
            if (servletName==null) servletName="";
            return servletName;
        }
        
        public org.netbeans.modules.xml.multiview.Error validateView() {
            org.netbeans.modules.xml.multiview.Error error = getSectionView().getErrorPanel().getError();
            if (error != null){
                return error;
            }
            
            return null;
            //ritreturn SectionValidator.validateServlets(webApp);
        }
    }
    
    
    private class UsersNode extends org.openide.nodes.AbstractNode {
        private SectionView view;
        UsersNode(SectionView view, String data) {
            super(org.openide.nodes.Children.LEAF);
            this.view=view;
            setDisplayName(data);
            setIconBaseWithExtension("org/netbeans/modules/worklist/dataloader/wait.gif"); //NOI18N
        }
        public HelpCtx getHelpCtx() {
            return new HelpCtx(HELP_ID_PREFIX+"servletNode"); //NOI18N
        }
    }
    
    private class GroupsNode extends org.openide.nodes.AbstractNode {
        private SectionView view;
        GroupsNode(SectionView view, String data) {
            super(org.openide.nodes.Children.LEAF);
            this.view=view;
            setDisplayName(data);
            setIconBaseWithExtension("org/netbeans/modules/worklist/dataloader/wait.gif"); //NOI18N
        }
        public HelpCtx getHelpCtx() {
            return new HelpCtx(HELP_ID_PREFIX+"servletNode"); //NOI18N
        }
    }
    
    
    private class AddAction extends javax.swing.AbstractAction {
        
        AddAction(final WorklistDataObject dObj, String actionName) {
            super(actionName);
            char mnem = NbBundle.getMessage(NotificationMultiViewElement.class,"LBL_addNotification_mnem").charAt(0);
            putValue(MNEMONIC_KEY,new Integer((int)mnem));
        }
        public void actionPerformed(java.awt.event.ActionEvent evt) {
        }
    }
    
    private class RemoveAction extends javax.swing.AbstractAction {
        
        RemoveAction(String actionName) {
            super(actionName);
            char mnem = NbBundle.getMessage(NotificationMultiViewElement.class,"LBL_remove_mnem").charAt(0);
            putValue(MNEMONIC_KEY,new Integer((int)mnem));
        }
        
        public void actionPerformed(java.awt.event.ActionEvent evt) {
        }
    }
}
