/*
 * TaskDefinitionMultiViewElement.java
 * 
 * Created on May 24, 2007, 3:09:23 PM
 * 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.netbeans.modules.worklist.editor.multiview.overview;


import org.netbeans.modules.worklist.editor.multiview.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import org.netbeans.modules.wlm.model.api.TAssignment;
import org.netbeans.modules.wlm.model.api.TImport;
import org.netbeans.modules.wlm.model.api.TTask;
import org.netbeans.modules.wlm.model.api.TTasks;
import org.netbeans.modules.wlm.model.api.WLMComponent;
import org.netbeans.modules.wlm.model.api.WLMComponentFactory;
import org.netbeans.modules.wlm.model.api.WLMModel;
import org.netbeans.modules.worklist.dataloader.WorklistDataObject;
import org.netbeans.modules.worklist.node.cookie.WLMComponentCookie;
import org.netbeans.modules.worklist.util.NameGenerator;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.netbeans.modules.xml.validation.ValidateAction;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/**
 *
 * @author radval
 */
public class OverviewMultiViewElement extends ToolBarMultiViewElement implements java.beans.PropertyChangeListener {

    private WorklistDataObject dObj;
    
    private TasksView view;
    private ToolBarDesignEditor comp;
    private OverviewPanelFactory factory;
    private javax.swing.Action addAction;
    private boolean needInit=true;
    private int index;
    private RequestProcessor.Task repaintingTask;
   
    private TaskSelectionModel taskSelectionModel;
    
    private List<TTask> taskList;
    
    private Map<TTask, TaskPanelComponentListener> taskListeners = new HashMap<TTask, TaskPanelComponentListener>();
            
    private static final String HELP_ID_PREFIX=WorklistDataObject.HELP_ID_PREFIX_ASSIGNMENT;
    
    static final String IMPORT_PANEL = "Import";
    
    static final String TASK_PANEL = "Task";
    
    
    public OverviewMultiViewElement(final WorklistDataObject dObj, 
                                    int index,
                                    TaskSelectionModel taskSelectionModel) {
        super(dObj);
        this.dObj=dObj;
        this.index=index;
        this.taskSelectionModel = taskSelectionModel;
        
         comp = new ToolBarDesignEditor();
        factory = new OverviewPanelFactory(comp, dObj);
        addAction = new AddAction(dObj,NbBundle.getMessage(OverviewMultiViewElement.class,"LBL_addTask"));
        
        setVisualEditor(comp);
        view = new TasksView();
        comp.setContentView(view);
        repaintingTask = RequestProcessor.getDefault().create(new Runnable() {
            public void run() {
                javax.swing.SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        repaintView();
                    }
                });
            }
        });
        
        ExplorerManager manager = view.getExplorerManager();
        manager.addPropertyChangeListener(new TaskNodeSelectionPropertyChangeListener());
        
        WLMModel model = dObj.getModel();
        if(model != null) {
            model.addComponentListener(new TaskComponentListener());
        }

        JComponent toolbar = comp.getStructureView();
        if(toolbar instanceof JToolBar) {
            JToolBar tBar = (JToolBar) toolbar;
            tBar.add(new ValidateAction(model));
        }
    }

    public SectionView getSectionView() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void propertyChange(PropertyChangeEvent evt) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
    private void repaintView() {
        
        Object lastActive = comp.getLastActive();
        if (lastActive!=null) {
            ((SectionView)view).openPanel(lastActive);
        } else {
            TasksView tasksView = (TasksView)view;
            Node initialNode = tasksView.getOverviewContainerNode();
            Children ch = initialNode.getChildren();
            if (ch.getNodesCount()>0) 
                initialNode = ch.getNodes()[0];
            tasksView.selectNode(initialNode);
        }
        view.checkValidity();
        //ritdObj.checkParseable();
    }
    
    
    private void refreshWhenChildAdded() {
        WLMModel model = dObj.getModel();
        TTasks tasks = model.getTasks();
        if(tasks != null) {
            List<TTask> existingTaskList = view.getTaskList();
            List<TTask> taskList = tasks.getTasks();
            Iterator<TTask> it = taskList.iterator();
            int cnt = 1;
            while(it.hasNext()) {
                TTask task = it.next();
                if(!existingTaskList.contains(task)) {
                   SectionPanel pan = view.addTaskNodeAndSection(task);
                   pan.open(); 
                }
                
            }
            
            this.taskList = taskList;
        }
    }
    
    private void refreshWhenChildRemoved() {
        WLMModel model = dObj.getModel();
        TTasks tasks = model.getTasks();
        if(tasks != null) {
            List<TTask> existingTaskList = view.getTaskList();
            List<TTask> taskList = tasks.getTasks();
            Iterator<TTask> it = existingTaskList.iterator();
            int cnt = 1;
            while(it.hasNext()) {
                TTask task = it.next();
                if(!taskList.contains(task)) {
                    view.removeTaskNodeAndSection(task);
                }
                
            }
            
            this.taskList = taskList;
        }
    }
    
    class TasksView extends SectionView {
        private SectionContainer overviewSectionContainer;
        private Node overviewContainerNode;
        
        private Children ch = new Children.Array();
        
        TasksView () {
            super(factory);
            
                
            WLMModel model = dObj.getModel();
            TTasks tasks = model.getTasks();
            if(tasks != null) {
                Collection<TImport> imports = tasks.getImports();
                taskList = tasks.getTasks();
                if(taskList == null) {
                    taskList = new ArrayList<TTask>();
                }
                
                
                overviewContainerNode = new SectionContainerNode(ch);
                overviewContainerNode.setDisplayName(NbBundle.getMessage(OverviewMultiViewElement.class,"TTL_overview"));
                overviewContainerNode.setName(HELP_ID_PREFIX+"servletsNode"); //NOI18N

                overviewSectionContainer = new SectionContainer(this,overviewContainerNode,
                    NbBundle.getMessage(OverviewMultiViewElement.class,"TTL_overview"),false);
                overviewSectionContainer.setHeaderActions(new javax.swing.Action[]{addAction});

                if(imports != null) {
                    Node node = new ImportsNode(this, imports, IMPORT_PANEL);
                    ch.add(new Node[] {node});
                    SectionPanel pan = new SectionPanel(this, node, IMPORT_PANEL, imports);
                    overviewSectionContainer.addSection(pan);
                }
                
                Iterator<TTask> it = taskList.iterator();
               
                while(it.hasNext()) {
                    TTask task = it.next();
                    addTaskNodeAndSection(task);
               
                }
                
                
                Children servletsChildren = new Children.Array();
                servletsChildren.add(new Node[]{overviewContainerNode});
                AbstractNode root = new AbstractNode(servletsChildren);
                
//                SectionPanel[] pan = new SectionPanel[nodes.length];
//                for (int i=0;i<nodes.length;i++) {
//                    pan[i] = new SectionPanel(this, nodes[i], getServletTitle(servlets[i]),servlets[i]);
//                    pan[i].setHeaderActions(new javax.swing.Action[]{removeAction});
//                    servletsCont.addSection(pan[i]);
//                    //addSection(pan[i]);
//                }


                addSection(overviewSectionContainer);
                //root.setDisplayName("<Servlets>");
                
                setRoot(root);
             } else {
                setRoot(new EmptyNode());
             }
            
        }
        
        public SectionPanel  addTaskNodeAndSection(TTask task) {
            String displayName = TASK_PANEL;
            if(task.getName() != null) {
                displayName+= "("+ task.getName() + ")";
            } else {
                displayName+= "( Missing Task Name )";
            }

            Node node = new TaskNode(this, task , displayName);
            ch.add(new Node[] {node});
            
            SectionPanel pan = new SectionPanel(this, node, displayName, task);
            TaskPanelComponentListener listener = new TaskPanelComponentListener(pan, task);
            taskListeners.put(task, listener);
            dObj.getModel().addComponentListener(listener);
            
            TaskRemoveAction taskRemoveAction  = new TaskRemoveAction(NbBundle.getMessage(OverviewMultiViewElement.class,"LBL_remove"), task);
            pan.setHeaderActions(new javax.swing.Action[]{taskRemoveAction});
            overviewSectionContainer.addSection(pan);
            
            return pan;
        }
        
        public void removeTaskNodeAndSection(TTask task) {
            Node matchingNode = null;
            
            Children chidren = overviewContainerNode.getChildren();
            Node[] nodes = chidren.getNodes();
            for(int i = 0; i < nodes.length; i++) {
                Node node = nodes[i];
                WLMComponentCookie cookie = node.getCookie(WLMComponentCookie.class);
                if(cookie != null) {
                    WLMComponent component = cookie.getWLMComponent();
                    if(component != null && component.equals(task)) {
                        matchingNode = node;
                        break;    
                    }
                }
            }
            
            if(matchingNode != null) {
                chidren.remove(new Node[] {matchingNode});
                removeSection(matchingNode);
                
            }
            
            TaskPanelComponentListener listener = taskListeners.get(task);
            if(listener != null) {
                dObj.getModel().removeComponentListener(listener);
                taskListeners.remove(task);
            }
        }
        
        Node getOverviewContainerNode() {
            return overviewContainerNode;
        }
        
        SectionContainer getServletsContainer(){
            return overviewSectionContainer;
        }
        
        
        public org.netbeans.modules.xml.multiview.Error validateView() {
            org.netbeans.modules.xml.multiview.Error error = getSectionView().getErrorPanel().getError();
            if (error != null){
                return error;
            }
            
            return null;
            //ritreturn SectionValidator.validateServlets(webApp);
        }
        
        public List<TTask> getTaskList() {
            return taskList;
        }
    }
    
    
    private class TaskNode extends org.openide.nodes.AbstractNode {
        private SectionView view;
        
        private TTask data;
        
        TaskNode(SectionView view, TTask data, String displayName) {
            super(org.openide.nodes.Children.LEAF);
            this.view=view;
            this.data = data;
            this.getCookieSet().add(new WLMComponentCookie(data));
            setDisplayName(displayName);
            setIconBaseWithExtension("org/netbeans/modules/worklist/dataloader/wait.gif"); //NOI18N
        }
        
        public HelpCtx getHelpCtx() {
            return new HelpCtx(HELP_ID_PREFIX+"servletNode"); //NOI18N
        }
        
        public TTask getTask() {
            return data;
        }
    }
    
    private class ImportsNode extends org.openide.nodes.AbstractNode {
        private SectionView view;
        ImportsNode(SectionView view, Collection<TImport> data, String displayName) {
            super(org.openide.nodes.Children.LEAF);
            this.view=view;
            setDisplayName(displayName);
            setIconBaseWithExtension("org/netbeans/modules/worklist/dataloader/wait.gif"); //NOI18N
        }
        public HelpCtx getHelpCtx() {
            return new HelpCtx(HELP_ID_PREFIX+"servletNode"); //NOI18N
        }
    }
    
    
    private class AddAction extends javax.swing.AbstractAction {
        
        AddAction(final WorklistDataObject dObj, String actionName) {
            super(actionName);
            char mnem = NbBundle.getMessage(OverviewMultiViewElement.class,"LBL_addTask_mnem").charAt(0);
            putValue(MNEMONIC_KEY,new Integer((int)mnem));
            
            
        }
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            WLMModel model = dObj.getModel();
            WLMComponentFactory factory = model.getFactory();
            TTask task = factory.createTask(model);
            task.setName(NameGenerator.getInstance().generateUniqueTaskName(model));
            task.setPartnerLink(NameGenerator.getInstance().generateUniquePartnerLinkName(model));
            
            TAssignment assignment = factory.createAssignment(dObj.getModel());
            task.setAssignment(assignment);
              
            
            model.startTransaction();
            model.getTasks().addTask(task);
            model.endTransaction();
        }
    }
    
    private class RemoveAction extends javax.swing.AbstractAction {
        
        RemoveAction(String actionName) {
            super(actionName);
            char mnem = NbBundle.getMessage(OverviewMultiViewElement.class,"LBL_remove_mnem").charAt(0);
            putValue(MNEMONIC_KEY,new Integer((int)mnem));
        }
        
        public void actionPerformed(java.awt.event.ActionEvent evt) {
        }
    }
    
    private class TaskRemoveAction extends javax.swing.AbstractAction {
        
        private TTask task;
        
        TaskRemoveAction(String actionName, TTask task) {
            super(actionName);
            this.task = task;
            char mnem = NbBundle.getMessage(OverviewMultiViewElement.class,"LBL_remove_mnem").charAt(0);
            putValue(MNEMONIC_KEY,new Integer((int)mnem));
        }
        
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            WLMModel model = dObj.getModel();
            
            if(model != null) {
                TTasks tasks = model.getTasks();
                if(tasks != null) {
                    model.startTransaction();
                    tasks.removeTask(this.task);
                    model.endTransaction();
                }
            }
        }
    }
    
    private class TaskNodeSelectionPropertyChangeListener implements PropertyChangeListener {
        
        public TaskNodeSelectionPropertyChangeListener() {
            
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if(propertyName.equals(ExplorerManager.PROP_SELECTED_NODES)) {
                Node[] newVal = (Node[]) evt.getNewValue();
                
                if(newVal.length != 0) {
                    Node node = newVal[0];
                    if(node instanceof TaskNode) {
                        TaskNode taskNode = (TaskNode) node;
                        
                        TTask task = taskNode.getTask();
                        taskSelectionModel.setSelectedTask(task);
                    } else {
                        taskSelectionModel.setSelectedTask(null);
                    }
                }
            }
        }
        
        
    }
    
    private class TaskComponentListener implements ComponentListener {

        public void valueChanged(ComponentEvent evt) {
            
        }

        public void childrenAdded(ComponentEvent evt) {
            refreshWhenChildAdded();
        }

        public void childrenDeleted(ComponentEvent evt) {
            refreshWhenChildRemoved();
        }
        
    }
    
    private class TaskPanelComponentListener implements ComponentListener {
        
        private SectionPanel view;
        private TTask task;
        
        public TaskPanelComponentListener(SectionPanel view, TTask task) {
            this.view = view;
            this.task = task;
        }
        
        public void valueChanged(ComponentEvent evt) {
            view.setTitle(task.getName());
        }

        public void childrenAdded(ComponentEvent evt) {
        }

        public void childrenDeleted(ComponentEvent evt) {
        }

     }
    
    class EmptyNode extends AbstractNode {
     
        public EmptyNode() {
            super(Children.LEAF);
        }
        
    }
}
