/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.wlm.model.spi;

import java.util.Collection;

import org.netbeans.modules.wlm.model.api.TTask;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;

public class OperationReference extends WSDLReferenceImpl <Operation>{

	public OperationReference(AbstractDocumentComponent parent, String ref) {
		super(Operation.class, parent, ref);
		// TODO Auto-generated constructor stub
	}

	public OperationReference(Operation referenced,  AbstractDocumentComponent parent) {
		super(referenced, Operation.class, parent);
		// TODO Auto-generated constructor stub
	}

	public Operation get() {
		// TODO Auto-generated method stub
		Operation returnObj = null;
		TTask task = TTask.class.cast(getParent ());
		if (task.getRole() == null) {
			return getReferenced();
		}
		if (! task.getRole().isResolved()) 
			return null;
		Role role =  task.getRole().get();
		PortType portType = role.getPortType().get();
		Collection<Operation> opts = portType.getOperations();
		for (Operation opt: opts) {
			if (opt.getName().equals(getLocalName())) {
				setReferenced(opt);
				break;
			}
		}
		return getReferenced ();
	}


}
