/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.exceptions.bugs.issuezilla;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.netbeans.modules.exceptions.bugs.BugReporter;
import org.netbeans.modules.exceptions.entity.Comment;
import org.netbeans.modules.exceptions.entity.Exceptions;
import org.netbeans.modules.exceptions.entity.Line;
import org.netbeans.modules.exceptions.entity.Stacktrace;
import org.netbeans.modules.exceptions.utils.LineComparator;
import org.netbeans.modules.exceptions.utils.PersistenceUtils;
import org.netbeans.modules.exceptions.utils.Utils;

/**
 *
 * @author Jan Horvath
 */
public class IssuezillaReporter implements BugReporter {
    
    public static final String PROCESS_BUG_URL = "http://www.netbeans.org/nonav/issues/process_bug.cgi";
    public static final String POST_BUG_URL = "http://www.netbeans.org/nonav/issues/post_bug.cgi";
    public static final String LOGIN_URL = "http://www.netbeans.org/servlets/TLogin";
    public static final String EXCEPTION_DETAIL = "http://statistics.netbeans.org/exceptions/detail.do?id=";
    
    public IssuezillaReporter() {
    }
    
    public void reportException(Exceptions exceptions, Properties props) {
        Exceptions orig = getOriginal(exceptions);
        Integer issueId = null;
        
        issueId = orig.getIssuezillaid();
        if ((issueId == null) || (issueId.intValue() == 0)) {
            createNewBug(exceptions, props);
        } else {
            addComment(exceptions, props);
            createAttachment(exceptions, props);
        }
    }
    
    private static String login(Properties props) {
        String username = props.getProperty("username");
        String password = props.getProperty("password");
        
        String response = null;
        HttpClient client = new HttpClient();
        client.getParams().setParameter("http.protocol.cookie-policy", CookiePolicy.BROWSER_COMPATIBILITY);
        //establish a connection within 5 seconds
        client.getHttpConnectionManager().
                getParams().setConnectionTimeout(20000);
        //client.getHostConfiguration().setProxy("host", 8080);
        
        PostMethod method = null;
        
        method = new PostMethod(LOGIN_URL);
        NameValuePair[] data = {
            new NameValuePair("loginID", username),
            new NameValuePair("password", password),
            new NameValuePair("Login", "Login")
        };
        method.setRequestBody(data);
        //execute the method
        try {
            client.executeMethod(method);
            Header header = method.getResponseHeader("Helmloginid");
            String login = header.getValue();
            if ((login == null) || (login.equals("guest"))) {
                throw new IllegalArgumentException("Login failed, check username/password");
            }
            
            Cookie[] cookies = client.getState().getCookies();
            for (int i = 0; i < cookies.length; i++) {
                if (cookies[i].toString().startsWith("JSESSIONID=")) {
                    response = cookies[i].toString();
                    break;
                }
            }
            
        } catch(Exception e) {
            e.printStackTrace();
        } finally {
            method.releaseConnection();
        }
        return response;
    }
    
    private void setIssueComment(List data, Exceptions exceptions) {
        Iterator<Comment> it = exceptions.getCommentCollection().iterator();
        StringBuffer comments = new StringBuffer();
        while(it.hasNext()) {
            Comment comment =  it.next();
            comments.append(comment.getComment());
            if (it.hasNext()) {
                comments.append("\n");
            }
        }
        data.add(new NameValuePair("comment", "Build: " + exceptions.getProductversion() +
                "\nVM: " + exceptions.getVm() +
                "\nOS: " + exceptions.getOperatingsystem() +
                "\n\nUser Comments: \n" + comments));
    }
    
    private void createNewBug(Exceptions exceptions, Properties props) {
        String issue = null;
        String cookie = login(props);
        boolean response = false;
        HttpClient client = new HttpClient();
        //establish a connection within 5 seconds
        client.getHttpConnectionManager().
                getParams().setConnectionTimeout(20000);
        
        //client.getHostConfiguration().setProxy("host", 8080);
        PostMethod method = null;
        method = new PostMethod(POST_BUG_URL);
        
        method.getParams().setCookiePolicy(CookiePolicy.IGNORE_COOKIES);
        ArrayList<NameValuePair> data = new ArrayList<NameValuePair>();
        method.setRequestHeader("Cookie", cookie);
        
        // hardcoded component/subcomponent for testing purposes
        data.add(new NameValuePair("component", exceptions.getComponent()));
        data.add(new NameValuePair("subcomponent", exceptions.getSubcomponent()));
        data.add(new NameValuePair("short_desc", exceptions.getSummary()));
        //        if ((exceptions.getNbuserId() != null) && (!"GUEST".equals(exceptions.getNbuserId().getName()))) {
        //            data.add(new NameValuePair("cc=", exceptions.getNbuserId().getName()));
        //        }
        //data.add(new NameValuePair("cc", "jhorvath"));
        data.add(new NameValuePair("issue_file_loc", EXCEPTION_DETAIL + getOriginal(exceptions).getId()));
        data.add(new NameValuePair("version", "6.0"));
        data.add(new NameValuePair("exceptionsid", exceptions.getId().toString()));
        data.add(new NameValuePair("form_name", "enter_issue"));
        data.add(new NameValuePair("reporter", props.getProperty("username")));
        data.add(new NameValuePair("rep_platform", "All"));
        data.add(new NameValuePair("issue_type", "DEFECT"));
        data.add(new NameValuePair("op_sys", "All"));
        data.add(new NameValuePair("priority", "P3"));
        data.add(new NameValuePair("status_whiteboard", "EXCEPTIONS_REPORT"));
        setIssueComment(data, exceptions);
        
        NameValuePair[] values = new NameValuePair[data.size()];
        method.setRequestBody((NameValuePair[]) data.toArray(values));
        
        //execute the method
        try {
            client.executeMethod(method);
            String redirectLocation;
            
            String str = null;
            
            //handle pssible redirect
            Header locationHeader = method.getResponseHeader("location");
            if (locationHeader != null) {
                redirectLocation = locationHeader.getValue();
                GetMethod gm = new GetMethod(redirectLocation);
                client.executeMethod(gm);
                str = new String(gm.getResponseBody());
            } else {
                str = new String(method.getResponseBody());
            }
            
            String expression = "<a href=\"show_bug.cgi\\?id=([0-9]*)\">";
            Pattern p = Pattern.compile(expression);
            Matcher m = p.matcher(str);
            boolean result = m.find();
            if(result){
                issue = m.group(1);
            }
            if (issue != null) {
                Logger.getLogger(getClass().getName()).log(Level.INFO,"ISSUE # " + issue + " was created");
                Exceptions orig = getOriginal(exceptions);
                orig.setIssuezillaid(new Integer(issue.trim()));
                PersistenceUtils.getInstance().merge(orig);
            }
            createAttachment(exceptions, props);
        } catch(Exception e) {
            Logger.getLogger(getClass().getName()).log(Level.SEVERE,"Issue was not created", e);
        } finally {
            method.releaseConnection();
        }
    }
    
    private void createAttachment(Exceptions exceptions, Properties props) {
        // check that Exceptions has assigned issuezilla id
        if (exceptions.getIssuezillaid() == null) {
            throw new java.lang.IllegalArgumentException("Exception report has not set issuezilla id");
        }
        Exceptions orig = getOriginal(exceptions);
        String cookie = login(props);
        HttpClient client = new HttpClient();
        //establish a connection within 5 seconds
        client.getHttpConnectionManager().
                getParams().setConnectionTimeout(20000);
        //client.getHostConfiguration().setProxy("host", 8080);
        
        PostMethod method = new PostMethod("http://www.netbeans.org/nonav/issues/createattachment.cgi");
        method.getParams().setCookiePolicy(CookiePolicy.IGNORE_COOKIES);
        
        ArrayList<NameValuePair> data = new ArrayList<NameValuePair>();
        
        StringBuffer sb = new StringBuffer();
        Stacktrace stacktrace = exceptions.getStacktrace();
        while ( stacktrace != null) {
            sb.append(stacktrace.getMessage() + "\n");
            List<Line> lines = new ArrayList<Line>(stacktrace.getLineCollection());
            Collections.sort(lines, new LineComparator());
            for (Line line : lines) {
                sb.append(Utils.formatStacktraceLine(line) + "\n");
            }
            stacktrace = stacktrace.getAnnotation();
        }
        
        method.setRequestHeader("Cookie", cookie);
        Part[] parts = {
            new StringPart("id", orig.getIssuezillaid().toString()),
            new StringPart("description", "stacktrace"),
            new StringPart("type", "text/plain"),
            new FilePart("data", new ByteArrayPartSource("stacktrace.txt", sb.toString().getBytes()))
        };
        method.setRequestEntity(
                new MultipartRequestEntity(parts, method.getParams())
                );
        
        //execute the method
        try {
            client.executeMethod(method);
            
        } catch(Exception e) {
            Logger.getLogger(getClass().getName()).log(Level.SEVERE,"Attachment was not created ", e);
        } finally {
            method.releaseConnection();
        }
    }
    
    public void postTextComment(int issueId, Properties props, String text) {
        HttpClient client = new HttpClient();
        String cookie = login(props);
        //establish a connection within 5 seconds
        client.getHttpConnectionManager().
                getParams().setConnectionTimeout(20000);
        
        //client.getHostConfiguration().setProxy("host", 8080);
        PostMethod method = null;
        try {
            // we need to read 'longdesclength' hidden parameter from the issue page
            String longdesclength = getLongdesclength(issueId);
            
            method = new PostMethod(PROCESS_BUG_URL);
            
            method.getParams().setCookiePolicy(CookiePolicy.IGNORE_COOKIES);
            
            ArrayList<NameValuePair> data = new ArrayList<NameValuePair>();
            
            method.setRequestHeader("Cookie", cookie);
            data.add(new NameValuePair("id", issueId + ""));
            data.add(new NameValuePair("knob", "none"));
            data.add(new NameValuePair("longdesclength", longdesclength));
            
            data.add(new NameValuePair("comment", text));
                    
            NameValuePair[] values = new NameValuePair[data.size()];
            method.setRequestBody((NameValuePair[]) data.toArray(values));
            
            //execute the method
            client.executeMethod(method);
            
        } catch(Exception e) {
            Logger.getLogger(getClass().getName()).log(Level.SEVERE,"Comment was not added", e);
        } finally {
            method.releaseConnection();
        }
    }
    
    private void addComment(Exceptions exceptions, Properties props) {
        if (exceptions.getIssuezillaid() == null) {
            throw new java.lang.IllegalArgumentException("Exception report has not set issuezilla id");
        }
        Exceptions orig = getOriginal(exceptions);
        String cookie = login(props);
        HttpClient client = new HttpClient();
        //establish a connection within 5 seconds
        client.getHttpConnectionManager().
                getParams().setConnectionTimeout(20000);
        
        //client.getHostConfiguration().setProxy("host", 8080);
        PostMethod method = null;
        try {
            // we need to read 'longdesclength' hidden parameter from the issue page
            String longdesclength = getLongdesclength(orig.getIssuezillaid());
            
            method = new PostMethod(PROCESS_BUG_URL);
            
            method.getParams().setCookiePolicy(CookiePolicy.IGNORE_COOKIES);
            
            ArrayList<NameValuePair> data = new ArrayList<NameValuePair>();
            
            method.setRequestHeader("Cookie", cookie);
            data.add(new NameValuePair("id", orig.getIssuezillaid().toString()));
            data.add(new NameValuePair("knob", "none"));
            data.add(new NameValuePair("longdesclength", longdesclength));
            setIssueComment(data, exceptions);
            
            NameValuePair[] values = new NameValuePair[data.size()];
            method.setRequestBody((NameValuePair[]) data.toArray(values));
            
            //execute the method
            client.executeMethod(method);
            
        } catch(Exception e) {
            Logger.getLogger(getClass().getName()).log(Level.SEVERE,"Comment was not added", e);
        } finally {
            method.releaseConnection();
        }
    }
    
    private String getLongdesclength(int issue) throws IOException {
        String longdesclength = "0";
        HttpClient client = new HttpClient();
        //establish a connection within 5 seconds
        client.getHttpConnectionManager().
                getParams().setConnectionTimeout(20000);
        
        GetMethod formPage = new GetMethod("http://www.netbeans.org/nonav/issues/show_bug.cgi?id=" + issue);
        client.executeMethod(formPage);
        String form = new String(formPage.getResponseBody());
        String expression = "<input type=\"hidden\" name=\"longdesclength\" value=\"([0-9]*)\"./>";
        Pattern p = Pattern.compile(expression);
        Matcher m = p.matcher(form);
        boolean result = m.find();
        if (m.groupCount() > 1) {
            longdesclength = m.group(1);
        }
        return longdesclength;
    }
    
    private Exceptions getOriginal(Exceptions exc) {
        Exceptions orig = exc.getDuplicateof();
        return orig == null ? exc : orig;
    }
    
}
