/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.php.rt.providers.impl.local;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Collection;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.netbeans.modules.php.rt.WebServerRegistry;
import org.netbeans.modules.php.rt.providers.impl.HostImpl;
import org.netbeans.modules.php.rt.providers.impl.ServerCustomizerComponent;
import org.netbeans.modules.php.rt.spi.providers.Host;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/**
 *
 * @author  den
 */
public abstract class LocalWebServerPanelVisual extends ServerCustomizerComponent {

    private static final long serialVersionUID = -8570337844141338913L;

    private static final String TXT_DEFAULT_PORT = "TXT_DefaultPort"; // NOI18N
    private static final String MSG_WARNING_DOMAIN = "MSG_DomainWarning"; // NOI18N
    private static final String MSG_ILLEGAL_PATH = "MSG_IllegalPath"; // NOI18N
    private static final String MSG_INCORRECT_DOMAIN = "MSG_IncorrectDomainName"; // NOI18N
    private static final String MSG_ILLEGAL_FOLDER = "MSG_IllegalFolder"; // NOI18N
    private static final String MSG_FOLDER_NOT_WRITABLE = "MSG_FolderIsNotWritable"; // NOI18N
    private static final String MSG_DUPLICATE_HOST = "MSG_DuplicateHost"; // NOI18N
    private static final String SELECT_ROOT_LOCATION = "LBL_DocumentRootLocation"; // NOI18N
    private static final String BROWSE = "BROWSE"; // NOI18N

    protected static final String LOCALHOST = "localhost"; // NOI18N

    /** Creates new form LocalWebServerPanelVisual */
    public LocalWebServerPanelVisual() {
        initComponents();

    }

    protected abstract void setErrorMessage(String message);
    protected abstract void setDefaults();

    /**
     * adds listeners to editable text fields.
     * Should be invoked from inheritor's constructor 
     * (LocalServerCustomizerComponent, LocalConfigPanelComponent).
     * It is not invoked from LocalWebServerPanelVisual constructor
     * to make it possible for inheritor to set default values.
     */
    protected void initListeners() {
        setDefaults();

        DocumentListener listener = new TextFieldListener();
        
        getDocumentRoot().getDocument().addDocumentListener(listener);
        getPort().getDocument().addDocumentListener(listener);
        getDomain().getDocument().addDocumentListener(listener);
    }

    public void readValues(HostImpl host) {
        if (host != null) {
            assert host instanceof LocalHostImpl;
            
            LocalHostImpl impl = (LocalHostImpl) host;
            String path = (String) impl
                    .getProperty(LocalHostImpl.DOCUMENT_PATH);
            String port = (String) impl.getProperty(HostImpl.PORT);
            String domain = (String) impl.getProperty(HostImpl.DOMAIN);

            if (port == null || port.trim().length() == 0) {
                port = getMessage(TXT_DEFAULT_PORT);
            }

            getPort().setText(port);
            getDomain().setText(domain);
            getDocumentRoot().setText(path);
        }
        doContentValidation(false);
    }

    protected HostImpl storeValues(LocalServerProvider provider) {
        LocalHostImpl impl = createHostImpl(provider);

        impl.setProperty(LocalHostImpl.DOCUMENT_PATH, getDocumentRoot().getText());

        return impl;
    }

    private LocalHostImpl createHostImpl(LocalServerProvider provider) {
        LocalHostImpl impl = new LocalHostImpl(getDomain().getText(), getPort().getText(), provider);
        return impl;
    }

    public boolean doContentValidation() {
        boolean validateUnique = true;
        return doContentValidation(validateUnique);
    }

    public boolean doContentValidation(boolean validateUnique) {
        boolean isContentValid = validatePort() && validateDomain() && validatePath();
        if (!validateUnique) {
            return isContentValid;
        }
        return isContentValid && validateUnique();
    }

    public void doFinalContentValidation() {
        validateDomainFinaly();
    }



    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        myDomainLabel = new javax.swing.JLabel();
        myPortLabel = new javax.swing.JLabel();
        myDocumentRootLbl = new javax.swing.JLabel();
        myDomain = new javax.swing.JTextField();
        myPort = new javax.swing.JTextField();
        myRootLocation = new javax.swing.JTextField();
        myBrowse = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JSeparator();
        myWebServerLabel = new javax.swing.JLabel();
        jSeparator2 = new javax.swing.JSeparator();
        myFileSystemLabel = new javax.swing.JLabel();

        myDomainLabel.setLabelFor(myDomain);
        org.openide.awt.Mnemonics.setLocalizedText(myDomainLabel, org.openide.util.NbBundle.getMessage(LocalWebServerPanelVisual.class, "LBL_Domain")); // NOI18N

        myPortLabel.setLabelFor(myPort);
        org.openide.awt.Mnemonics.setLocalizedText(myPortLabel, org.openide.util.NbBundle.getMessage(LocalWebServerPanelVisual.class, "LBL_Port")); // NOI18N

        myDocumentRootLbl.setLabelFor(myDocumentRootLbl);
        org.openide.awt.Mnemonics.setLocalizedText(myDocumentRootLbl, org.openide.util.NbBundle.getMessage(LocalWebServerPanelVisual.class, "LBL_DocumentRoot")); // NOI18N

        myDomain.setText("");

        myPort.setDocument(new IntegerDocument());
        myPort.setText(org.openide.util.NbBundle.getMessage(LocalWebServerPanelVisual.class, "TXT_DefaultPort")); // NOI18N

        myRootLocation.setText("");

        org.openide.awt.Mnemonics.setLocalizedText(myBrowse, org.openide.util.NbBundle.getMessage(LocalWebServerPanelVisual.class, "LBL_Browse")); // NOI18N
        myBrowse.setActionCommand(BROWSE);
        myBrowse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                doBrowse(evt);
            }
        });

        myWebServerLabel.setFont(new java.awt.Font("Tahoma", 1, 11));
        myWebServerLabel.setText(org.openide.util.NbBundle.getMessage(LocalWebServerPanelVisual.class, "LocalWebServerPanelVisual.myWebServerLabel.text")); // NOI18N

        myFileSystemLabel.setFont(new java.awt.Font("Tahoma", 1, 11));
        myFileSystemLabel.setText(org.openide.util.NbBundle.getMessage(LocalWebServerPanelVisual.class, "LocalWebServerPanelVisual.myFileSystemLabel.text")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(myWebServerLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jSeparator1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 277, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(myPortLabel)
                            .add(myDomainLabel))
                        .add(38, 38, 38)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(myPort, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 32, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(myDomain, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 268, Short.MAX_VALUE)))
                    .add(layout.createSequentialGroup()
                        .add(myDocumentRootLbl)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(myRootLocation, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 177, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(myBrowse, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 85, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(layout.createSequentialGroup()
                        .add(myFileSystemLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jSeparator2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 274, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(myWebServerLabel)
                        .add(10, 10, 10))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 8, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myDomainLabel)
                    .add(myDomain, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myPortLabel)
                    .add(myPort, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(myFileSystemLabel)
                    .add(layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(jSeparator2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myDocumentRootLbl)
                    .add(myRootLocation, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(myBrowse))
                .addContainerGap(42, Short.MAX_VALUE))
        );

        myDomainLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalWebServerPanelVisual.class, "A11_DomainNameLbl")); // NOI18N
        myPortLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalWebServerPanelVisual.class, "A11_PortLbl")); // NOI18N
        myDocumentRootLbl.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalWebServerPanelVisual.class, "A11_DocumentRootLbl")); // NOI18N
        myDomain.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(LocalWebServerPanelVisual.class, "A11_DomainName")); // NOI18N
        myPort.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(LocalWebServerPanelVisual.class, "A11_Port")); // NOI18N
        myRootLocation.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(LocalWebServerPanelVisual.class, "A11_DocumentRoot")); // NOI18N
        myBrowse.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalWebServerPanelVisual.class, "A11_Browse")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void doBrowse(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_doBrowse
        String command = evt.getActionCommand();

        if (BROWSE.equals(command)) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(getMessage(SELECT_ROOT_LOCATION));
            chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
            String path = getDocumentRoot().getText();
            if (path.length() > 0) {
                File f = new File(path);
                if (f.exists()) {
                    chooser.setSelectedFile(f);
                }
            }
            if (JFileChooser.APPROVE_OPTION == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                getDocumentRoot().setText(projectDir.getAbsolutePath());
            }
            stateChanged();
        }
    }//GEN-LAST:event_doBrowse

    private boolean validatePath() {
        boolean empty = getDocumentRoot().getText().trim().length() == 0;
        File file = new File(getDocumentRoot().getText()).getAbsoluteFile();
        file = getCanonicalFile(file);
        if (empty || (file == null)) {
            setErrorMessage(getMessage(MSG_ILLEGAL_PATH));
            return false;
        }
        if (!file.isDirectory()) {
            setErrorMessage(getMessage(MSG_ILLEGAL_FOLDER));
            return false;
        }
        if (!file.canWrite()) {
            setErrorMessage(getMessage(MSG_FOLDER_NOT_WRITABLE));
            // It should be possible to set http root even if it is not writable.
            // And then set correct context in project
            //return false;
        }

        return true;
    }

    private boolean validatePort() {
        /*
         * This is check only for sure. No message will appear
         * as error in the case of error becuase port should
         * not be incorrect. It is prevented by special document in
         * port text field.
         */
        return isValidNumber(getPort().getText());
    }

    private boolean validateDomain() {
        String domain = getDomain().getText();
        if (domain == null || domain.trim().length() == 0) {
            setErrorMessage(getMessage(MSG_INCORRECT_DOMAIN));
            return false;
        }
        return true;
    }

    private void validateDomainFinaly() {
        /*
         * check is performed for notification only.
         * User could don't have direct connect to Internet and
         * in this case Proxy can be used ( for name resolution also ).
         */
        /*
         * check is performed for notification only.
         * User could don't have direct connect to Internet and
         * in this case Proxy can be used ( for name resolution also ).
         */
        String domain = getDomain().getText();
        if (!isValidInetAddress(domain)) {
            NotifyDescriptor descriptor = new NotifyDescriptor.Message(getMessage(MSG_WARNING_DOMAIN, domain));
            DialogDisplayer.getDefault().notify(descriptor);
        }
    }

    private boolean isValidInetAddress(String addressName) {
        boolean valid = true;
        try {
            InetAddress address = InetAddress.getByName(addressName);
            valid = address != null;
        } catch (UnknownHostException e) {
            valid = false;
        }
        return valid;
    }


    private boolean validateUnique() {
        Collection<Host> collection = WebServerRegistry.getInstance().getHosts();
        // create host with null provider. It is not necessary for comparison
        Host host = createHostImpl(null);
        boolean flag = collection.contains(host);
        if (flag) {
            setErrorMessage(getMessage(MSG_DUPLICATE_HOST, host));
        }
        return !flag;
    }

    private String getMessage(String key, Object... args) {
        String message = null;
        if (args.length > 0) {
            message = MessageFormat.format(NbBundle.getMessage(LocalConfigPanel.class, key), args);
        } else {
            message = NbBundle.getMessage(LocalConfigPanel.class, key);
        }
        return message;
    }

    static boolean isValidNumber(String str) {
        boolean flag;
        try {
            Integer.parseInt(str);
            flag = true;
        } catch (NumberFormatException e) {
            flag = false;
        }
        return flag;
    }

    public static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        } catch (IOException e) {
            return null;
        }
    }

    private static class IntegerDocument extends PlainDocument {

        private static final long serialVersionUID = -6127390393638310191L;

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {

            if (str == null) {
                return;
            }

            if (isValidNumber(str)) {
                super.insertString(offs, str, a);
            }
        }
    }

    private class TextFieldListener implements DocumentListener {

        public void changedUpdate(DocumentEvent e) {
            actionPerformed();
        }

        public void insertUpdate(DocumentEvent e) {
            actionPerformed();
        }

        public void removeUpdate(DocumentEvent e) {
            actionPerformed();
        }

        private void actionPerformed() {
            stateChanged();
        }
    }

    protected JTextField getPort() {
        return myPort;
    }

    protected JTextField getDocumentRoot() {
        return myRootLocation;
    }

    protected JTextField getDomain() {
        return myDomain;
    }

    //private LocalServerProvider getProvider() {
    //    return myProvider;
    //}


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JButton myBrowse;
    private javax.swing.JLabel myDocumentRootLbl;
    private javax.swing.JTextField myDomain;
    private javax.swing.JLabel myDomainLabel;
    private javax.swing.JLabel myFileSystemLabel;
    private javax.swing.JTextField myPort;
    private javax.swing.JLabel myPortLabel;
    private javax.swing.JTextField myRootLocation;
    private javax.swing.JLabel myWebServerLabel;
    // End of variables declaration//GEN-END:variables
    // End of variables declaration
    //LocalServerProvider myProvider;
}
