<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0">

  <xsl:output method="html" indent="yes"/>

  <!-- template rule matching source root element -->
  <xsl:template match="/">
    <html> <head> 
    <title>Java AVK for the Enterprise Report Tool </title>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
    <LINK href="./appVerification.css" rel="stylesheet" type="text/css"> 
    </LINK>
    </meta>
    </head>

    <xsl:apply-templates select="app-verification"/>
    </html>
  </xsl:template>

  <xsl:template match="app-verification">
     <body bgcolor="#FFFFFF" background="./Lt_BluePaperTexture.gif">
     <form method="post" action="">
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
           <tr bgcolor="7171A5">
             <td width="100%"> 
                <div class="page-title-text" align="left">Java AVK for the Enterprise - EJB Method Coverage Detail </div>
             </td>
           </tr>
        </table>

        <xsl:apply-templates select="enterprise-bean"/>

     </form>
     </body>
  </xsl:template>

  <xsl:template match="enterprise-bean">
  <xsl:variable name="app-name" select="normalize-space(app-name)"/>
  <xsl:variable name="jar" select="normalize-space(jar-name)"/>
  <xsl:variable name="bean" select="normalize-space(bean-name)"/>
  <a Name="{$app-name}{$jar}{$bean}"> </a>
  <table border="0" cellspacing="0" cellpadding="0" width="100%">
   <tr height="1">
   <td class="line-row" colspan="2" alt="" width="1" height="1" border="0"/>
   </tr>
   <tr> 
   <td width="35%" valign="top">
      <div class="table-title-text">Application File: </div>
   </td>
   <td width="65%">
     <div class="table-normal-text"><xsl:value-of select="app-name"/></div>
   </td>
   </tr>
   <tr>
   <td width="35%" valign="top">
      <div class="table-title-text">JAR File: </div>
    </td>
    <td width="65%">
     <div class="table-normal-text"><xsl:value-of select="jar-name"/></div>
    </td>
   </tr>
   <tr>
   <td width="35%" valign="top">
     <div class="table-title-text">EJB Name: </div>
    </td>
    <td width="65%">
     <div class="table-normal-text"><xsl:value-of select="bean-name"/></div>
    </td>
    </tr>
  </table>

  <table border="0" cellspacing="0" cellpadding="1" width="100%">
    <tr> 
    <td> 
       <div class="table-title-text">Methods Not Successfully Called </div>
      </td>
    </tr>
  </table>
  <table class="back-table" border="0" cellspacing="0" cellpadding="1" width="100%">
    <tr>
    <td>
    <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
     <tr class="header-row"> 
     <td width="80%"> 
         <div class="table-header-text" align="left">Method Signature </div>
     </td>
     <td width="20%"> 
        <div class="table-header-text" align="left">Status </div>
     </td>
     </tr>
     <tr height="1"> 
       <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
     </tr>

	<xsl:for-each select="method">
	 <xsl:variable name="counter" select="normalize-space(counter)"/>
	 <xsl:choose>
	    <xsl:when test="$counter='0'">
               <tr height="1"> 
                 <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
               </tr>
               <tr> 
               <td width="18%" valign="top"> 
                  <div class="table-normal-text"><xsl:value-of select="method-signature"/> </div>
      	       </td>
               <td width="18%" valign="top"> 
                  <div class="table-normal-text">Not Called </div>
      	       </td>
               </tr>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:if test="count(exception) !=0">
               <tr height="1"> 
                 <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
               </tr>
               <tr> 
               <td width="18%" valign="top"> 
                  <div class="table-normal-text"><xsl:value-of select="method-signature"/> </div>
      	       </td>
               <td width="18%" valign="top"> 
		  <xsl:variable name="method" select="normalize-space(method-signature)"/>
                  <div class="table-failed-text"><a href="ejbException.html#{$app-name}{$jar}{$bean}{$method}"><xsl:value-of select="count(exception)"/>Exceptions found </a></div>
      	       </td>
	       </tr>
	      </xsl:if> 
	    </xsl:otherwise>
	 </xsl:choose>
      </xsl:for-each>
   </table>
   </td>
   </tr>
   </table>

  <br>
  <table border="0" cellspacing="0" cellpadding="1" width="100%">
    <tr> 
    <td> 
       <div class="table-title-text">Methods Successfully Called </div>
      </td>
    </tr>
  </table>
  <table class="back-table" border="0" cellspacing="0" cellpadding="1" width="100%">
    <tr> 
    <td> 
    <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
      <tr class="header-row"> 
      <td width="80%"> 
         <div class="table-header-text" align="left">Method Signature </div>
      </td>
      <td width="20%"> 
        <div class="table-header-text" align="left">Status </div>
      </td>
      </tr>
      <xsl:for-each select="method">
	 <xsl:variable name="counter" select="normalize-space(counter)"/>
               <tr height="1"> 
                 <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
               </tr>
	    <xsl:if test="$counter!='0'">
               <tr> 
               <td width="18%" valign="top"> 
                  <div class="table-normal-text"><xsl:value-of select="method-signature"/> </div>
      	       </td>
               <td width="18%" valign="top"> 
                  <div class="table-normal-text">Called </div>
      	       </td>
               </tr>
	    </xsl:if>
      </xsl:for-each>
      </table>
     </td>
     </tr>
   </table>
   </br>
  </xsl:template>

</xsl:stylesheet>