/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#ifndef __CSDL_H__
#define __CSDL_H__

#include "SDL.h"

#define WINDOWED 0

class CSDL
{
	SDL_Surface* MainBuffer;
	int old;
	int scrnX,scrnY,scrnDepth,inAWindow,allowFlip;
	int x1,x2,y1,y2;
public:
	CSDL(int sx, int sy, int depth, bool old=false);
	~CSDL();
	void ChangeResolution(int sx,int sy,int depth);
	void Update();
	int GetScrnX();
	int GetScrnY();
	int GetScrnDepth();
	int GetWindow();	// a NOP, but I'll leave her in - DDOI
	//void BeginGDI();
	//void EndGDI();
	inline void* GetBackBuffer() { return MainBuffer->pixels; }
	void Flip();
	inline void DisableBufferFlip() { }
	inline void EnableBufferFlip() { }
	void SetViewport(int x,int y,int w,int h);
	void ResetViewport();
};

#endif
