/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


//---------------------------------------------------------------------------
#ifndef PLATFORM_UNIX
#error Do not compile in this file for Windows builds!
#endif
#include <iostream>
#include <stdlib.h>
#include "SDL.h"
#include "main_linux.h"

using namespace std;

//---------------------------------------------------------------------------

// Changed to 'Form1' to jive with main.cpp - DDOI
TForm1 *Form1;

int done = 0;

int main (int argc, char *argv[])
{
	bool dumb = true;	// Make this cleaner - DDOI
	SDL_Event event;
	
	if (SDL_Init (SDL_INIT_VIDEO | SDL_INIT_TIMER | SDL_INIT_AUDIO) < 0) {
		cerr << "Couldn't init SDL" << endl;
		exit (1);
	}

	if ((getenv ("OPENDUKE_NOGRAB")) == NULL)
		SDL_WM_GrabInput (SDL_GRAB_ON);
	SDL_ShowCursor (0);

	Form1 = new TForm1();
	
	Form1->FormCreate();
	Form1->FormActivate();
	
	while ( ! done ) {

		Form1->OnIdle(dumb);

		while ( SDL_PollEvent(&event) ) {
			if ( event.type == SDL_QUIT ) {
				  done = 1;
			}
			else if ( event.type == SDL_KEYDOWN ) {
			//rcg11032000 wrong method? KeyDown() is my call.
			//Form1->FormKeyPress((char) event.key.keysym.sym);
			    WORD feh = event.key.keysym.sym;
			    Form1->FormKeyPress(feh);
			    Form1->FormKeyDown(feh);
			}
			else if (event.type == SDL_KEYUP) {
				// STUB
			}
		}
	}

	Form1->FormDeactivate();
	Form1->FormClose();

	delete Form1;
	SDL_WM_GrabInput (SDL_GRAB_OFF);
	SDL_Quit();
#if 0
    hInst=_hInst;
    if (strcmp(cmdLine,"-g"))
    {
        graphicalConsole=0;
        AllocConsole();
        consoleScreenBuf=CreateConsoleScreenBuffer(
            GENERIC_READ|GENERIC_WRITE,0,NULL,
            CONSOLE_TEXTMODE_BUFFER,NULL);
        SetConsoleActiveScreenBuffer(consoleScreenBuf);
        SetConsoleTitle("Duke Nukem 3D Console");
        SetConsoleMode(consoleScreenBuf,0);
    }
    try
    {
         Application->Initialize();
         Application->Title = "Duke Nukem 3D";
         Application->CreateForm(__classid(TForm1), &Form1);
         Application->Run();
    }
    catch (Exception &exception)
    {
         Application->ShowException(&exception);
    }
#endif
    return 0;
}
//---------------------------------------------------------------------------
