/*
 * Package org.OpenJUMP.layer.style.classification pour JUMP
 *
 * Copyright (C) 2004
 * Olivier Bedel, ingnieur informaticien laboratoire Reso UMR ESO 6590, Bassin versant du Jaudy-Guindy-Bizien.
 * Cline Foureau, stagiaire MIAGE, laboratoire Reso UMR ESO 6590.
 * Erwan Bocher, doctorant en gographie, laboratoire Reso UMR ESO 6590, Bassin versant du Jaudy-Guindy-Bizien
 *
 * Date de cration : 19 aot 2004
 *
 * Dvelopp dans le cadre du Projet APARAD 
 *  (Laboratoire Reso UMR ESO 6590 CNRS / Bassin Versant du Jaudy-Guindy-Bizien)
 *    Responsable : Erwan BOCHER
 *    Dveloppeurs : Cline FOUREAU, Olivier BEDEL
 *
 * olivier.bedel@uhb.fr ou olivier.bedel@yahoo.fr
 * erwan.bocher@uhb.fr ou erwan.bocher@free.fr
 * celine.foureau@uhb.fr ou celine.foureau@wanadoo.fr
 * 
 * Ce package hrite de la licence GPL de JUMP. Il est rgi par la licence CeCILL soumise au droit franais et
 * respectant les principes de diffusion des logiciels libres. (http://www.cecill.info)
 * 
 */

package org.openjump.core.ui.style.classification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/** 
 * @author FOUREAU_C
 */

public class ComputeQuantile {
	public ComputeQuantile(List source, int nbClasse) {
		calculerQuantile(source, nbClasse);
	}

	private List classes = new ArrayList();

	private void calculerQuantile(List data, int nbClasse) {
		classes.clear(); //Liste qui va contenir les classes
		Interval classe = null; //1 classe

		//on trie les donnes
		Collections.sort(data);

		//on compte le nombre de valeur diffrentes et
		//on cr une liste de ses valeurs
		Number thisDataValue, nextDataValue;
		ArrayList listDifferentesValeurs = new ArrayList();
		thisDataValue = (Number) data.get(0);
		nextDataValue = (Number) data.get(1);
		int numberOfDifferentValues = 0;
		for (int j = 1; j <= data.size(); j++) {
			thisDataValue = (Number) data.get(j - 1);
			if (!(thisDataValue.equals(nextDataValue))) {
				numberOfDifferentValues = numberOfDifferentValues + 1;
				listDifferentesValeurs.add(thisDataValue);
				nextDataValue = thisDataValue;
			}
		}

		//nombre d'instance de la valeur en cour de classement
		int nclassestance = 1;
		//List permettant de mmoriser le nombre d'instance de chaque valeurs
		ArrayList instance = new ArrayList();

		//on compte le nombre d'instance de chaque valeur et on le memorise
		//dans la liste "instance"
		for (int k = 1; k <= data.size(); k++) {
			while (k < data.size() && data.get(k).equals(data.get(k - 1))) {
				nclassestance++;
				k++;
			}
			instance.add(new Integer(nclassestance));
			nclassestance = 1;
		}

		//nombre d'enregistrement par classe
		int quanta = data.size() / nbClasse;

		//nombre d'enregistrement restant
		int reste = data.size() % nbClasse;
		//taille de la classe en cours de cration
		int tailleClasseEnCour = 0;
		//nombre de valeurs dj classes
		int nbValeurClassee = 0;
		//nombre de classe crs
		int nbClasseCree = 0;

		//on cr les classes
		//Borne minimale de la classe en cours
		Number min = (Number) listDifferentesValeurs.get(0);
		//Borne maximale de la classe en cours
		Number max = null;

		//Si le nombre de classe demandes >= au nombre de valeurs duffrentes
		if (nbClasse >= numberOfDifferentValues) {
			//on cr une classe par valeur
			int l = 0;
			while (l < listDifferentesValeurs.size()) {
				classe =
					new Interval(
						(Number) listDifferentesValeurs.get(l), true,
						(Number) listDifferentesValeurs.get(l), true);
				classes.add(classe);
				l++;
			}
		} else {
			//Pour chacune des diffrentes valeur mmorises
			for (int l = 0; l < listDifferentesValeurs.size(); l++) {
				//Si le nombre de valeur ne correspond pas au nombre de classes demandes
				if (reste > 0) {
					//Si la taille de la classe en cours + le nombre d'instances de la
					//valeur en cour de classement est <= a la taille idale d'une classe + 1
					if (tailleClasseEnCour
						+ ((Integer) instance.get(l)).intValue()
						<= quanta + (reste / reste)) {
						//on classe la valeur dans la classe en cours
						tailleClasseEnCour =
							tailleClasseEnCour
								+ ((Integer) instance.get(l)).intValue();
						//la borne maximale de la classe devient la valeur que l'on vien de classer
						max = (Number) listDifferentesValeurs.get(l);
						//on incremente le nombre de valeur classes
						nbValeurClassee++;
					} else {
						//la taille de la classe en cour ne permet pas de mmoriser une nouvelle valeur
						if (tailleClasseEnCour == quanta + (reste / reste)) {
							//si la taille de la classe en cour est = a la taille idale d'une classe + 1
							//il reste une valeur de moins a classer
							reste--;
						}
						//on crer la classe en cours avec les bornes min et max
						classe = new Interval(min, true, max, true);
						//on insre cette classe dans la liste des classes
						classes.add(classe);
						//incrementation du nombre de classe cres
						nbClasseCree++;
						//mmorisation du nouveau min et du nouveau max
						min = (Number) listDifferentesValeurs.get(l);
						max = min;
						//initialistion de la taille de la classe en cour
						tailleClasseEnCour =
							((Integer) instance.get(l)).intValue();

						//Si le nombre de valeur qu'il nous reste a classer - le nombre de valeur
						//dja classes est gale au nombre de classe qu'il nous reste a crer
						if (numberOfDifferentValues - nbValeurClassee
							== nbClasse - nbClasseCree) {
							//on cree une classe par valeur restantes
							while (l < listDifferentesValeurs.size()) {
								classe =
									new Interval(
										(Number) listDifferentesValeurs.get(l), true,
										(Number) listDifferentesValeurs.get(l), true);
								classes.add(classe);
								l++;
							}
						}
					}
				} else {
					//le nombre de donnes a classer correspond au nombre de classe demandes
					//Si la taille de la classe en cours + le nombre d'instances de la
					//valeur en cour de classement est <= a la taille idale d'une classe
					if (tailleClasseEnCour
						+ ((Integer) instance.get(l)).intValue()
						<= quanta) {
						//on classe la valeur dans la classe en cours
						tailleClasseEnCour =
							tailleClasseEnCour
								+ ((Integer) instance.get(l)).intValue();
						//on initialise le nouveau max
						max = (Number) listDifferentesValeurs.get(l);
						//icrmentation du nombre de valeur classes
						nbValeurClassee++;
					} else {
						//si la taille de la classe que l'on va crer est infrieur au quanta on met a jour le reste
						if (tailleClasseEnCour < quanta) {
							reste = quanta - tailleClasseEnCour;
						}
						//la taille de la classe en cour ne permet pas de mmoriser une nouvelle valeur
						//on crer la classe en cours avec les bornes min et max
						classe = new Interval(min, true, max, true);
						//on insre cette classe dans la liste des classes
						classes.add(classe);
						//incrementation du nombre de classe cres
						nbClasseCree++;
						//mmorisation du nouveau min et du nouveau max
						min = (Number) listDifferentesValeurs.get(l);
						max = min;
						//initialistion de la taille de la classe en cour
						tailleClasseEnCour =
							((Integer) instance.get(l)).intValue();

						//Si le nombre de valeur qu'il nous reste a classer - le nombre de valeur
						//dja classes est gale au nombre de classe qu'il nous reste a crer	
						if (numberOfDifferentValues - nbValeurClassee
							== nbClasse - nbClasseCree) {
							//on cree une classe par valeur restantes
							while (l < listDifferentesValeurs.size()) {
								classe =
									new Interval(
										(Number) listDifferentesValeurs.get(l), true,
										(Number) listDifferentesValeurs.get(l), true);
								classes.add(classe);
								nbClasseCree++;
								l++;
							}
						}
					}
				}
			}
			//S'il reste une classe en cour, on la cr
			if (nbClasse - nbClasseCree == 1) {
				classe = new Interval(min, true, max, true);
				classes.add(classe);
			}
		}
	}
	public List getClasses() {
		return classes;
	}
}