/* GtkPopupMenuPeer.java -- Implements PopupMenuPeer with GTK+
   Copyright (C) 1999 Free Software Foundation, Inc.

This file is part of the peer AWT libraries of GNU Classpath.

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Library General Public License as published 
by the Free Software Foundation, either version 2 of the License, or
(at your option) any later verion.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; if not, write to the Free Software Foundation
Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307 USA. */


package gnu.java.awt.peer.gtk;
import java.awt.*;
import java.awt.peer.ComponentPeer;
import java.awt.peer.PopupMenuPeer;

public class GtkPopupMenuPeer extends GtkMenuPeer
  implements PopupMenuPeer
{
  public GtkPopupMenuPeer (PopupMenu menu)
  {
    super (menu);
  }

  native void setupAccelGroup (GtkGenericPeer container);

  void setParent (MenuItem item)
  {
    // we don't need to "add" ourselves to our parent
  }

  native void show (int x, int y, long time);
  public void show (Component origin, int x, int y)
  {
    Point abs = origin.getLocationOnScreen ();
    show (abs.x + x, abs.y + y, 0);
  }
}
