// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/base_natives/java_lang_thread_ia32.h,v 1.2 2001/08/03 03:13:10 xli18 Exp $
//



#ifdef ORP_POSIX


#define OS_HW_REGS_TO_ORP_THREAD_REGS()    assert(0);
#define OS_ORP_THREAD_REGS_TO_HW_REGS()    assert(0);
#define COUNTSTACKFRAME_MACRO()            assert(0);

#else

#define OS_HW_REGS_TO_ORP_THREAD_REGS()     \
    p_thr->regs.eax = nt_registers.Eax;     \
    p_thr->regs.ebx = nt_registers.Ebx;     \
    p_thr->regs.ecx = nt_registers.Ecx;     \
    p_thr->regs.edx = nt_registers.Edx;     \
    p_thr->regs.edi = nt_registers.Edi;     \
    p_thr->regs.esi = nt_registers.Esi;     \
    p_thr->regs.ebp = nt_registers.Ebp;     \
    p_thr->regs.esp = nt_registers.Esp;     \
    p_thr->regs.eip = nt_registers.Eip; 



#define OS_ORP_THREAD_REGS_TO_HW_REGS()     \
    nt_registers.Eax = p_thr->regs.eax;     \
    nt_registers.Ebx = p_thr->regs.ebx;     \
    nt_registers.Ecx = p_thr->regs.ecx;     \
    nt_registers.Edx = p_thr->regs.edx;     \
    nt_registers.Edi = p_thr->regs.edi;     \
    nt_registers.Esi = p_thr->regs.esi;     \
    nt_registers.Ebp = p_thr->regs.ebp;


#define COUNTSTACKFRAME_MACRO()                     \
    context.esp   = 0;                              \
    context.p_eip = &(context.eip);                 \
    context.p_ebp = 0;                              \
    context.p_ebx = 0;                              \
    context.p_esi = 0;                              \
    context.p_edi = 0;                              \
    context.ljf   = (uint32)p_orpthread->last_java_frame;

#endif
