// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/gc_tags.cpp,v 1.2 2001/08/13 09:59:51 xhshi Exp $
//

#include "defines.h"
#include "gc_tags.h"

unsigned GC_Tags_word_no(unsigned var_no) {
	return var_no >> 5;
}

unsigned GC_Tags_n_words(unsigned n_vars) {
	if (n_vars == 0)
		return 0;
	return GC_Tags_word_no(n_vars - 1) + 1;
}

unsigned GC_Tags_mask(unsigned var_no) {
	// grab lower 5 bits
	unsigned m = var_no & 0x001f;
	m = 1 << m;
	return m;
}

