// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/jit.h,v 1.6 2001/11/10 05:19:24 gwu2 Exp $
//



#ifndef _JIT_H_
#define _JIT_H_

#include "runtime_register_allocator.h"
#include "jit_intf.h"
#include "code_gen.h"
struct Profile_Rec;
struct Jit_Method_Info;

#include "bit_vector.h"

//enum   CODE_MI;

//
//	table entries that contain the number of outgoing args on the stack at each point
//	inside a call site (pushing args, looking up dest addr, calling, popping args).
//	initially, Call_Site_Info.esp_record points to a list of Stack_Pointer_Records, but
//	is later a pointer to an Esp_Record array once all the records have been constructed.
//
struct Stack_Pointer_Record {					// need a list while constructing all the records
	unsigned offset;
	unsigned args_on_stack;
	struct Stack_Pointer_Record *next;
};

struct Esp_Record {								// compact list entries to an array once all records are made
	unsigned offset;
	unsigned args_on_stack;
};


#ifdef VAR_CLONING
typedef unsigned Ref_Var_Bitmap_Type;
#define MAX_REF_VARS (sizeof(Ref_Var_Bitmap_Type)*8-1)
#define INVALID_RV_MASK (((unsigned) 1) << MAX_REF_VARS)
#define IS_INVALID_RV_BITMAP(_rv_bitmap) (_rv_bitmap & INVALID_RV_MASK)
#else // VAR_CLONING
#define IS_INVALID_RV_BITMAP(_rv_bitmap) (1)
#endif //VAR_CLONING


struct Runtime_Throw_Info {
	unsigned offset;      // of the next instruction
	unsigned try_index;
	Runtime_Throw_Info *next;
};


//
//	per-call-site-info
//
typedef struct Call_Site_Info {
	unsigned stack_depth;					// depth of mimic stack at the call site
	unsigned short num_out_args;			// number of outgoing arguments for this call
	unsigned short num_records;				// size of the esp_record array
	unsigned call_IP;						// address of the start of calling sequence (push args....)
	unsigned precall_IP;					// address of the actual call instruction
	unsigned ret_IP;						// address of the instruction immediately after the call
	struct Esp_Record *esp_record;			// array of args on the stack for each instr addr at call site
#ifdef LOCAL_CALLEE
	unsigned char  stack_ref_in_local_callee; // local callee regs contain reference
#endif
	unsigned char is_caller_pop;			// caller pops arguments
    unsigned char outarg_bv;                // which outargs are references
    unsigned char returns_ref;              // whether function returns a reference (in eax)
	unsigned short type_vector_length;		// type_vector array size
    void *m_handle;                         // used for finding refs in outargs
	char *type_vector;						// contains types of outgoing args and mimic stack entries
       const unsigned char *bc;  // bytecode position corresponding to this call site
	short register_mapping[4];				// which local variable is mapped to each callee-save register
} Call_Site_Info;

//
//	per-method info structure
//
//	---------------------------------
//	name							|
//	code_len						|
//	code							|
//	cnt								|
//	num_spills						|
//	num_extra						|
//	num_in_args						|
//	num_vars						|	Jit_Method_Info (per method info)
//	num_callee_saved_regs			|
//	num_call_sites					|
//	var_type_vector					|
//	cs_info[0]						|	<-- first entry in cs_info array (per call site info)
//	---------------------------------
//	....							|
//	cs_info[num_call_sites - 1]		|	space is left for other entries to cs_info array
//	---------------------------------
//	Esp_Record[0]					|
//	....							|	esp_records for each call site
//	Esp_Record[num_call_sites - 1]	|
//	---------------------------------
//	var_type_vector					|	type vectors, which are arrays of char. the macros below can be used to
//	type_vector[0]					|		access them.
//	....							|
//	type_vector[num_call_sites - 1]	|
//	---------------------------------
//	bytecode array					|	original bytecode array as given by the VM
//	---------------------------------


typedef struct Jit_Method_Info {
	const char *name;						// method name
	unsigned code_len;						// size of bytecode array
	const unsigned char *code;					// bytecode array (kept around for dataflow analysis)
	unsigned cnt;							// used to keep track of current call site
	unsigned num_spills;					// size of spill region
	unsigned num_gc_tag_words;				// # words used for tagging GC refs
	unsigned num_in_args;					// # incoming argument words
    unsigned num_vars;						// # local variable words (not including args); size of var_type_vector
    unsigned num_callee_saved_regs;			// # callee saved regs (total available)
    // Fill this in when I figure out where esi_local etc. and registers_saved
    // and vars_register_allocated are used.
    short esi_local;							// mapping of regs to local vars
    short edi_local;
    short ebx_local;
    short ebp_local;
    char *vars_register_allocated;
    unsigned char registers_saved;  // a bit vector
    struct Runtime_Register_Allocator rra;
    int regalloc_type;
#ifdef VAR_CLONING
	Ref_Var_Bitmap_Type ref_var_bitmap;		// which variables are references (needed for GC)
#endif //VAR_CLONING
	Runtime_Throw_Info *runtime_throws;

	Bit_Vector *is_visited;
	unsigned num_call_sites;				// # of call sites (size of cs_info array)
	char *var_type_vector;					// array of types for all local variables (not including incoming args)
    unsigned frame_size;                    // frame size
	unsigned is_esp_based;					// TRUE --> esp-based frame; FALSE --> ebp-based frame
	Call_Site_Info cs_info[1];				// array of per-call-site info
} Jit_Method_Info;


//
//	these accessor macros are used to tag storage locations as object references
//

#define REF_TYPE_CHAR	'R'		// indicates a storage location contains an obj ref
#define NO_TYPE_CHAR	'-'		// indicates a storage location does not contain an obj ref

//
//	var_type_vector :	varM		....		varN
//						 |						 |
//						 V						 V
//						var_type_vector[0]		var_type_vector[N-M-1]
//
//		where M == num_in_args, N == num_in_args + num_vars
//

// used to access var_type_vector. mi is a Jit_Method_Info *. v is the variable # (as in bytecodes).
#define GET_TV_VAR(mi,v)		((mi)->var_type_vector[(v)-(mi)->num_in_args])
#define SET_TV_VAR(mi,v)		(((mi)->var_type_vector[(v)-(mi)->num_in_args]]) = REF_TYPE_CHAR)
#define VAR_IS_LIVE(v)			0

//
//	type_vector :	stk0 .... stkN
//					  |
//					  V
//					type_vector[0]			 type_vector[N]
//
//		where N == cs_info[x].stack_depth
//

// used to access outgoing arg entries in some type vector. csi is a ptr to a cs_info[] entry. a is the arg #.
#define GET_TV_STACK(csi,a)	((csi)->type_vector[a])
#define SET_TV_STACK(csi,a)	((csi)->type_vector[a] = REF_TYPE_CHAR)

#define BINARY_CALL_SITE 15

void L1a_UnwindStackFrame_Full(
    Frame_Context *context,            /*INOUT*/
    void          *methodInfoPtr,      /* IN  */
    Boolean       isFirst,             /* IN  */
    void          *methodStart);       /* IN  */


void *L1a_FixHandlerContext(
    Frame_Context	*Context,
    void		    *methodStart,
    void		    *methodInfoPtr,
    void            *thrownObj);

void L1a_EnumerateGcRefs(
	Frame_Context	*context,
	void			*methodStart,
	void			*methodInfoPtr,
	GC_Enumeration_Handle			hCallback,
    Boolean          is_first);

unsigned l1a_num_breakpoints(
    Method_Handle method, 
    uint32        eip);

void l1a_get_breakpoints(
    Method_Handle method, 
    uint32        *bp, 
    Frame_Context *context);

void * l1a_get_address_of_this(
    Method_Handle meth,
    Frame_Context *context,
    Boolean       is_first);

unsigned compute_call_site_offset(
    Jit_Method_Info *method_info,
    DWORD           cur_IP,
    Boolean         isFirst);

Boolean l1a_call_returns_a_reference(
    Method_Handle         method,
    const Frame_Context  *context);

int32 l1a_get_break_point_offset(
    Compile_Handle compilation,
    Method_Handle  meth,
    JIT_Flags      flags,
    unsigned       bc_location);

void *l1a_get_address_of_var(
    Frame_Context *context,
    Boolean       is_first,
    unsigned      var_no);

void l1a_thread_recompile_methods(void *dummy);

JIT_Result l1a_compile_method(
    Compile_Handle  compilation,  
    Method_Handle   meth, 
    JIT_Flags       flags,
    CODE_MI         code_mi);

#endif // _JIT_H_
