// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/tail_recursion.h,v 1.2 2001/08/13 09:52:49 xhshi Exp $
//

#ifndef _TAIL_RECURSION_H_
#define _TAIL_RECURSION_H_

class Cfg_Node;  // forward declaration
class Call_Inst;

class Recursion {
public:
    Recursion *const next;
    Call_Inst *const call_i;
    Cfg_Node  *bb;
    Operand   *ptr; 

    Recursion(Cfg_Node *b,Call_Inst *c,Recursion *n) : bb(b), call_i(c), next(n), ptr(NULL) {}
    void *operator new(size_t sz,Mem_Manager& m) {return m.alloc(sz);}
};

class Tail_Recursion {
public:
    enum Kind {unknown, add, mul};
    Flow_Graph       *const fg;    // flow graph of the current method
    Mem_Manager&     mem;          // mem manager for building IR
    Expressions&     exprs;
    Compile_Handle   cmpl_handle;
    bool             gc_requires_write_barriers;

    Tail_Recursion(Compile_Handle ch, Flow_Graph *f, Mem_Manager& m, Expressions& e, bool wb) :
    cmpl_handle(ch), fg(f), mem(m), exprs(e), rec_ty(unknown), safe(false),
    gc_requires_write_barriers(wb){}
    void transform(Recursion* list);
private:
    Kind rec_ty;
    bool safe;

    bool side_effect(Recursion* r);
    bool recursion_is_unsafe(Recursion *list);
    bool unsafe_path(Recursion *list);
    Temp_Reg* gen_initial_value_of_result(O3_Jit_Type ty);
    void replace_ret_assignment(Recursion *list, Temp_Reg* result,Cfg_Node *entry);
    void clean_up_computation(Recursion *r, Temp_Reg* result);
    void mov_args_eliminate_call(Recursion *list);
    void mov_args_eliminate_calls(Recursion *list, Temp_Reg* result);
    void insert_jumps(Recursion *list);
    void mov_checking_vtable_to_entry(Recursion *list);
    void mov_vtable_checking(Recursion *list);
};

#define MAX_TAIL_RECURSION_SIZE 100

#endif // _TAIL_RECURSION_H_


