// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_io_FileOutputStream.cpp,v 1.4 2001/11/19 09:16:06 gwu2 Exp $
//



#include "platform.h"

#include <sys/types.h>
#include <sys/stat.h>

#ifdef ORP_NT
#include <io.h>
#endif

#include "native_utils.h"

#include "jni_direct.h"
#include "jni_utils.h"
#include "object_layout.h"

#include <fcntl.h>

#ifdef ORP_NT
#include <direct.h>
#elif defined (ORP_POSIX)
#include <unistd.h>
#endif

#include <errno.h>

#include "java_io_FileOutputStream.h"
#include "gnu_classpath_jni_utils.h"

/*
 * Class:     FileOutputStream
 * Method:    closeInternal
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_java_io_FileOutputStream_closeInternal
  (JNIEnv *jenv, jobject jobj, jint file_d)
{
	//The finalizer of FileOutputStream will call this function regardless
	// of whether close() has been called, so we should check here
	if(file_d == -1)return; //already closed
	
	//we don't close in/out/err, there're such attempts in FileXputStream.finalize()
	if(file_d <= 2) 
		return;
		
	jint ret = close(file_d);
	if (ret) { 
		// Throw IOException since write failed somehow.. use strerror(errno)
		throw_exception_from_jni(jenv, "java/io/IOException", "close() failed");
		return;
	}
	return;
}


/*
 * Class:     FileOutputStream
 * Method:    open
 * Signature: (Ljava/lang/String;Z)I
 */
JNIEXPORT jint JNICALL Java_java_io_FileOutputStream_open
  (JNIEnv *jenv, jobject jobj, jstring jpath, jboolean append)
{
	jboolean is_copy;
	const char *path = jenv->GetStringUTFChars(jpath, &is_copy);
	assert(path); 
	
	int fmode = O_CREAT;
	
#ifdef ORP_NT
    // Rope in _O_BINARY so that Ctrl-Z will not be interpreted as an EOF indicator, 
    // and translations are suppressed. Is it okay to have this ALWAYS ??? BUG?????
    fmode |= O_BINARY;
#endif
    fmode |= O_WRONLY;
    if (append) {
        fmode |= O_APPEND;
    } else {
        fmode |= O_TRUNC;
    }

	// Actually open the file; use default permissions

	int file_descr = open(path, fmode, 0755);

	if (file_descr == -1) {
		char *msg = (char *) malloc(300);
#if 0 
		// Need to get strerror() working...23 compile errors!	
		sprintf(msg, "%s: %s", path, strerror (errno));
#else
		strcpy(msg, "Open failed???");
#endif

		throw_exception_from_jni(jenv, "java/io/FileNotFoundException", msg);
		free(msg);
	}
	return file_descr;
}

/*
 * Class:     FileOutputStream
 * Method:    writeInternal
 * Signature: (I[BII)V
 */
JNIEXPORT void JNICALL Java_java_io_FileOutputStream_writeInternal
  (JNIEnv *jenv, jobject jobj, jint fd, jbyteArray barr, jint offset, jint len)
{
	if (!barr) { 
		// Throw NullPointerException
		throw_exception_from_jni(jenv, "java/lang/NullPointerException", 
					"Null pointer passed to write()");
		return;
	}
	int array_len = jenv->GetArrayLength(barr);
	if ((len < 0) || (offset < 0) || (offset + len > array_len)) {
		// Throw IndexOutOfBoundsException
		throw_exception_from_jni(jenv, "java/lang/IndexOutOfBoundsException", 0);
		return;
	}
	jboolean is_copy;
	jbyte *jbytes = jenv->GetByteArrayElements(barr, &is_copy);
	assert(jbytes);

    int ret = write(fd, &jbytes[offset], len);

#if 0 
	// Code below can be activated only when the native method currentThread() is 
	// implemented in java/lang/Thread.

	if (thread_was_interrupted(jenv)) {
		// Throw InterruptedIOException since thread was interrupted.
		throw_exception_from_jni(jenv, "java/io/InterruptedIOException",
						"write was interrupted");
		return;
	} else if (ret == -1) {
		// Throw IOException since write failed somehow.. use strerror(errno)
		throw_exception_from_jni(jenv, "java/io/IOException", 0);
		return;
	}
#else
    
 	// No "interrupted" check for now.
	if (ret == -1) {
		// Throw IOException since read failed somehow.. use strerror(errno)
		throw_exception_from_jni(jenv, "java/io/IOException", strerror(errno));
		return;
	}
	assert(ret >= 0);

#endif
	
	jenv->ReleaseByteArrayElements(barr, jbytes, JNI_ABORT);
	return;
}
