// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/los_container.cpp,v 1.2 2001/08/03 03:13:42 xli18 Exp $
//

 
#include "gc_for_orp.h"
 
#include "los.h"
#include "los_container.h"
extern bool verbose_gc;

#include "root_set_enum.h"
#include "orp_threads.h"

#ifdef ORP_POSIX
#include "platform2.h"
#endif

// The backup stores are set to zero for the non-concurrent GC code.
#ifdef GC_SAPPHIRE
int initial_backup_object_stores;;
int backup_object_stores;
#else
int initial_backup_object_stores = 0;
int backup_object_stores = 0;
#endif // GC_SAPPHIRE


LOS_Container::LOS_Container(Gc_Interface  *p_gc_interface,
                             Gc_Fast_Hooks *p_gc_hooks,
                             Gc_Plan       *p_gc_plan,
		                     Generation    *p_container,
		                     Card_Table    *p_card_table,
			                 Block_Store   *p_bs)

             : Gc_Component(p_gc_hooks, 
                            p_gc_plan,
                            p_bs)
{
	//
	// Create only one LOS for starters. Others will be
	// created upon demand.
	//
    _p_card_table = p_card_table;
    _p_container = p_container;
	_number_of_large_object_stores = p_gc_plan->number_of_large_object_stores ();;
    _los_block_size_bytes = p_gc_plan->los_block_size_bytes ();
    _p_gc_interface = p_gc_interface;

    // Create a bunch of Large Object Stores so most threads
    // can have their own free list.
    for (int i = 0; i<_number_of_large_object_stores ;i++) {
        _p_los_array[i] = new Large_Object_Store(p_gc_interface,
		    						             p_gc_hooks,
			    					             p_gc_plan,
				    				             p_container,
					    			             p_card_table,
						    		             p_bs,
                                                 this);
    }
#ifdef GC_SAPPHIRE
    // Reserve unused space so GC can happen while we have space to allocate in.
    initial_backup_object_stores = _number_of_large_object_stores/2;
    backup_object_stores = initial_backup_object_stores;
#endif // GC_SAPPHIRE
}

void LOS_Container::add_los (Large_Object_Store *an_los)
{
    // zero based.
    _p_los_array[_number_of_large_object_stores] = an_los;
    _number_of_large_object_stores++;
//    orp_cout << " We now have " << _number_of_large_object_stores << endl;
}

     // #ifdef GC_MARK_FLAGS implements non-resident mark bits.
void LOS_Container::clear_mark_bits ()
{
	for (int los_idx = 0; 
	         los_idx < _number_of_large_object_stores;
			 los_idx++) {
				 _p_los_array[los_idx]->clear_mark_flags();
	}
}
    // #endif GC_MARK_FLAGS
//

//
// We failed to allocate an object even after triggering a
// collection. This is the time to try to extend the LOS.
//

void 
LOS_Container::extend_los(unsigned int segment_size_bytes)
{
//    orp_cout << "Debug - not extending LOS, we could run out." << endl;
//    return;
	assert(_p_container);

    if (stats_gc) {
        orp_cout << " ** out of LOS, extending for " << segment_size_bytes << endl;
    }

    // First see if the segment_size_bytes that we need will fit into 
    // the LOS increment size.
    unsigned int size_to_extend_bytes = _los_block_size_bytes;

    if (segment_size_bytes > size_to_extend_bytes) {
        size_to_extend_bytes = segment_size_bytes;
    }

    // Normalize the size to extend to something that falls on a block boundary.

    size_to_extend_bytes = p_global_bs->size_up_to_los_block_size(size_to_extend_bytes);

    // Remember the largest requested size since that will be the size we
    // will allocate from now on. 
    //
    // THIS IS A POLICY DECISION THAT CAN BE TUNED.
    //

    _p_gc_plan->set_los_block_size_bytes (size_to_extend_bytes);

    assert (_p_container);

    Large_Object_Store *new_store 
        = new Large_Object_Store (_p_gc_interface,
                                  _p_gc_hooks,
    					          _p_gc_plan,
								  _p_container,
								  _p_card_table,
								  p_global_bs,
                                  this);

    add_los (new_store);

    return;

    //  We need to add some failure code that will insist that we do a collection.
    //  ...

    // BUG BUG BUG
    // For now just blow up instead of throwing an out of memory exception.
    
    orp_cout << " ** out of LOS ** " << endl;
    assert (0);
    // BUG BUG BUG Until better debugged.
	return;

}


void
LOS_Container::cleanup()
{
    int los_idx;
	for (los_idx = 0; los_idx < _number_of_large_object_stores; los_idx++) {
        if (_p_los_array[los_idx]->get_lock_owner() == p_TLS_orpthread) { 
            assert (0); // GC is done without any los locks. 
		    _p_los_array[los_idx]->cleanup();
            // Do not release the lock.
        } else {
            int count = 0;
            bool done = false;
            while (!done) {
                if (_p_los_array[los_idx]->try_lock()) {
                    _p_los_array[los_idx]->cleanup();
                    _p_los_array[los_idx]->release_lock();
                    done = true;
                }
                count++;
                if (count > 100) {
                    count = 0;
                    done = true;
                    // If we aren't concurrent a thread may have this lock 
                    // and be stopped waiting
                    // for the gc lock. The area will be collected next time
                    // around..
#ifdef GC_SAPPHIRE
                    // If we are out of space all the threads will be holding this lock
                    // and stuck at the sapphire_enum_or_null.
                    orp_cout << "los area locked while trying to relink free list" << endl;
                    orp_cout << "ignoring this los area til next time." << endl;
                    done = true; // get it next time - statistically a reasonable thing.
#endif // GC_SAPPHIRE
                }
            }
        }
	}
}

//
// No more LOS, even after a collection.
//
void
LOS_Container::_notify_large_object_store_exhausted_error(unsigned int size)
{
#if (GC_DEBUG>2)
	assert(_p_container);
#endif
	cout << "Error: Large Object Space Exhausted when allocating ";
	cout << size << " bytes" << endl;

//    dump_stats();

	orp_exit(1);
}

// External from root_set_enum.h.
Boolean orp_is_gc_disabled(void *thread_id);

//
// Allocate an object into large object space.
//
int _calls_to_pinned_malloc = 0;
int _pinned_malloc_size_allocated = 0;
int _los_to_start_using = 0;

Java_java_lang_Object  *
LOS_Container::gc_pinned_malloc(unsigned size, 
		                        Partial_Reveal_VTable *p_vtable,
				                bool return_null_on_fail,
                                bool double_align
                                )
{

    assert (orp_is_gc_disabled(p_TLS_orpthread));
#if 0 // Use to eliminate some of the WB issues.
    if (global_safepoint_status == enumerate_the_universe)  {
                // Some other thread is doing a GC so we only have to wait for
                // it to finish.
        
                orp_cout << "Halting thread in gc_pinned_malloc." << endl;
                orp_enable_gc();
                p_gc_lock->_lock_enum(); // The other thread has the gc_lock so we wait.
                orp_disable_gc();
           	    p_gc_lock->_unlock_enum();
    }
#endif 
    _calls_to_pinned_malloc++;
    _pinned_malloc_size_allocated += size;

    // Number of times you tried to allocate some space.
    int attempt = 0;
	//
	// Try more than one time. If the first time fails, a collection will
	// be triggered, and under normal conditions the second
	// attempt should succeed. It is possible that a race condition
    // is causing LOS space to be eaten up by another thread. I am not
    // prepared to grab the gc_lock but perhaps some future code will
    // deal with this race condition.
	//
    int number_of_gcs = 0;
    int unlocked_los_count = 0;
    int start = _los_to_start_using;
    assert (_los_to_start_using < _number_of_large_object_stores);
    // Keep track on how successful we are at getting a lock.
    int _failed_to_get_lock = 0;
    int _got_lock = 0;
    int contention_metric = 0; // increment when you have trouble getting a lock

    int local_gc_count = global_gc_count;
    while (attempt++ < 48) {
        int object_stores_to_use = _number_of_large_object_stores - backup_object_stores;
        assert (_number_of_large_object_stores >= (backup_object_stores * 2));

        local_gc_count = global_gc_count;

        // The first attempt starts at start and goes to the end of the loses
        // The second attempt start at 0 and goes through all the loses.
        // The third attempt does a GC
        // The fourth attempt adds another los.
        // We then repeat the process until we find some space.
        int idx;
    	//
    	// Run through all the LOSes looking for some space.
	    // 
        Java_java_lang_Object *result = NULL;
		// This loop is the same as the one below and should remain that way.
        for (int do_twice=0; do_twice < 2; do_twice++) {
    	    for (idx = start; idx < object_stores_to_use; idx++) {

                // The lock uses p_TLS_orpthread to know who grabbed the lock. 
                // The get_lock_owner is important since the GC needs it to know
                // if the thread it is running in has a lock.

                if (_p_los_array[idx]->get_lock_owner() == NULL) { 
                    // lock is free
                    if (_p_los_array[idx]->try_lock()) {
                        // We have the lock for this the idx los.    
                        _got_lock++;
                        result = _p_los_array[idx]->gc_pinned_malloc(size,
	        	                                                     p_vtable,
		        	        							             return_null_on_fail,
                                                                     double_align
                                                                    );
                        if (result) {
                            _los_to_start_using = idx;
#ifdef GC_SAPPHIRE
                            // If we are in Sapphire doing a concurrent MS GC 
                            // and the allocation of a new object is in the C space
                            // Which it is when we are just doing a simple MS then the
                            // object is allocated black.
                            if (p_TLS_orpthread->gc_sapphire_status != sapphire_normal) {
                                // We don't have to scan it since it only contains 
                                // empty slots.
                                set_object_marked (result);
                            }                       
#endif
                            _p_los_array[idx]->release_lock(); // release the lock
                            assert (orp_is_gc_disabled(p_TLS_orpthread));
                            return result; // Success.
                        } else {
                            _p_los_array[idx]->release_lock(); // failed but release the lock
                            unlocked_los_count++;
                        } //if (result) {
                    } else { // We tried the lock and it was taken between the time
                        // it was free and we were able to grab it.
//                        orp_cout << "fc";                    
                        _failed_to_get_lock++;
                    } // if (_p_los_array[idx]->try_lock()) {
               } else {
//                    orp_cout << "fu";
                    _failed_to_get_lock++;
               } // (_p_los_array[idx]->get_lock_owner() == NULL)
            } // for (idx = _los_to_start_using
        
            // Second loop will start at the first LOS 
            // and continue to the end unless
            // it locates some free space.
            start = 0;
            if (_failed_to_get_lock < _got_lock) {
                _los_to_start_using = 0; // Tell other threads to start at 0.
            } else {
//                if (contention_metric) {
//                    assert (contention_metric < 8); // 
//                }
                contention_metric++;    // We have a lock contention problem not an out of space problem.
            }
        } //         for (int do_twice=0; do_twice < 2; do_twice++) {
        
        if (return_null_on_fail) {
            return result;
        }
        
        //
        // We fail on the first attempt will either wait while some 
        // other thread is doing a GC or will fire up one itself.
        //
        // By convention the caller of notify_out_of_space holds the gc lock.
        //

        if (number_of_gcs > 32) {
            // Give up.    
          	_notify_large_object_store_exhausted_error(size);
            return NULL;
        }

#ifdef GC_SAPPHIRE
        if (global_safepoint_status == enumerate_the_universe)  {
            // Use the spare stores.
            backup_object_stores = 0;
            orp_cout << "Using backup stores." << endl;
            // Try again before you just sit around and wait.
            // Some other thread is doing a GC so we only have to wait for
            // it to finish. Good tuning should avoid this.
//            orp_cout << "Waiting in gc_pinned_malloc for GC to complete." << endl;
//            orp_enable_gc();
//            p_gc_lock->_lock_enum(); // The other thread has the gc_lock so we wait.
//            orp_disable_gc();
//   	        p_gc_lock->_unlock_enum();
        } else {
            int local_gc_count = global_gc_count;
            assert(orp_is_gc_enabled(p_TLS_orpthread) == false );
            orp_enable_gc();
            // Hmmm, we might backup here.
//            orp_cout << "Collecting" << endl;
   	        p_gc_lock->_lock_enum();                                   // vvv
            orp_disable_gc();

            if (local_gc_count == global_gc_count) {
                // Noone else has done a GC since we started to do a GC so 
                // do the GC.
//                orp_cout << " _calls_to_pinned_malloc = " << _calls_to_pinned_malloc << endl;
//                orp_cout << " _pinned_malloc_size_allocated = " << _pinned_malloc_size_allocated << endl;
// other threads will know when to use the backups.  backup_object_stores = 0; // Use the backups


                _p_gc_interface->notify_out_of_space (size);
                backup_object_stores = initial_backup_object_stores;
                number_of_gcs++;

            }
            assert (p_TLS_orpthread->gc_enabled_status == disabled);
       	    p_gc_lock->_unlock_enum();                                 //  ^^^
        } //if (global_safepoint_status == enumerate_the_universe)
#else
        
        orp_enable_gc();
        // Hmmm, we might backup here.
//        orp_cout << "Collecting" << endl;
        p_gc_lock->_lock_enum();                                   // vvv
        orp_disable_gc();
        _p_gc_interface->notify_out_of_space (size);
        p_gc_lock->_unlock_enum();                                     // ^^^
        number_of_gcs++;
#endif // GC_SAPPHIRE
        
        // Try before we extend.
        if ((attempt > 4) || contention_metric > 6) {
            // We (or some other thread) has done a lot of gcs since we started
            // so lets try extending the heap or we are having trouble getting a
            // lock. In either case extend the heap.
            orp_enable_gc();
      	    p_gc_lock->_lock_enum();                                       // vvv
            orp_disable_gc();
	        // Seems we have tried collecting without any success.
	        // extend the heap and keep trying.
//	        extend_los (size);
//            start = _number_of_large_object_stores - 1;
            // release the lock, let others acquire it if need be. 
   	        p_gc_lock->_unlock_enum();                                     // ^^^
            attempt = 0; // try again.
        }
        assert (!return_null_on_fail);

        assert(orp_is_gc_enabled(p_TLS_orpthread) == false );
        
        // We have just done a collection, and extended the heap. Loop and try to allocate again.
    }

    assert (0); // The above should either allocate an object, or die trying.
    //
    // If we are here we have tried many times to get the space we needed and
    // each time we have failed. This is serious. Some future code will need to
    // mine other areas for space or will stop other threads. Even this will probable
    // fail.
    //
	// Looks like there is no hope. Bail out as best we can.
	//
	_notify_large_object_store_exhausted_error(size);
    // LeaveCriticalSection(&_lock);
	//unlock();

	return NULL;
}//
 

//
// A special version during bootstrapping for objects
// that still don't have classes.
//
Java_java_lang_Object  *
LOS_Container::gc_pinned_malloc_noclass(unsigned size)
{
	//
	// FOR THE TIME BEING, HARD WIRE IT TO THE ONLY LOS:
	// 

	return _p_los_array[0]->gc_pinned_malloc_noclass(size);
}

#ifdef GC_STATS
void
LOS_Container::prepare_for_collection()
{

	for (int idx = 0; 
	         idx < _number_of_large_object_stores;
			 idx++) {

		_p_los_array[idx]->prepare_for_collection();
	}
}
#else

void
LOS_Container::prepare_for_collection()
{
}
#endif

void 
LOS_Container::set_generation(Generation *p_gen) 
{
	//
	// FOR THE TIME BEING, HARDWIRE THIS. NOTE THAT
	// WE WILL NEED TO DYNAMICALLY SET THIS FOR ALL
	// FUTURE LOSs THAT ARE CREATED.
	//
	for (int idx = 0; 
	         idx < _number_of_large_object_stores;
			 idx++) {

		_p_los_array[idx]->set_generation(p_gen);
	}
}

//
// Is there a block of this size available, if not caller will
// extend heap.
//
bool
LOS_Container::is_block_available(unsigned int size)
{
	for (int idx = 0; idx < _number_of_large_object_stores; idx++) {
        if (_p_los_array[idx]->is_block_available(size)) {
            return true;
        }
	}
    return false;
}
// end file los_container.cpp

