// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/remembered_set.cpp,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

#include "remembered_set.h"
#include "gc_header.h"
#include "train_generation.h"

#if 1 // (GC_DEBUG>2) changes when we change add_entry code.
#include "gc_space.h"
#include "Block_Store.h"
extern Block_Store *p_global_bs;
#endif // _DEBUG

// Override the add_entry to do check to ensure pointer is valid.

//
// Add an entry into this hash table, if it doesn't already exist.
//

#if 1 // (GC_DEBUG>2) also change remember_set.h definition.
// For now remove the inline so we can check for valid references.
//    inline 
unsigned 
Remembered_Set::add_entry(Java_java_lang_Object **address)
{
    assert ((*address == NULL) ||
        (p_global_bs->is_address_in_heap(*address)));
    assert ((*address == NULL) || (! p_global_bs->is_obsolete_object (*address)));

    return Hash_Table::add_entry((void *)address);
}
#endif // GC_DEBUG>2
//
// Clone myself.
//
Remembered_Set *
Remembered_Set::p_clone()
{
#if (GC_DEBUG>2)
    //
    // May not clone in the middle of a scan.
    //
    assert(_table_state != scanning);
#endif 

    Remembered_Set *p_cloned_rs = new Remembered_Set();

    rewind();
    
    Java_java_lang_Object **pp_obj_ref;
    while ((pp_obj_ref = next()) != NULL) {
        p_cloned_rs->add_entry(pp_obj_ref);
    }
#if (GC_DEBUG>2)
    _table_state = scanned;
#endif 

    rewind();
    p_cloned_rs->rewind();

    return p_cloned_rs;
}

#if 0 // UNNECESSARY ??
//
// This is a higher-speed version of the step-generation's
// _reflect_tenuring_in_write_barrier. It searches for entries
// into younger space that have to be updated due to the recent
// tenuring, and updates appropriately.
//
void Remembered_Set::reflect_tenuring(Java_java_lang_Object *p_old,
                                      Train_Generation  *p_mature_generation) 
{       

    for (int index = 0; index < _size_in_entries; index++) {

        Java_java_lang_Object **pp_ref = (Java_java_lang_Object **)_table[index];

        if ((pp_ref != NULL) && (*pp_ref == p_old)) {
            //
            // OK, we got a match. Update this to reflect the recent tenuring.
            //
            update_reference_forwarded(pp_ref);
            //
            // Remove this entry from the remembered set.
            //
            _table[index] = 0;
            //
            // May need to update inter-car remembered sets
            //
            p_mature_generation->add_entry_to_generation_write_barriers(pp_ref,
                                                                        *pp_ref);
        }
    }
}
#endif



#if (GC_DEBUG>3)
//
// Given a remembered set, verify that there are no pointers to
// objects that are dead.
//
void 
Remembered_Set::verify_no_obsolete_references()
{
	int index;

	for (index = 0; index < _size_in_entries; index++) {
        Java_java_lang_Object **pp_obj_ref =
            (Java_java_lang_Object **)_table[index];

        //
        // Filter out empty slots in the table.
        //
        if (pp_obj_ref != NULL) {
            
            Java_java_lang_Object *p_obj = *pp_obj_ref;

            if (p_obj != NULL) {
                if (!is_java_object(p_obj)) {
                   assert (0);
                }
            }

            //
            // Filter out those that are not in the GC heap
            //        
            if (p_global_bs->is_object_in_heap(p_obj)) {

                Gc_Space *p_gc_space = p_global_bs->p_get_object_container(p_obj);

                if (p_gc_space->is_obsolete()) {
                    //
                    // Found a reference to an obsolete object.
                    //
					cout << "Error: obsolete reference in remembered set" << endl;
                    orp_exit(1);
                }

                if (is_object_forwarded(p_obj)) {
                        //
                        // Forwarded objects are unexpected during this scan.
                        //
                    if (p_gc_space->is_large_object_space()) {
                        //
                        // This is ok - LOS hasn't had a chance to clean up.
                        //
                        continue;
                    } else {
                        //
                        // Found an illegal forwarded object in a valid container.
                        //
						cout << "Error: illegally forwarded object in valid container" << endl;
                        assert(0);
                        orp_exit(1);
                    }
                }
            }
        }
	}

}
#endif

// end file gc\remembered_set.cpp


