/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This file is part of SableCC.                             *
 * See the file "LICENSE" for copyright information and the  *
 * terms and conditions for copying, distribution and        *
 * modification of SableCC.                                  *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

package org.sablecc.sablecc.node;

import org.sablecc.sablecc.Switch;
import org.sablecc.sablecc.analysis.Analysis;

public final class Grammar1 extends Grammar
{
    public void apply(Switch sw)
    {
        ((Analysis) sw).caseGrammar1(this);
    }

    public String toString()
    {
        return ""
            + node1
            + node2
            + node3
            + node4
            + node5
            + node6;
    }

    private PackageOpt node1;

    public PackageOpt getNode1()
    {
        return node1;
    }

    public void setNode1(PackageOpt node)
    {
        if(node1 != null)
        {
            node1.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node1 = node;
    }

    private HelpersOpt node2;

    public HelpersOpt getNode2()
    {
        return node2;
    }

    public void setNode2(HelpersOpt node)
    {
        if(node2 != null)
        {
            node2.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node2 = node;
    }

    private StatesOpt node3;

    public StatesOpt getNode3()
    {
        return node3;
    }

    public void setNode3(StatesOpt node)
    {
        if(node3 != null)
        {
            node3.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node3 = node;
    }

    private TokensOpt node4;

    public TokensOpt getNode4()
    {
        return node4;
    }

    public void setNode4(TokensOpt node)
    {
        if(node4 != null)
        {
            node4.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node4 = node;
    }

    private IgnTokensOpt node5;

    public IgnTokensOpt getNode5()
    {
        return node5;
    }

    public void setNode5(IgnTokensOpt node)
    {
        if(node5 != null)
        {
            node5.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node5 = node;
    }

    private ProductionsOpt node6;

    public ProductionsOpt getNode6()
    {
        return node6;
    }

    public void setNode6(ProductionsOpt node)
    {
        if(node6 != null)
        {
            node6.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node6 = node;
    }

    void removeChild(Node child)
    {
        if(node1 == child)
        {
            node1 = null;
        }

        if(node2 == child)
        {
            node2 = null;
        }

        if(node3 == child)
        {
            node3 = null;
        }

        if(node4 == child)
        {
            node4 = null;
        }

        if(node5 == child)
        {
            node5 = null;
        }

        if(node6 == child)
        {
            node6 = null;
        }

    }
}

