#include "rpggame.h"

namespace entities
{
	vector<extentity *> ents;

	vector<extentity *> &getents() { return ents; }

	bool mayattach(extentity &e) { return false; }
	bool attachent(extentity &e, extentity &a) { return false; }

	const char *entmodel(const entity &e)
	{
		return NULL; //till we get to them that is
	}
	const char *entnameinfo(entity &e)
	{
		rpgentity &f = (rpgentity &) e;
		return f.name;
	}

	extentity *newentity() { return new rpgentity(); }
	void deleteentity(extentity *e) { delete (rpgentity *)e; }

	void fixentity(extentity &e)
	{
		switch(e.type)
		{
			case TELEDEST:
			case CHECKPOINT:
			case SPAWN:
				e.attr8 = e.attr7;
				e.attr7 = e.attr6;
				e.attr6 = e.attr5;
				e.attr5 = e.attr4;
				e.attr4 = e.attr3;
				e.attr3 = e.attr2;
				e.attr2 = e.attr1;
				e.attr1 = game::player1->yaw;
		}
	}

	void clearents()
	{
		while(ents.length()) deleteentity(ents.pop());
	}

	void entradius(extentity &e, bool &color)
	{
		rpgentity &f = (rpgentity &) e;
		switch(f.type)
		{
			case TELEDEST:
			case JUMPPAD:
			case SPAWN:
			case CHECKPOINT:
				break;
		}
	}

	bool printent(extentity &e, char *buf)
	{
		return false;
	}

	void teleport(rpgent &d, int dest)
	{
		loopv(ents)
		{
			if(ents[i]->type == TELEDEST && ents[i]->attr2 == dest)
			{
				d.yaw = ents[i]->attr1;
				d.pitch = 0;
				d.o = ents[i]->o; d.o.z += d.eyeheight; d.newpos = d.o;
				return;
			}
		}
		conoutf("no destination");
	}

	bool dirent(extentity &e)
	{
		switch(e.type)
		{
			case TELEDEST:
			case MAPMODEL:
			case CHECKPOINT:
			case PLAYERSTART:
			case SPAWN:
			case JUMPPAD:
				return true;
			default:
				return false;
		}
	}
	bool radiusent(extentity &e)
	{
		switch(e.type)
		{
			case ENVMAP:
			case MAPSOUND:
			case SPOTLIGHT:
			case LIGHT:
			case JUMPPAD:
				return true;
			default:
				return false;
		}
	}
	void renderhelpertext(extentity &e, int &colour, vec &pos, string &tmp) {}


	const char *entname(int i)
	{
		static const char *entnames[] =
		{
			"none?", "light", "mapmodel", "playerstart", "envmap", "particles", "sound", "spotlight",
			"spawn", "teledest", "jumppad", "checkpoint", "blip"
		};
		return i>=0 && size_t(i)<sizeof(entnames)/sizeof(entnames[0]) ? entnames[i] : "";
	}

	int extraentinfosize() { return SPAWNNAMELEN; }
	void writeent(entity &e, char *buf) { memcpy(buf, ((rpgentity &)e).name, SPAWNNAMELEN); }
	void readent (entity &e, char *buf) { memcpy(((rpgentity &)e).name, buf, SPAWNNAMELEN); }
	float dropheight(entity &e) {return 4.0f;}

	void editent(int i) {}
	void rumble(const extentity &e) { playsoundname("free/rumble", &e.o); }
	void trigger(extentity &e) {}

	void renderentities(bool mainpass)
	{
		loopv(ents)
		{
			extentity *e = ents[i];
			if(e->type != CHECKPOINT) continue;
		}
	}

	void spawnfroment(int i)
	{
		rpgentity *e = (rpgentity *) ents[i];
		string ds;

		game::rpgobjs.add(new rpgent(DEFAULTMODEL, ++game::lastid));
		rpgent *spawn = game::rpgobjs[game::rpgobjs.length()-1];
		rpgobj::selected = spawn;

		if(e->type == PLAYERSTART)
		{
			formatstring(ds)("spawn_player");
			spawn->name = newstring("player");
		}
		else
		{
			formatstring(ds)("spawn_%s", e->name);
			spawn->type = ENT_AI;
			spawn->name = newstring(e->name);
		}
		execute(ds);
		spawn->respawn();

		findplayerspawn(spawn, i);
		spawn->spawn = i;
	}

	void spawnname(char *name)
	{
		loopv(entgroup)
		{
			memcpy(((rpgentity *)ents[entgroup[i]])->name, name, SPAWNNAMELEN);
			spawnfroment(entgroup[i]);
		}

		if(entgroup.length() || enthover < 0 || enthover >= ents.length())
			return;

		memcpy(((rpgentity *)ents[enthover])->name, name, SPAWNNAMELEN);
		spawnfroment(enthover);
	}



	COMMAND(spawnname, "s");

	void startmap()
	{
		loopv(ents)
		{
			if(ents[i]->type == SPAWN)
			{
				spawnfroment(i);
			}
		}
	}

	//note that the RPG at present does not use mapmodel data
	int *getmodelattr(extentity &e)
	{
		return NULL;
	}

	bool checkmodelusage(extentity &e, int i)
	{
		return false;
	}

	//FIXME make checkpoints an on approach rpgent
	//extend to respawnable monsters as well
	void update(rpgent *d)
	{
		loopv(ents)
		{
			switch(ents[i]->type)
			{
				case CHECKPOINT:
					if(d->o.dist(ents[i]->o) < (ents[i]->attr2 ? ents[i]->attr2 : 16)  && d->spawn != i)
					{
						d->spawn = i;
						conoutf("checkpoint set");
					}
					break;
				default:
					break;
			}
		}
	}
};