# -*- coding: utf-8 -*-

# Copyright (c) 2010 Lukas Hetzenecker <LuHe@gmx.at>

from PyQt4.QtCore import *
from PyQt4.QtSql import *
import lib.export_html
from lib.classes import *

class Export(QObject):
    def __init__(self, parent, main):
        super(Export,  self).__init__(parent)
        
        self.parent = parent
        self.main = main

        self.log = main.log
        self.connection = main.connection
        self.database = main.database
        self.settings = main.settings
        self.helper = main.helper
        
        self.running = False
        self.stopExport = False

        self.__formats = list()
        self.__formats.append( lib.export_html.HTMLFormatter )

    def formats(self):
        return self.__formats

    def start(self,  plugin,  *args,  **kwargs):
        plugin = plugin(self,  self.main,  *args,  **kwargs)

        self.running = True

        currentMessage = 0
        currentCalendarFile = 0
        currentContact = 0

        self.connect(plugin,  SIGNAL("fileChanged"),  lambda f: self.emit(SIGNAL("fileChanged"),  f))
        self.connect(plugin,  SIGNAL("contactCountChanged"),  lambda f: self.emit(SIGNAL("contactCountChanged"),  f))
        self.connect(plugin,  SIGNAL("calendarFileCountChanged"),  lambda f: self.emit(SIGNAL("calendarFileCountChanged"),  f))
        
        self.emit(SIGNAL("messageCountChanged"),  self.database.messageCount(contactFilter=plugin.exportContacts))
        
        self.emit(SIGNAL("contactCountChanged"),  len(plugin.contactList))
        
        for message in self.database.messages(order=plugin.orderString(),  contactFilter=plugin.exportContacts):
            # Process all pending events until there are no more events to process.
            self.main.app.processEvents()
            if self.stopExport:
                self.running = False
                return
            currentMessage += 1
            self.emit(SIGNAL("messageExport"),  currentMessage)
            plugin.formatMessage(message)

        if plugin.files:
            plugin.finalizeMessageFile(plugin.files[-1])
        
        plugin.finalizeMessageFiles()
        
        for file in plugin.files:
            self.main.app.processEvents()
            if self.stopExport:
                self.running = False
                return
            
            if file.startswith("Messages"):
                currentCalendarFile += 1
                self.emit(SIGNAL("calendarFile"),  currentCalendarFile)
                self.emit(SIGNAL("fileChanged"),  file)
                plugin.writeCalender(file)
        
        for contact in plugin.contactList:
            self.main.app.processEvents()
            if self.stopExport:
                self.running = False
                return

            # Only handle active contacts
            if contact.idOnPhone():
                currentContact += 1
                self.emit(SIGNAL("contactExport"),  currentContact)
                plugin.formatContact(contact)
        
        plugin.finalizeContactFiles()
        plugin.finalizeFiles()
        
        self.running = False
        self.emit(SIGNAL("exportFinished"))
