/*
 * snes9express
 * video.cpp
 * (C) 1998, David Nordlund
 * Licensed under the "Artistic" license
 * To view the details of the Artistic license, see the file
 * ./ARTISTIC, or go to http://www.opensource.org/artistic-license.html
 */

#include <stdlib.h>
#include "video.h"
#include "pix/video.xpm"

s9x_Video::s9x_Video(fr_Element*parent):
s9x_Notepage(parent, "Video"),
Scale(this, "Scale", false),
HiRes(this, "Hi-Res", false),
TVmode(this, "TV-mode", false),
FullScreen(this, "Full Screen", false),
VideoSystem(this, "System"),
FrameWindow(this, "Video Frame Settings"),
UseFrameSkip(this, "Frame-skip:", false),
UseFrameTime(this, "Frame-time:", false),
DisplayFrameRate(this, "Display Frame Rate", false),
FrameSkip(this, "", 0, 0, 30, 0),
FrameTime(this, "", 16.7, 0.0, 1000.0, 1),
FrameSkipLabel(this, "auto"),
FrameTimeLabel(this, "auto"),
FrameWindowBtn(this, "Frames ..."),
FrameWindowClose(this, "Close")
{
   fr_MenuItem *MI;

   SetGridSize(4, 2, true);
   Label = new fr_Label(this, Name, video_xpm);

   Scale.Args << fr_CaseInsensitive << "-scale" << "-sc";
   Scale.SetTooltip("In X-DGA full-screen mode(Alt+F), resize the window to the actual screen size. (CPU intensive)");
   Pack(Scale);

   HiRes.Args << "-hires";
   HiRes.SetTooltip("This will double the screen size, but will run a little slower.");
   Pack(HiRes);

   TVmode.Args <<fr_CaseInsensitive<<"-interpolate"<<"-y"<< "-interpolation";
   TVmode.SetTooltip("double resolution, with pixel blended scan lines"
		     " inserted in video.");
   Pack(TVmode);

   FullScreen.Args << fr_CaseInsensitive << "-fullscreen";
   FullScreen.SetKeyStroke("Alt+F");
   FullScreen.SetTooltip("Put snes9x in Full Screen mode.  (requires root"
			 " privileges)");
   Pack(FullScreen);

   SetStretch(Fill, Fill);
	
   MI = new fr_MenuItem(&VideoSystem, "auto");
   //Is it "NTCS" or "NTSC"?  snes9x has a confused mix...crazy.
   NTSC = new fr_MenuItem(&VideoSystem, "NTSC");
   NTSC->Args << fr_CaseInsensitive << "-ntsc";
   NTSC->SetTooltip("Convince ROMs that they are on a NTSC system");
   NTSC->AddListener(this);
        
   PAL = new fr_MenuItem(&VideoSystem, "PAL");
   PAL->Args << fr_CaseInsensitive << "-pal";
   PAL->SetTooltip("Convince ROMs that they are on a PAL system");
   PAL->AddListener(this);
   Pack(VideoSystem);
	
   FrameWindow.SetGridSize(2, 4, true);
   FrameWindow.SetIcon("Frames", video_xpm);
   FrameWindow.SetStretch(Fill, Fill);
   FrameWindow.AddListener(this);
	
   UseFrameSkip.SetTooltip("Use auto-frame skip, or select a frame-skip constant");
   UseFrameSkip.AddListener(this);
   FrameWindow.Pack(UseFrameSkip, 0, 0, 1, 1);

   FrameSkip.Args << fr_CaseInsensitive << "-frameskip" << "-f";
   FrameSkip.SetKeyStroke("the + and - keys");
   FrameSkip.SetTooltip("Render 1 out of every x frames");
   FrameSkip.AddListener(this);
   FrameWindow.Pack(FrameSkip, 1, 0, 2, 1);
        
   FrameWindow.Pack(FrameSkipLabel, 1, 0, 2, 1);

   UseFrameTime.SetTooltip("Use auto-frame time, or specify a frame-time constant in milliseconds");
   UseFrameTime.AddListener(this);
   FrameWindow.Pack(UseFrameTime, 0, 1, 1, 2);
        
   FrameTime.Args << fr_CaseInsensitive << "-ft" << "-frametime";
   FrameTime.SetKeyStroke("Shift '+' / Shift '-'");
   FrameTime.SetTooltip("time (in milliseconds) in which a frame should be rendered in.  Higher value slows things down, lower value speeds up");
   FrameWindow.Pack(FrameTime, 1, 1, 2, 2);

   FrameWindow.Pack(FrameTimeLabel, 1, 1, 2, 2);

   DisplayFrameRate.Args <<fr_CaseInsensitive<<"-dfr"<<"-displayframerate";
   DisplayFrameRate.SetTooltip("During game play, display the frames"
				" per second that snes9x achieves.");
   FrameWindow.Pack(DisplayFrameRate, 2, 1);
	
   FrameWindow.Pack(FrameWindowClose, 2, 1);
   FrameWindowClose.AddListener(this);
	
   Pack(FrameWindowBtn, 3, 1, 4, 2);
   FrameWindowBtn.AddListener(this);

   Frame();
}

s9x_Video::~s9x_Video() {
   delete NTSC;
   delete PAL;
}

void s9x_Video::Set9xVersion(float version) {
   HiRes.EnableIf(version >= 1.0);
   TVmode.EnableIf(version >= 1.10);
   Scale.EnableIf(version >= 1.10);
   FrameTime.EnableIf(version >= 1.10);
   UseFrameTime.EnableIf(version >= 1.10);
   DisplayFrameRate.EnableIf(version >= 1.19);
   FullScreen.EnableIf(version >= 1.19);
}

void s9x_Video::SetToDefaults() {
   VideoSystem.SetToDefault();
   FrameSkip.SetToDefault();
   Scale.SetToDefault();
   HiRes.SetToDefault();
   TVmode.SetToDefault();
   FullScreen.SetToDefault();
   UseFrameTime.SetToDefault();
   FrameTime.SetToDefault();
   DisplayFrameRate.SetToDefault();
   fr_Event(&UseFrameSkip, fr_Click);
};

void s9x_Video::EventOccurred(fr_Event*e) {
   bool b, s;
   if(e->Is(FrameWindowBtn))
     FrameWindow.SetVisibility(true);
   else if(e->Is(FrameWindowClose)||e->Is(FrameWindow, fr_Destroy))
     FrameWindow.SetVisibility(false);
   else if(e->Is(*PAL) && PAL->GetState())
     FrameTime.ResetDefault(20.0);
   else if(e->Is(*NTSC) && NTSC->GetState())
     FrameTime.ResetDefault(16.7);
   else if(e->Is(UseFrameSkip)||e->Is(FrameSkip)) {
      b = (FrameSkip.GetValue() != 0);
      s = UseFrameSkip.GetState();
      if(e->Is(FrameSkip)) {
	 UseFrameSkip.SetState(b);
	 if(!b)
	   s = false;
      } else
	FrameSkip.SetValue(2*s);
      FrameSkip.SetVisibility(s);
      FrameSkipLabel.SetVisibility(!s);

      UseFrameTime.SetState(false);
      UseFrameTime.SetEditable(!s);
      FrameTime.SetVisibility(false);
      FrameTimeLabel.SetVisibility(true);
      FrameTimeLabel.SetEditable(!s);
   };

   if(e->Is(UseFrameTime)) {
      s = UseFrameTime.GetState();
      UseFrameSkip.SetEditable(!s);
      FrameSkipLabel.SetEditable(!s);
      FrameTime.SetVisibility(s);
      FrameTimeLabel.SetVisibility(!s);
   };
}

void s9x_Video::SiftArgs(fr_ArgList& L) {
   VideoSystem.SiftArgs(L);
   Scale.SiftArgs(L);
   HiRes.SiftArgs(L);
   TVmode.SiftArgs(L);
   FullScreen.SiftArgs(L);
   FrameSkip.SiftArgs(L);
   if(!FrameSkip.IsDefault())
     UseFrameSkip.SetState(true);
   FrameTime.SiftArgs(L);
   if(!FrameTime.IsDefault())
     UseFrameTime.SetState(true);
   DisplayFrameRate.SiftArgs(L);
}

void s9x_Video::CompileArgs(fr_ArgList& L) {
   VideoSystem.CompileArgs(L);
   Scale.CompileArgs(L);
   HiRes.CompileArgs(L);
   TVmode.CompileArgs(L);
   FullScreen.CompileArgs(L);
   if(UseFrameSkip.GetState())
     FrameSkip.CompileArgs(L);

   else if(UseFrameTime.GetState())
     FrameTime.CompileArgs(L);
   DisplayFrameRate.CompileArgs(L);
}
