-- `Topal': GPG/Pine integration
--
-- Copyright (C) 2001,2002  Phillip J. Brooke
--
--     This program is free software; you can redistribute it and/or modify
--     it under the terms of the GNU General Public License as published by
--     the Free Software Foundation; either version 2 of the License, or
--     (at your option) any later version.
--
--     This program is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU General Public License for more details.
--
--     You should have received a copy of the GNU General Public License
--     along with this program; if not, write to the Free Software
--     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

with Ada.Text_IO;
with Command_Line_Wrapper; use Command_Line_Wrapper;
with Misc;                 use Misc;

package body Invocation is

   procedure Parse_Options (Parse_All : Boolean) is
   begin
      loop exit when not More;
         if Match(UBS_Array'(1 => ToUBS("-debug"),
                             2 => ToUBS("-d"),
                             3 => ToUBS("--debug"),
                             4 => ToUBS("--d"))) then
            Config.Debug := True;
         elsif Match("--simple") then
            Config.FE_Simple := True;
         elsif Match("--rewrite") then
            Config.FE_Simple := False;
         elsif Match("--no-clear") then
            Config.No_Clean := True;
         else
            -- We haven't got an options match.
            if Parse_All then
               Error("Option `" & Current & "' not recognised.");
            else
               -- Don't care.
               exit;
            end if;
         end if;
      end loop;
   end Parse_Options;

   procedure Parse_Command_Line is
   begin
      -- Sort out the command-line.
      Debug("Examining command-line options...");
      -- Eat up some options.
      Parse_Options(Parse_All => False);
      if not More then
         Run_Mode := Help_Text;
      else
         if Match(UBS_Array'(1 => ToUBS("-help"),
                             2 => ToUBS("-h"),
                             3 => ToUBS("--help"),
                             4 => ToUBS("--h"),
                             5 => ToUBS("-?"),
                             6 => ToUBS("--?"))) then
            Run_Mode := Help_Text;
            Parse_Options(Parse_All => True);
         elsif Match(UBS_Array'(1 => ToUBS("-display"),
                                2 => ToUBS("-decrypt"),
                                3 => ToUBS("-verify"))) then
           -- -decrypt and -verify are legacy for release 0.4.5 to 0.5.0.
            if not More(Needed => 2) then
               Error("-display, -decrypt and -verify need two arguments: _TMPFILE_ _RESULTFILE_");
            else
               Run_Mode := Inline_Display;
               Tmpfile := Eat;
               Resultfile := Eat;
            end if;
         elsif Match("-mime") then
            if not More(Needed => 2) then
               Error("-mime needs two arguments: INFILE CONTENT-TYPE");
            else
               Run_Mode := Mime_Display;
               Infile := Eat;
               Content_Type := Eat;
            end if;
         elsif Match("-mimeapgp") then
            if not More(Needed => 2) then
               Error("-mimeapgp needs two arguments: INFILE CONTENT-TYPE");
            else
               Run_Mode := Old_Mime_Display;
               Infile := Eat;
               Content_Type := Eat;
            end if;
         elsif Match("-send") then
            if not More(Needed => 2) then
               Error("-send needs at least two arguments: _TMPFILE_ _RESULTFILE_"
                     & ", then _RECIPIENTS_");
            else
               Run_Mode := Inline_Send;
               Tmpfile := Eat;
               Resultfile := Eat;
               Recipients := Eat_Remaining_Arguments;
            end if;
         elsif Match("-sendmime") then
            if not More(Needed => 3) then
               Error("-sendmime needs at least three arguments: _TMPFILE_ _RESULTFILE_ _MIMETYPE_"
                     & ", then _RECIPIENTS_");
            else
               Run_Mode := Mime_Send;
               Tmpfile := Eat;
               Resultfile := Eat;
               Mimefile := Eat;
               Recipients := Eat_Remaining_Arguments;
            end if;
         elsif Match("-clear") then
            Run_Mode := Clear_Temp;
         elsif Match("-clearc") then
            Run_Mode := Clear_Cache;
         elsif Match("-clearall") then
            Run_Mode := Clear_All;
         elsif Match("-default") then
            Run_Mode := Dump_Default_Config;
         elsif Match("-dump") then
            Run_Mode := Dump_Current_Config;
         elsif Match("-config") then
            Run_Mode := Interactive_Config;
         elsif Match(UBS_Array'(1 => ToUBS("--fix-email"),
                                2 => ToUBS("-fe")))
           or Command_Basename = "topal-fix-email" then
            Run_Mode := Fix_Email;
         elsif Match(UBS_Array'(1 => ToUBS("--fix-folder"),
                                2 => ToUBS("-ff")))
           or Command_Basename = "topal-fix-folder" then
            Run_Mode := Fix_Folders;
            Folders := Eat_Remaining_Arguments;
         elsif Match(UBS_Array'(1 => ToUBS("-nps"),
                                2 => ToUBS("-s"))) then
            if not More then
               Error("-nps (-s) needs at least one argument: _THEFILE_"
                     & ", then _RECIPIENTS_");
            else
               Run_Mode := Nonpine_Send;
               Tmpfile := Eat;
               Recipients := Eat_Remaining_Arguments;
            end if;
         else
            -- Assume we meant topal -s arg1 arg2 ...
            Run_Mode := Nonpine_Send;
            Tmpfile := Eat;
            Recipients := Eat_Remaining_Arguments;
         end if;
      end if;
      -- Eat any remaining arguments; let's hope they're options.
      Parse_Options(Parse_All => True);
   exception
      when others =>
         Ada.Text_IO.Put_Line(Ada.Text_IO.Standard_Error,
                              "Exception raised in Invocation.Parse_Command_Line");
         raise;
   end Parse_Command_Line;

end Invocation;
