-- `Topal': GPG/Pine integration
--
-- Copyright (C) 2001,2002  Phillip J. Brooke
--
--     This program is free software; you can redistribute it and/or modify
--     it under the terms of the GNU General Public License as published by
--     the Free Software Foundation; either version 2 of the License, or
--     (at your option) any later version.
--
--     This program is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU General Public License for more details.
--
--     You should have received a copy of the GNU General Public License
--     along with this program; if not, write to the Free Software
--     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

with Ada.Sequential_IO;
with Ada.Text_IO;
with Globals;            use Globals;

package Misc is

   -- How to handle errors and debugging.
   Panic : exception;

   procedure Error (The_Error : in String);

   -- ErrorNE (error-no-exception) doesn't raise an exception.
   -- You need to do it.
   procedure ErrorNE (The_Error : in String);

   procedure Debug (Message : in String);

   -- Receiving.Split_Two_Parts and others needs to write out files without
   -- an end-of-line being appended (as happens with Text_IO).
   package Character_IO is new Ada.Sequential_IO (Element_Type => Character);

   procedure Character_IO_Put (F : in Character_IO.File_Type;
                               S : in String);

   procedure Character_IO_Put_Line (F : in Character_IO.File_Type;
                                    S : in String);

   -- Strings to integers.

   String_Not_Integer : exception;

   function String_To_Integer (S : String) return Integer;
   function String_To_Integer (S : UBS) return Integer;

   -- Throw away leading blanks from a string.
   function Trim_Leading_Spaces (S : String) return String;

   -- Create our own temporary file names.
   function Temp_File_Name (Tail : String) return String;

   -- An `unbounded' Get_Line.
   function Unbounded_Get_Line (File : in Ada.Text_IO.File_Type)
                                return UBS;

   function Unbounded_Get_Line return UBS;

   -- Open and close the result file.
   procedure Open_Result_File (Resultfile : in String);

   procedure Close_Result_File;

   -- Disclaimer.
   procedure Disclaimer;

   -- Wrapper for reading unbounded strings out of the config record.
   -- If the string is empty, then barf.
   Need_Nonempty_String : exception;
   function Value_Nonempty (V : UBS) return UBS;

   function Value_Nonempty (V : UBS) return String;

   -- Split up a string into multiple tokens, using spaces as the
   -- delimiter, but also honouring quoting and stuffing using `"'.
   function Split_Arguments (A : UBS) return UBS_Array;

   -- Get the basename of a filename.
   function Basename (S : String) return String;

   -- Basename.
   function Command_Basename return String;

end Misc;
