/*
 * Decompiled with CFR 0.152.
 */
package junit.textui;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.util.StringUtil;
import junit.util.Version;

public class TestRunner
implements TestListener {
    PrintStream fWriter;

    public TestRunner() {
    }

    public TestRunner(PrintStream writer) {
        this();
        this.fWriter = writer;
    }

    public synchronized void addError(Test test, Throwable t) {
        this.writer().print("E");
    }

    public synchronized void addFailure(Test test, Throwable t) {
        this.writer().print("F");
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    protected void doRun(Test suite, boolean wait) {
        TestResult result = this.createTestResult();
        result.addListener(this);
        long startTime = System.currentTimeMillis();
        suite.run(result);
        long endTime = System.currentTimeMillis();
        long runTime = endTime - startTime;
        this.writer().println();
        this.writer().println("Time: " + StringUtil.elapsedTimeAsString(runTime));
        this.print(result);
        this.writer().println();
        if (wait) {
            this.writer().println("<RETURN> to continue");
            try {
                System.in.read();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!result.wasSuccessful()) {
            System.exit(-1);
        }
        System.exit(0);
    }

    public void endTest(Test test) {
    }

    private String extractClassName(String className) {
        if (className.startsWith("Default package for")) {
            return className.substring(className.lastIndexOf(".") + 1);
        }
        return className;
    }

    public static void main(String[] args) {
        TestRunner aTestRunner = new TestRunner();
        aTestRunner.start(args);
    }

    public synchronized void print(TestResult result) {
        this.printHeader(result);
        this.printErrors(result);
        this.printFailures(result);
    }

    public void printErrors(TestResult result) {
        if (result.errorCount() != 0) {
            if (result.errorCount() == 1) {
                this.writer().println("There was " + result.errorCount() + " error:");
            } else {
                this.writer().println("There were " + result.errorCount() + " errors:");
            }
            int i = 1;
            Enumeration e = result.errors();
            while (e.hasMoreElements()) {
                TestFailure failure = (TestFailure)e.nextElement();
                this.writer().println(String.valueOf(i) + ") " + failure.failedTest());
                failure.thrownException().printStackTrace();
                ++i;
            }
        }
    }

    public void printFailures(TestResult result) {
        if (result.failureCount() != 0) {
            if (result.failureCount() == 1) {
                this.writer().println("There was " + result.failureCount() + " failure:");
            } else {
                this.writer().println("There were " + result.failureCount() + " failures:");
            }
            int i = 1;
            Enumeration e = result.failures();
            while (e.hasMoreElements()) {
                TestFailure failure = (TestFailure)e.nextElement();
                this.writer().print(String.valueOf(i) + ") " + failure.failedTest());
                Throwable t = failure.thrownException();
                if (t.getMessage() != null) {
                    this.writer().println(" \"" + StringUtil.truncate(t.getMessage(), 80) + "\"");
                } else {
                    this.writer().println();
                    failure.thrownException().printStackTrace();
                }
                ++i;
            }
        }
    }

    public void printHeader(TestResult result) {
        if (result.wasSuccessful()) {
            this.writer().println();
            this.writer().print("OK");
            this.writer().println(" (" + result.runCount() + " tests)");
        } else {
            this.writer().println();
            this.writer().println("FAILURES!!!");
            this.writer().println("Test Results:");
            this.writer().println("Run: " + result.runCount() + " Failures: " + result.failureCount() + " Errors: " + result.errorCount());
        }
    }

    public static void run(Class testClass) {
        TestRunner.run(new TestSuite(testClass));
    }

    public static void run(Test suite) {
        TestRunner aTestRunner = new TestRunner();
        aTestRunner.doRun(suite, false);
    }

    public static void runAndWait(Test suite) {
        TestRunner aTestRunner = new TestRunner();
        aTestRunner.doRun(suite, true);
    }

    protected void start(String[] args) {
        String testCase = "";
        boolean wait = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-wait")) {
                wait = true;
            } else if (args[i].equals("-c")) {
                testCase = StringUtil.extractClassName(args[++i]);
            } else if (args[i].equals("-v")) {
                System.out.println("JUnit " + Version.id() + " by Kent Beck and Erich Gamma");
            } else {
                testCase = args[i];
            }
            ++i;
        }
        if (testCase.equals("")) {
            System.out.println("Usage: TestRunner [-wait] testCaseName, where name is the name of the TestCase class");
            System.exit(-1);
        }
        try {
            Class<?> testClass = null;
            Method suiteMethod = null;
            Test suite = null;
            try {
                testClass = Class.forName(testCase);
            }
            catch (Exception e) {
                System.out.println("Suite class \"" + testCase + "\" not found");
                System.exit(-1);
            }
            try {
                suiteMethod = testClass.getMethod("suite", new Class[0]);
            }
            catch (Exception e) {
                suite = new TestSuite(testClass);
            }
            if (suite == null) {
                try {
                    suite = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
                }
                catch (Exception e) {
                    System.out.println("Could not invoke the suite() method");
                    System.exit(-1);
                }
            }
            this.doRun(suite, wait);
        }
        catch (Exception e) {
            System.out.println("Could not create and run test suite");
            System.exit(-1);
        }
    }

    public synchronized void startTest(Test test) {
        System.out.print(".");
    }

    private PrintStream writer() {
        if (this.fWriter == null) {
            return System.out;
        }
        return this.fWriter;
    }
}

