/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import org.webmacro.Macro;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Builder;
import org.webmacro.engine.GlobalVariable;
import org.webmacro.engine.PropertyVariable;
import org.webmacro.engine.ToolVariable;
import org.webmacro.engine.Variable;

public class VariableBuilder
implements Builder {
    private final Object[] _names;
    private final boolean _filtered;

    public VariableBuilder(Object[] objectArray, boolean bl) {
        this._names = objectArray;
        this._filtered = bl;
    }

    static Macro newVariable(Object[] objectArray, BuildContext buildContext, boolean bl) throws BuildException {
        Variable variable = null;
        if (objectArray.length < 1) {
            throw new BuildException("Variable with name of length zero!");
        }
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        while (n < objectArray2.length) {
            objectArray2[n] = objectArray[n] instanceof Builder ? ((Builder)objectArray[n]).build(buildContext) : objectArray[n];
            ++n;
        }
        Object object = buildContext.getVariableType(objectArray2[0].toString());
        if (object == Variable.PROPERTY_TYPE) {
            variable = new PropertyVariable(objectArray2);
        } else if (object == Variable.LOCAL_TYPE) {
            variable = new GlobalVariable(objectArray2);
        } else if (object == Variable.TOOL_TYPE) {
            variable = new ToolVariable(objectArray2);
        } else {
            throw new BuildException("Unrecognized Variable Type: " + object);
        }
        return bl ? buildContext.getFilterMacro(variable) : variable;
    }

    public final Object build(BuildContext buildContext) throws BuildException {
        return VariableBuilder.newVariable(this._names, buildContext, this._filtered);
    }
}

