/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Vector;
import org.webmacro.Broker;
import org.webmacro.NotFoundException;
import org.webmacro.engine.AndConditionBuilder;
import org.webmacro.engine.BlockBuilder;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Builder;
import org.webmacro.engine.DirectiveBuilder;
import org.webmacro.engine.EqualConditionBuilder;
import org.webmacro.engine.ListBuilder;
import org.webmacro.engine.NotConditionBuilder;
import org.webmacro.engine.NullBuilder;
import org.webmacro.engine.OrConditionBuilder;
import org.webmacro.engine.ParamBuilder;
import org.webmacro.engine.ParseTool;
import org.webmacro.engine.ParseToolException;
import org.webmacro.engine.Parser;
import org.webmacro.engine.PropertyMethodBuilder;
import org.webmacro.engine.QuotedStringBuilder;
import org.webmacro.engine.TermConditionBuilder;
import org.webmacro.engine.Variable;
import org.webmacro.engine.VariableBuilder;
import org.webmacro.util.Log;

public class WMParser
implements Parser {
    private static final Log _log = new Log("parse", "WebMacro parser");
    private final Broker _broker;
    private Hashtable _tools;
    private static final Builder END_BLOCK = new NullBuilder();

    public WMParser(Broker broker) {
        this._broker = broker;
    }

    public final String getParserName() {
        return "wm";
    }

    private int parseUntilMacroChar(ParseTool parseTool, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws IOException {
        boolean bl = false;
        int n = stringBuffer.length();
        int n2 = parseTool.getChar();
        while (true) {
            switch (n2) {
                case 35: 
                case 125: {
                    if (n == -1 || parseTool.isEscaped()) break;
                    String string = stringBuffer.toString();
                    stringBuffer2.append(string.substring(n));
                    stringBuffer.setLength(n);
                    return n2;
                }
                case 36: {
                    if (parseTool.isEscaped()) break;
                    return n2;
                }
                case -1: {
                    return n2;
                }
                case 62: {
                    n = stringBuffer.length() + 1;
                    break;
                }
                case 10: {
                    if (parseTool.isEscaped()) {
                        n = stringBuffer.length() + 1;
                        break;
                    }
                    n = stringBuffer.length();
                    break;
                }
                case 9: 
                case 32: {
                    if (parseTool.isEscaped()) {
                        n = stringBuffer.length() + 1;
                        break;
                    }
                    if (n != -1) break;
                    n = stringBuffer.length();
                    break;
                }
                default: {
                    n = -1;
                }
            }
            stringBuffer.append((char)n2);
            n2 = parseTool.nextChar();
            bl = true;
        }
    }

    public BlockBuilder parseBlock(String string, Reader reader) throws ParseToolException, IOException {
        ParseTool parseTool = new ParseTool(string, reader);
        BlockBuilder blockBuilder = new BlockBuilder();
        do {
            try {
                blockBuilder.addElement(this.parseBlockImpl(parseTool));
            }
            catch (ParseToolException parseToolException) {
                _log.exception(parseToolException);
                if (parseTool.isAtEOF()) continue;
                int n = parseTool.nextChar();
                blockBuilder.addElement(new Character((char)n).toString());
            }
        } while (!parseTool.isAtEOF());
        return blockBuilder;
    }

    protected BlockBuilder parseBlockImpl(ParseTool parseTool) throws ParseToolException, IOException {
        return this.parseBlockImpl(parseTool, false, false);
    }

    private BlockBuilder parseBlockImpl(ParseTool parseTool, boolean bl, boolean bl2) throws ParseToolException, IOException {
        BlockBuilder blockBuilder = new BlockBuilder();
        boolean bl3 = bl2 && parseTool.parseChar('{');
        parseTool.skipSpaces();
        StringBuffer stringBuffer = new StringBuffer(512);
        boolean bl4 = !parseTool.isAtEOF();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (bl4) {
            stringBuffer2.setLength(0);
            int n = this.parseUntilMacroChar(parseTool, stringBuffer, stringBuffer2);
            boolean bl5 = stringBuffer2.length() > 0 && stringBuffer2.charAt(0) == '\n';
            Object object = null;
            switch (n) {
                case 35: {
                    object = this.parseDirective(parseTool);
                    if (object == END_BLOCK) {
                        bl4 = false;
                        object = null;
                        if (bl3 || !bl) {
                            throw new ParseToolException(parseTool, END_BLOCK + " unexpected");
                        }
                    }
                    if (!bl5 || parseTool.getChar() == 10) break;
                    stringBuffer.append('\n');
                    break;
                }
                case 125: {
                    if (bl3) {
                        if (bl3) {
                            bl4 = false;
                            break;
                        }
                        throw new ParseToolException(parseTool, "} unexpected");
                    }
                    stringBuffer.append(stringBuffer2.toString());
                    break;
                }
                case -1: {
                    stringBuffer.append(stringBuffer2.toString());
                    bl4 = false;
                    break;
                }
                case 36: {
                    stringBuffer.append(stringBuffer2.toString());
                    object = WMParser.parseVariable(parseTool, true);
                    break;
                }
                default: {
                    throw new ParseToolException(parseTool, "Parser bug: expected macro char, got " + (char)n);
                }
            }
            if (bl4 && object == null) {
                stringBuffer.append((char)n);
                parseTool.nextChar();
                continue;
            }
            blockBuilder.addElement(stringBuffer.toString());
            stringBuffer.setLength(0);
            if (object == null) continue;
            blockBuilder.addElement(object);
        }
        if (bl3 && !parseTool.parseChar('}')) {
            throw new ParseToolException(parseTool, "expected } at end of block");
        }
        return blockBuilder;
    }

    final DirectiveBuilder getDirectiveBuilder(String string) throws NotFoundException {
        try {
            return (DirectiveBuilder)this._broker.getValue("directive", string);
        }
        catch (Exception exception) {
            throw new NotFoundException("Could not load directive " + string + ": " + exception);
        }
    }

    private Builder parseDirective(ParseTool parseTool) throws ParseToolException, IOException {
        return this.parseDirective(parseTool, false);
    }

    private Builder parseSubDirective(ParseTool parseTool) throws ParseToolException, IOException {
        return this.parseDirective(parseTool, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Builder parseDirective(ParseTool parseTool, boolean bl) throws ParseToolException, IOException {
        DirectiveBuilder directiveBuilder = null;
        String string = "unknown";
        try {
            CharSequence charSequence;
            Object object;
            DirectiveBuilder directiveBuilder2;
            int n;
            block30: {
                Builder builder;
                block31: {
                    BlockBuilder blockBuilder;
                    block29: {
                        Builder builder2;
                        block28: {
                            Builder builder3;
                            block27: {
                                NullBuilder nullBuilder;
                                block26: {
                                    n = parseTool.mark();
                                    try {
                                        if (!parseTool.parseChar('#')) {
                                            Builder builder4 = null;
                                            Object var9_15 = null;
                                            parseTool.clearMark(n);
                                            return builder4;
                                        }
                                        string = parseTool.parseName();
                                        if (string == null) {
                                            if (parseTool.getChar() == 35) {
                                                _log.debug("Parsing comment");
                                                parseTool.skipToEOL();
                                                nullBuilder = new NullBuilder();
                                                break block26;
                                            }
                                            parseTool.rewind(n);
                                            builder3 = null;
                                            break block27;
                                        }
                                        if (string.equals("end")) {
                                            parseTool.skipSpaces();
                                            builder2 = END_BLOCK;
                                            break block28;
                                        }
                                        if (string.equals("begin")) {
                                            parseTool.skipSpaces();
                                            blockBuilder = this.parseBlockImpl(parseTool, true, true);
                                            break block29;
                                        }
                                        directiveBuilder2 = this.getDirectiveBuilder(string);
                                        if (directiveBuilder2 == null) {
                                            throw new ParseToolException(parseTool, "Unrecognized directive: " + string);
                                        }
                                        if (!bl || directiveBuilder2.isSubDirective()) break block30;
                                        parseTool.rewind(n);
                                        builder = null;
                                        break block31;
                                    }
                                    catch (Throwable throwable) {
                                        Object var9_22 = null;
                                        parseTool.clearMark(n);
                                        throw throwable;
                                    }
                                }
                                Object var9_16 = null;
                                parseTool.clearMark(n);
                                return nullBuilder;
                            }
                            Object var9_17 = null;
                            parseTool.clearMark(n);
                            return builder3;
                        }
                        Object var9_18 = null;
                        parseTool.clearMark(n);
                        return builder2;
                    }
                    Object var9_19 = null;
                    parseTool.clearMark(n);
                    return blockBuilder;
                }
                Object var9_20 = null;
                parseTool.clearMark(n);
                return builder;
            }
            Object object2 = null;
            parseTool.clearMark(n);
            _log.debug("Parsing #" + string);
            if (directiveBuilder2.hasCondition()) {
                parseTool.skipSpaces();
                object = this.parseCondition(parseTool);
                directiveBuilder2.setCondition(object);
            } else if (directiveBuilder2.hasTarget()) {
                parseTool.skipSpaces();
                object = WMParser.parseTerm(parseTool);
                directiveBuilder2.setTarget(object);
                if (directiveBuilder2.hasArguments()) {
                    parseTool.skipSpaces();
                    String[] stringArray = directiveBuilder2.getArgumentNames();
                    while ((charSequence = parseTool.parseStrings(stringArray)) != null) {
                        parseTool.skipSpaces();
                        object2 = WMParser.parseTerm(parseTool);
                        directiveBuilder2.addArgument((String)charSequence, object2);
                    }
                }
            }
            if (directiveBuilder2.isParser()) {
                parseTool.skipWhitespace();
                object = null;
                if (parseTool.parseString("#begin")) {
                    object = "#end";
                } else {
                    if (!parseTool.parseString("{")) throw new ParseToolException(parseTool, "Expected block after directive: " + directiveBuilder2);
                    object = "}";
                }
                charSequence = new StringBuffer();
                parseTool.parseUntil((StringBuffer)charSequence, (String)object);
                ((StringBuffer)charSequence).setLength(((StringBuffer)charSequence).length() - ((String)object).length());
                directiveBuilder2.setText(((StringBuffer)charSequence).toString());
            } else if (directiveBuilder2.isContainer()) {
                parseTool.skipWhitespace();
                if (parseTool.getChar() == 123) {
                    object = this.parseBlockImpl(parseTool, false, true);
                    directiveBuilder2.setContents((Builder)object);
                } else {
                    if (!parseTool.parseString("#begin")) throw new ParseToolException(parseTool, "Expected block after " + string);
                    parseTool.skipSpaces();
                    object = this.parseBlockImpl(parseTool, true, true);
                    directiveBuilder2.setContents((Builder)object);
                }
            }
            if (directiveBuilder2.isMulti()) {
                n = parseTool.mark();
                parseTool.skipWhitespace();
                object = this.parseSubDirective(parseTool);
                if (object instanceof DirectiveBuilder) {
                    parseTool.clearMark(n);
                    directiveBuilder2.setSubDirective(object);
                } else {
                    parseTool.rewind(n);
                }
            }
            parseTool.skipSpaces();
            directiveBuilder2.check();
            return directiveBuilder2;
        }
        catch (BuildException buildException) {
            _log.exception(buildException);
            throw new ParseToolException(parseTool, "Error parsing directive: " + buildException.getMessage());
        }
        catch (NotFoundException notFoundException) {
            _log.exception(notFoundException);
            notFoundException.printStackTrace();
            throw new ParseToolException(parseTool, "Unrecognized directive: " + string);
        }
    }

    public static Object parseVariable(ParseTool parseTool, boolean bl) throws ParseToolException, IOException {
        Object[] objectArray;
        Object object;
        if (!parseTool.parseChar('$')) {
            return null;
        }
        boolean bl2 = parseTool.parseChar('$');
        char c = '\u0000';
        if (parseTool.parseChar('(')) {
            c = ')';
        } else if (!parseTool.isNameStartChar()) {
            return bl2 ? "$$" : "$";
        }
        Vector<String> vector = new Vector<String>();
        while ((object = parseTool.parseName()) != null) {
            if (parseTool.getChar() == 40) {
                objectArray = WMParser.parseList(parseTool);
                object = new PropertyMethodBuilder((String)object, (ListBuilder)objectArray);
            }
            vector.addElement((String)object);
            if (!parseTool.parseChar('.')) break;
        }
        objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        if (c != '\u0000' && !parseTool.parseChar(c)) {
            throw new ParseToolException(parseTool, "Expected closing bracket after variable name " + Variable.makeName(objectArray));
        }
        parseTool.parseChar(';');
        if (bl2) {
            _log.debug("Parsed param:" + Variable.makeName(objectArray));
            return new ParamBuilder(objectArray);
        }
        _log.debug("Parsed var:" + Variable.makeName(objectArray));
        return new VariableBuilder(objectArray, bl);
    }

    public static Object parseTerm(ParseTool parseTool) throws ParseToolException, IOException {
        Object object = null;
        switch (parseTool.getChar()) {
            case 36: {
                object = WMParser.parseVariable(parseTool, false);
                if (!(object instanceof String)) break;
                throw new ParseToolException(parseTool, "Unexpected character after " + object + ": " + "expected variable name start, instead got " + parseTool.getChar());
            }
            case 91: {
                object = WMParser.parseList(parseTool);
                break;
            }
            case 34: 
            case 39: {
                object = WMParser.parseQuotedString(parseTool);
                break;
            }
            default: {
                object = parseTool.parseName();
                if (object == null) {
                    object = parseTool.parseNumber();
                    break;
                }
                if (object.equals("false") || object.equals("FALSE") || object.equals("False")) {
                    return Boolean.FALSE;
                }
                if (!object.equals("true") && !object.equals("TRUE") && !object.equals("True")) break;
                return Boolean.TRUE;
            }
        }
        _log.debug("Parsed term:" + object);
        return object;
    }

    public static Object parseQuotedString(ParseTool parseTool) throws ParseToolException, IOException {
        int n = parseTool.getChar();
        boolean bl = false;
        if (n != 39 && n != 34) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(96);
        QuotedStringBuilder quotedStringBuilder = new QuotedStringBuilder();
        int n2 = parseTool.nextChar();
        while (n2 != n && n2 != -1) {
            if (n2 == 36 && !parseTool.isEscaped()) {
                Object object = WMParser.parseVariable(parseTool, true);
                n2 = parseTool.getChar();
                if (object instanceof String) {
                    stringBuffer.append(object);
                    continue;
                }
                quotedStringBuilder.addElement(stringBuffer.toString());
                quotedStringBuilder.addElement(object);
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.append((char)n2);
            n2 = parseTool.nextChar();
        }
        if (stringBuffer.length() != 0) {
            quotedStringBuilder.addElement(stringBuffer.toString());
        }
        stringBuffer = null;
        if (n2 != n) {
            throw new ParseToolException(parseTool, "Expected closing quote: " + (char)n);
        }
        parseTool.nextChar();
        if (quotedStringBuilder.size() == 1 && !(quotedStringBuilder.elementAt(0) instanceof Builder)) {
            return quotedStringBuilder.elementAt(0);
        }
        return quotedStringBuilder;
    }

    public static ListBuilder parseList(ParseTool parseTool) throws ParseToolException, IOException {
        Object object;
        int n;
        switch (parseTool.getChar()) {
            case 40: {
                n = 41;
                break;
            }
            case 91: {
                n = 93;
                break;
            }
            default: {
                return null;
            }
        }
        ListBuilder listBuilder = new ListBuilder();
        parseTool.nextChar();
        parseTool.skipSpaces();
        while ((object = WMParser.parseTerm(parseTool)) != null) {
            listBuilder.addElement(object);
            parseTool.skipSpaces();
            if (!parseTool.parseChar(',')) continue;
            parseTool.skipSpaces();
        }
        if (!parseTool.parseChar((char)n)) {
            throw new ParseToolException(parseTool, "Expected end of list, instead got " + parseTool.getChar());
        }
        return listBuilder;
    }

    public Builder parseCondition(ParseTool parseTool) throws ParseToolException, IOException {
        Builder builder;
        boolean bl = parseTool.parseChar('(');
        parseTool.skipSpaces();
        switch (parseTool.getChar()) {
            case 33: {
                builder = this.parseNotCondition(parseTool);
                break;
            }
            case 40: {
                builder = this.parseCondition(parseTool);
                break;
            }
            default: {
                builder = this.parseTermCondition(parseTool);
            }
        }
        if (null == builder) {
            throw new ParseToolException(parseTool, "Expected term/expression, got: " + (char)parseTool.getChar());
        }
        boolean bl2 = true;
        while (bl2) {
            Builder builder2;
            parseTool.skipSpaces();
            switch (parseTool.getChar()) {
                case 33: {
                    builder2 = this.parseNotEqualCondition(builder, parseTool);
                    break;
                }
                case 61: {
                    builder2 = this.parseEqualCondition(builder, parseTool);
                    break;
                }
                case 38: {
                    builder2 = this.parseAndCondition(builder, parseTool);
                    break;
                }
                case 124: {
                    builder2 = this.parseOrCondition(builder, parseTool);
                    break;
                }
                default: {
                    builder2 = null;
                }
            }
            if (builder2 == null) {
                bl2 = false;
                continue;
            }
            builder = builder2;
        }
        parseTool.skipSpaces();
        if (bl && !parseTool.parseChar(')')) {
            throw new ParseToolException(parseTool, "Mismatched braces around expression.");
        }
        return builder;
    }

    private Builder parseBinOp(char[] cArray, ParseTool parseTool) throws IOException, ParseToolException {
        int n = 0;
        while (n < cArray.length) {
            if (!parseTool.parseChar(cArray[n])) {
                if (n == 0) {
                    return null;
                }
                throw new ParseToolException(parseTool, "Expected character " + cArray[n] + " after " + cArray[n - 1] + " but got " + (char)parseTool.getChar());
            }
            ++n;
        }
        parseTool.skipSpaces();
        Builder builder = this.parseCondition(parseTool);
        if (null == builder) {
            throw new ParseToolException(parseTool, "Expected term/expression after operator  but got: " + (char)parseTool.getChar());
        }
        return builder;
    }

    private Builder parseNotCondition(ParseTool parseTool) throws ParseToolException, IOException {
        if (!parseTool.parseChar('!')) {
            return null;
        }
        parseTool.skipSpaces();
        Builder builder = this.parseCondition(parseTool);
        return new NotConditionBuilder(builder);
    }

    private Builder parseTermCondition(ParseTool parseTool) throws ParseToolException, IOException {
        Object object = WMParser.parseTerm(parseTool);
        return new TermConditionBuilder(object);
    }

    private Builder parseEqualCondition(Builder builder, ParseTool parseTool) throws ParseToolException, IOException {
        char[] cArray = new char[]{'=', '='};
        Builder builder2 = this.parseBinOp(cArray, parseTool);
        if (null == builder2) {
            return null;
        }
        return new EqualConditionBuilder(builder, builder2);
    }

    private Builder parseNotEqualCondition(Builder builder, ParseTool parseTool) throws ParseToolException, IOException {
        char[] cArray = new char[]{'!', '='};
        Builder builder2 = this.parseBinOp(cArray, parseTool);
        if (null == builder2) {
            return null;
        }
        EqualConditionBuilder equalConditionBuilder = new EqualConditionBuilder(builder, builder2);
        return new NotConditionBuilder(equalConditionBuilder);
    }

    private Builder parseAndCondition(Builder builder, ParseTool parseTool) throws ParseToolException, IOException {
        char[] cArray = new char[]{'&', '&'};
        Builder builder2 = this.parseBinOp(cArray, parseTool);
        if (null == builder2) {
            return null;
        }
        return new AndConditionBuilder(builder, builder2);
    }

    private Builder parseOrCondition(Builder builder, ParseTool parseTool) throws ParseToolException, IOException {
        char[] cArray = new char[]{'|', '|'};
        Builder builder2 = this.parseBinOp(cArray, parseTool);
        if (null == builder2) {
            return null;
        }
        return new OrConditionBuilder(builder, builder2);
    }
}

