/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.apache.ecs.Element;
import org.apache.ecs.html.Body;
import org.apache.ecs.html.FrameSet;
import org.apache.ecs.html.Head;
import org.apache.ecs.html.Html;
import org.apache.ecs.html.NoFrames;
import org.apache.ecs.html.Title;

public class FrameSetDocument
implements Serializable,
Cloneable {
    private Html html = new Html();
    private Head head = new Head();
    private Body body;
    private Title title = new Title();
    private FrameSet frameset = new FrameSet();
    private NoFrames noframes = new NoFrames();
    private String codeset = null;

    public FrameSetDocument() {
        this.body = new Body();
        this.head.addElement(this.title);
        this.html.addElement(this.head);
        this.html.addElement(this.frameset);
        this.html.addElement(this.noframes);
        this.noframes.addElement(this.body);
    }

    public FrameSetDocument(String string) {
        this.body = new Body();
        this.head.addElement(this.title);
        this.html.addElement(this.head);
        this.html.addElement(this.frameset);
        this.html.addElement(this.noframes);
        this.noframes.addElement(this.body);
        this.setCodeset(string);
    }

    public FrameSetDocument appendBody(String string) {
        this.body.addElement(string);
        return this;
    }

    public FrameSetDocument appendBody(Element element) {
        this.body.addElement(element);
        return this;
    }

    public FrameSetDocument appendFrameSet(String string) {
        this.frameset.addElement(string);
        return this;
    }

    public FrameSetDocument appendFrameSet(Element element) {
        this.frameset.addElement(element);
        return this;
    }

    public FrameSetDocument appendHead(String string) {
        this.head.addElement(string);
        return this;
    }

    public FrameSetDocument appendHead(Element element) {
        this.head.addElement(element);
        return this;
    }

    public FrameSetDocument appendTitle(String string) {
        this.title.addElement(string);
        return this;
    }

    public FrameSetDocument appendTitle(Element element) {
        this.title.addElement(element);
        return this;
    }

    public Object clone() {
        return this.html.clone();
    }

    public Body getBody() {
        return this.body;
    }

    public String getCodeset() {
        return this.codeset;
    }

    public FrameSet getFrameSet() {
        return this.frameset;
    }

    public Head getHead() {
        return this.head;
    }

    public Html getHtml() {
        return this.html;
    }

    public Title getTitle() {
        return this.title;
    }

    public void output(OutputStream outputStream) {
        this.html.output(outputStream);
    }

    public void output(PrintWriter printWriter) {
        this.html.output(printWriter);
    }

    public FrameSetDocument setBody(Body body2) {
        this.body = body2;
        return this;
    }

    public void setCodeset(String string) {
        this.codeset = string;
    }

    public FrameSetDocument setHead(FrameSet frameSet) {
        this.frameset = frameSet;
        return this;
    }

    public FrameSetDocument setHead(Head head2) {
        this.head = head2;
        return this;
    }

    public FrameSetDocument setHtml(Html html2) {
        this.html = html2;
        return this;
    }

    public FrameSetDocument setTitle(Title title2) {
        this.title = title2;
        return this;
    }

    public final String toString() {
        if (this.getCodeset() != null) {
            return this.html.toString(this.getCodeset());
        }
        return this.html.toString();
    }

    public final String toString(String string) {
        return this.html.toString(string);
    }
}

