/**
  SocketTest.java

  This is to demonstrate the functionality of Socket.class.

  This program
  0. connects to the port 80 of www.yahoo.com and 
  1. writes "GET / HTTP/1.0\n\n" and
  2. reads 1024 bytes and dumps them to a file called tmp.

  To run SocketTest, you need to use the application mode.
  Example: waba --as-application SocketTest

 */

import waba.io.Socket;
import waba.io.File;

public class SocketTest
{
	public static void main (String[] args)
	{
		Socket socket = new Socket ("www.yahoo.com", 80);
		File file = new File ("tmp", File.CREATE);
		byte get[] = { (byte)'G', (byte)'E', (byte)'T',
			(byte)' ', (byte)'/', (byte)' ', (byte)'H',
			(byte)'T', (byte)'T', (byte)'P', (byte)'/',
			(byte)'1', (byte)'.', (byte)'0', (byte)'\n',
			(byte)'\n' };

		byte b[] = new byte[1024];

		if (file.isOpen() && socket.isOpen())
		{
			int count;
			socket.writeBytes(get, 0, get.length);
			count = socket.readBytes(b, 0, 1024);
			if (count > 0)
			{
				file.writeBytes(b, 0, 1024);
				file.close();
			} else {
				b[0] = (byte) 'n';
				b[1] = (byte) 'o';
				b[2] = (byte) '!';
				b[3] = (byte) '\n';
				file.writeBytes(b, 0, 4);
				file.close();
			}
			socket.close();
		}

	}
}
