/* ------------------------------------------------------------------------
 * $Id: Line.hh,v 1.2 2001/07/31 11:50:39 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-07-27 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _Line_hh_
#define _Line_hh_

/**
 * General line class.
 **/
template <class T> class Line {
public:

    /**
     * Constructor.
     *
     * @param 
     **/
    Line(const T &p1, const T &p2) : _p(p1) { 
	_direction = p2 - p1;
	//_direction.normalize();
    }
    
    /**
     * Retrieve the defining point on the line.
     *
     * @return const reference to the starting point of the line.
     **/
    const T &p() const { return _p; }
    
    /**
     * Retrieve the line's direction vector (normalized).
     *
     * @return const reference to the line's direction vector.
     **/ 
    const T &getDirection() const {
	return _direction;
    }

    /**
     * Scalar multiplication operator. Accepts a parametric variable
     * and computes the vector for the desired point on the line
     * starting from the defining point p().
     * 
     * @return vector for the desired point.
     **/
    T operator * (float t) {
	return _p + t * _direction;
    }
				
private:
    T _p, _direction;
};

#endif /* Line.hh */
