/* ------------------------------------------------------------------------
 * $Id: EntityResolver.hh,v 1.1 2001/08/16 11:32:21 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * This C++ SAX implementation (Simple API for XML) is derived from
 * David Megginson's original Java SAX that can be found on 
 * http://www.megginson.com/SAX/.
 * ------------------------------------------------------------------------
 * File created 2001-08-14 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------ 
 */

#ifndef _SAXEntityResolver_hh_
#define _SAXEntityResolver_hh_

// -- System Includes
#include <string>

// -- Local Includes
//#include "Celsius/SAX/InputSource.hh"

namespace SAX {

    // -- Forward Declarations
    class InputSource;

    // -- Class Declarations
    
    /**
     * Basic interface for resolving entities.
     **/
    class EntityResolver {
    public:
	
	/**
	 * Constructor.
	 **/
	EntityResolver() { }
	
	/**
	 * Destructor.
	 **/
	virtual ~EntityResolver() { }
	
	/**
	 * Allow the application to resolve external entities. The
	 * Parser will call this method before opening any external
	 * entity except the top-level document entity (including the
	 * external DTD subset, external entities referenced within
	 * the DTD, and external entities referenced within the
	 * document element): the application may request that the
	 * parser resolve the entity itself, that it use an
	 * alternative URI, or that it use an entirely different input
	 * source.
	 *
	 * @param publicId notation's public identifier.
	 * @param systemId notation's system identifier.
	 **/
	virtual InputSource *resolveEntity(const std::string &publicId,
					   const std::string &systemId) = 0;
    };
    
};

#endif /* EntityResolver.hh */
