/* ------------------------------------------------------------------------
 * $Id: LogGroup.hh,v 1.2 2001/08/16 11:32:23 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-06-01 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _LogGroup_hh_
#define _LogGroup_hh_

/**
 * Log message group class.
 **/ 
class LogGroup {
public:

    /// General log messages
    static const char * const General	= "General";

    /// Server log messages
    static const char * const Server	= "Server";

    /// Thread-related log messages
    static const char * const Thread	= "Thread";

    /// Renderer log messages
    static const char * const Renderer	= "Renderer";

    /// Event log messages
    static const char * const Event	= "Event";

    /// Platform log messages
    static const char * const Platform	= "Platform";

    /// CORBA-related log messages
    static const char * const Corba	= "CORBA";

    /// Configuration log messages
    static const char * const Config	= "Config";
};

#endif /* LogGroup.hh */
