/* ------------------------------------------------------------------------
 * $Id: Instance.hh,v 1.1 2001/06/19 22:48:00 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-06-17 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _Instance_hh_
#define _Instance_hh_

#define ZORN_INSTANCE_CLASS(TYPE) \
	class Instance { \
	public:	\
	    Instance(TYPE *inst) : _inst(inst), _owner(true) { } \
	    Instance(const Instance &i) : _inst(i._inst), _owner(true) { \
	        i._owner = false; \
	    } \
  	    ~Instance() { \
	        if (_owner) delete _inst; \
	    } \
	    TYPE *operator -> () const { return _inst; } \
	private: \
            TYPE *_inst; \
	    mutable bool _owner; \
	}; \
	friend class Instance;

#endif /* Instance.hh */
