/* ------------------------------------------------------------------------
 * $Id: GeometryKitImpl.cc,v 1.11 2001/08/18 21:35:24 steve Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-08-01 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2000, 2001 Steve Houston <steve@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- 3Dwm Includes
#include "Celsius/debug.hh"
#include "Celsius/Mutex.hh"
#include "Polhem/TriangleGeometryImpl.hh"
#include "Polhem/LineGeometryImpl.hh"
#include "Polhem/PointGeometryImpl.hh"
#include "Polhem/AppearanceImpl.hh"
#include "Polhem/GeometryKitImpl.hh"

using namespace Nobel;

// -- Code Segment

LineGeometry_ptr GeometryKitImpl::createLineGeometry()
{
    // Create and activate the object, register and return it!
    LineGeometryImpl *geo = activate(new LineGeometryImpl());
    return geo->_this();
}

PointGeometry_ptr GeometryKitImpl::createPointGeometry()
{
    // Create and activate the object, register and return it!
    PointGeometryImpl *geo = activate(new PointGeometryImpl());
    return geo->_this();
}

TriangleGeometry_ptr GeometryKitImpl::createTriangleGeometry()
{
    // Create and activate the object, register and return it!
    TriangleGeometryImpl *geo = activate(new TriangleGeometryImpl());
    return geo->_this();
}

Appearance_ptr GeometryKitImpl::createAppearance()
{
    // Create and activate the object, register and return it!
    AppearanceImpl *appearance = activate(new AppearanceImpl());
    return appearance->_this();
}

