/*
  Fairy-Stockfish, a UCI chess variant playing engine derived from Stockfish
  Copyright (C) 2018-2020 Fabian Fichter

  Fairy-Stockfish is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Fairy-Stockfish is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef MAGIC_H_INCLUDED
#define MAGIC_H_INCLUDED

#ifdef PRECOMPUTED_MAGICS
#define B(a, b) (Bitboard(a) << 64) ^ Bitboard(b)
  // Use precomputed magics if pext is not avaible,
  // since the magics generation is very slow.
  Bitboard RookMagicHInit[SQUARE_NB] = {
      B(0x120000880110000, 0x1008000000020020),
      B(0x24200C080840A052, 0x2004004000010008),
      B(0xC030024000228800, 0x4000010400000020),
      B(0x1A0020802008802, 0x206010208000),
      B(0x12002000D001024, 0x80100800090138),
      B(0x4220010000241010, 0x3098000602001500),
      B(0x401010004801040, 0x8000280480100000),
      B(0x820082024921836, 0x220028000),
      B(0x100400502411400, 0x220402120240D14),
      B(0x880202020010404, 0xA80202510000),
      B(0x140002801000018, 0x1000346490040),
      B(0x120000880110000, 0x1008000000020020),
      B(0xD01004008030400, 0x104000408104420),
      B(0x8420060100020000, 0x800280400000120),
      B(0x4010020018010, 0x40A00001100000),
      B(0x40006A0004000200, 0x40000000110),
      B(0xD01004008030400, 0x104000408104420),
      B(0x8908A20028110011, 0x800080000001A114),
      B(0x200042000080F009, 0x20001000004000),
      B(0x2820008820100, 0x10002400058000B9),
      B(0x6083100420008050, 0x4040012600280080),
      B(0x216020000000446, 0x4080204000000211),
      B(0x340140003002089, 0x2402008000000911),
      B(0xD01004008030400, 0x104000408104420),
      B(0x1404040B20001000, 0x8000824010800011),
      B(0x8C0488120024214, 0x8414880202291),
      B(0x1010000060050000, 0x4000004050002602),
      B(0x4022983A0060000, 0x80000040010400),
      B(0x1404040B20001000, 0x8000824010800011),
      B(0x6020101802002840, 0x31000003000004),
      B(0x9000420008840, 0x4881300000000210),
      B(0xA200808865, 0x41C0048023000128),
      B(0x31801100400000, 0x8802DC001221240),
      B(0x884000080200920, 0x1004002410401001),
      B(0x2400040000884, 0x421006208040C0),
      B(0x1404040B20001000, 0x8000824010800011),
      B(0x24100400060009, 0x112008025042410),
      B(0x1800040009040200, 0x180000A1004E408A),
      B(0x24100400060009, 0x112008025042410),
      B(0x4060402008080, 0xC240080000110000),
      B(0x20080100920020, 0x2002248010242052),
      B(0x10001010802050, 0x880000001C98420),
      B(0x4000800100420022, 0x502022010A00D0),
      B(0x4C18104500200885, 0x400880800),
      B(0x8080810081020090, 0x8000000000000),
      B(0x8000062812080201, 0x8004C8300800),
      B(0xC010220920198, 0x85000A08000),
      B(0x24100400060009, 0x112008025042410),
      B(0x80102204040, 0x1000000900000000),
      B(0x2080000004202804, 0x120880003461),
      B(0x102004090A4030, 0x801020589240),
      B(0x20001100814000A0, 0x420202000820004),
      B(0x100800000A000120, 0x208000800010000),
      B(0x1008205000040802, 0x80002000400040),
      B(0x1480000098008401, 0xA0010000581010),
      B(0x30C0008200100820, 0x102800080904834),
      B(0x4810821884000500, 0x4400000200000212),
      B(0x1811D00128A0180, 0x2500848803000000),
      B(0x41618A0300040040, 0x21200200A421801),
      B(0x80102204040, 0x1000000900000000),
      B(0xA1808E0100108000, 0x2008000505000002),
      B(0x8C890020410000A0, 0xA010000048000400),
      B(0x40006002210044, 0x600008000408000),
      B(0x1200447220090042, 0x80001000160012),
      B(0x48410010AB000000, 0x9200600000000100),
      B(0x2040000000240003, 0x8020080288000600),
      B(0x9080000088848088, 0x4010210500000041),
      B(0xA1808E0100108000, 0x2008000505000002),
      B(0x480100400024, 0x1004800018200000),
      B(0x808403080080200, 0x802601000000500),
      B(0x8C890020410000A0, 0xA010000048000400),
      B(0xA1808E0100108000, 0x2008000505000002),
      B(0x100A40000004008, 0x2800200400200480),
      B(0x100A40000004008, 0x2800200400200480),
      B(0x400014006000000, 0x10006000810001F5),
      B(0xC410062001414, 0x820080041B01044),
      B(0x20000800310, 0x430040000201000),
      B(0xA40010008000008, 0x4002200028000040),
      B(0xC00102000008021C, 0x10C2000A010E024),
      B(0x80004200104008, 0x50A00800C400020),
      B(0x20200080012542, 0x910F0040000402C0),
      B(0xB040100504000300, 0x24802002000040),
      B(0x800001000014008, 0x400031004000),
      B(0x100A40000004008, 0x2800200400200480),
      B(0x84008002041081C0, 0x8080500200000000),
      B(0x440090001012001, 0x4020004010),
      B(0x100A0028088020, 0x80040E00010020),
      B(0x2180808000810, 0xB018040A00040000),
      B(0x40C80920304C4001, 0x42800B200800000),
      B(0x85000425001000, 0x4810048020001100),
      B(0x600C000801000004, 0x8015084010200020),
      B(0x20020050000240C0, 0x100202008600800),
      B(0x38000050001220, 0x9200010200145900),
      B(0x1042108040005, 0x1402A0802201001),
      B(0x824240000C20400, 0x1000000400080010),
      B(0x84008002041081C0, 0x8080500200000000),
      B(0x400804A1000008, 0x1024104A0200010),
      B(0x8000402308483, 0x20006020100100),
      B(0x80880120000080, 0x8000240100084),
      B(0x5840020004882001, 0x1004528000A00010),
      B(0x8001018800300002, 0x84010040804),
      B(0x180D10004000A008, 0xA001080008020004),
      B(0x400080B, 0x10A0000004010000),
      B(0x8080000200000, 0x2001000082004E0),
      B(0x40040001000C2000, 0x2024800001004008),
      B(0x400804A1000008, 0x1024104A0200010),
      B(0x8000402308483, 0x20006020100100),
      B(0x400804A1000008, 0x1024104A0200010),
      B(0x2000200000, 0x1201011000802),
      B(0x100100000000C4, 0x208004084048201),
      B(0x400084000044, 0x100810140300),
      B(0x29040C0C01010, 0x300204010820080),
      B(0x1A808000020200, 0x1000000005210040),
      B(0x20000400150000, 0x85008020),
      B(0x40C040008184014, 0x8002AA00024010),
      B(0x202000081B00804, 0x10001002008),
      B(0x40011000210060, 0x6080C40000021004),
      B(0x2000200000, 0x1201011000802),
      B(0x4100480203840, 0x300080100804),
      B(0x2000200000, 0x1201011000802),
  };
  Bitboard RookMagicVInit[SQUARE_NB] = {
      B(0x202000812104400, 0x24800B01C0000303),
      B(0x340020400010D, 0x88060150C00400),
      B(0x400802040609, 0x49010200501A0002),
      B(0x8002680301000208, 0x628006C0C020200),
      B(0x20400209001C0804, 0xA044000800143110),
      B(0xC400082060010202, 0x4000480401014000),
      B(0x22500200144040, 0x8204820084704C00),
      B(0x8C1204009030020, 0x328400805000000),
      B(0x84800800D0001640, 0x200080040060108),
      B(0x804810208020040, 0x140010108020000),
      B(0x1102010B008004, 0x300208006220020),
      B(0x140080404A0A2428, 0x6308010100080),
      B(0x20444002120408, 0xA080010508010001),
      B(0x82011044000D02, 0x4112028620110809),
      B(0x81010831000C02, 0x408802085000000),
      B(0x81010831000C02, 0x408802085000000),
      B(0x920008920600040, 0x8053801004000028),
      B(0x81140283208300, 0x10040C004200420),
      B(0x103080022201, 0xC01000081312620),
      B(0x2200221100008, 0x1000408104000A4),
      B(0x4402088080042008, 0x210401501040340),
      B(0x898400202170001, 0x80040404208000),
      B(0x20080004051012, 0x5100048200081800),
      B(0x2320020000401018, 0x108501021040210),
      B(0x21080410A422021, 0x83040180008800),
      B(0x44E8100000408224, 0x20010008040400),
      B(0x1800240002810405, 0x23004820000020),
      B(0x80A0100400110, 0x80104020100C4028),
      B(0x1002050001222C0, 0x5100818004024020),
      B(0x104000200040, 0xC010A09800102000),
      B(0x1020003A058120, 0x450900809000302),
      B(0x40040045008B1, 0x202800400383010),
      B(0x4640200220034, 0x8800485420304000),
      B(0x5001042100084288, 0x110820001240080A),
      B(0x2002C04004010120, 0xA15008020880001),
      B(0x2800004080C4190, 0x890808280020080),
      B(0x40C0401000104000, 0x2020880008002580),
      B(0x40020C002400802, 0x801104010000000),
      B(0x44842000040080, 0x2050011084000400),
      B(0x4110040800000401, 0x2023810029008000),
      B(0x20884000840, 0x8017102004008000),
      B(0x10411104000480, 0x1414042000201001),
      B(0x220040000008, 0x800306021000000),
      B(0x41400A0008080, 0x501000298ACAD10),
      B(0x800240012831810, 0x80120004468050E),
      B(0x800005020801008, 0x20102400240000),
      B(0x20C00040C114C010, 0x88080820200C00),
      B(0x1044010100820081, 0x20080841004000),
      B(0x8041048400022, 0x8020836040005002),
      B(0x2001004010205, 0x8001002884042009),
      B(0x128088400087, 0x20008002201002),
      B(0x8084108040402000, 0x80809000A080400),
      B(0x408081840880, 0x201002088000040),
      B(0xA40180010280, 0x241004006000010),
      B(0x4204100080048140, 0x2002C4F104202020),
      B(0x100140A10204, 0x980200800840060),
      B(0x1005140010202048, 0x1442280800202815),
      B(0x2000082025008600, 0x1108400040600003),
      B(0x1005050648000, 0x200020240008002),
      B(0x202010208044000, 0x8210404060008),
      B(0x8011040402000210, 0xC840180408016004),
      B(0x404098801028, 0x80020A0001000400),
      B(0x404098801028, 0x80020A0001000400),
      B(0x80101002180140, 0x40C2080820000C0),
      B(0x208202081260800, 0x14090E4C04000050),
      B(0x4221201084004C2, 0x110480A011060),
      B(0x8000008421090204, 0x1C01010800024),
      B(0x8000008421090204, 0x1C01010800024),
      B(0x200180C840088A0, 0x401100400820000),
      B(0x10084043A021070, 0x202041600080200),
      B(0x210E6202001040C, 0x10100800080B0),
      B(0x848008021204002, 0x801004308100BAD),
      B(0xC082C0390A000601, 0x4040080189008),
      B(0x431200240210402D, 0x58102820000),
      B(0x202020100A0019B0, 0x4010C0D018000000),
      B(0x800800908402203, 0x102948C84C184),
      B(0x26801100080845, 0x4009702022A00820),
      B(0x8880520010401040, 0x1060084832052000),
      B(0x100100022042081, 0x10000600008C121),
      B(0x46020384100040, 0x800200320882021),
      B(0xC0002010148, 0x4200800800040003),
      B(0x2002208020090040, 0x40820210021410),
      B(0x9000A41160002004, 0x2A09000100080043),
      B(0x800004010008001, 0x1108002020104600),
      B(0x800540C000A4E041, 0x18021180000401),
      B(0x808200900A900202, 0x8364202140012005),
      B(0x1DBA52000081010, 0x4008000023000010),
      B(0x4100110204401481, 0x800040091020001C),
      B(0x4100110204401481, 0x800040091020001C),
      B(0x4101100020400482, 0x2000402302100120),
      B(0x100408000A020212, 0xA000400111000020),
      B(0x2000010488080104, 0x3000404410208100),
      B(0x2684220180008DD0, 0x422040200004000A),
      B(0x2021200C0424, 0x1010100000080200),
      B(0x8908020020801006, 0x3010800020C2000),
      B(0x4000030008062044, 0x244010202688000),
      B(0x242101200408009, 0x8150040000200015),
      B(0x42004C02180204, 0x210208014241040),
      B(0x4E1A01C208410804, 0x8890041000012004),
      B(0x2080200401000080, 0x8001098429008004),
      B(0xA01400121804104, 0x280200C400000500),
      B(0xD0080408040420, 0x1006040100224000),
      B(0x28400205000800C9, 0x6021101401040075),
      B(0x4000900040020104, 0x88129801100D0C),
      B(0x8000004002180410, 0x400380200400204),
      B(0x4002A430043008, 0x400200340100020),
      B(0x401960004140A42, 0x100880710000464),
      B(0x58014090102, 0xB8D30004010080),
      B(0xA004C08000244000, 0x11280100E0000040),
      B(0x2102008089208804, 0x110001004080040),
      B(0x700010084E003004, 0x8080864112000D40),
      B(0x4080881000200C20, 0x30324040880E0600),
      B(0x2024A40401810820, 0x3000888002000000),
      B(0x8200100400014, 0x4400340800252844),
      B(0x24A00804288281, 0x410103002201140),
      B(0x4080005022A08, 0x1000402200100264),
      B(0x200080032244040, 0x200502189010001),
      B(0x28108110404001, 0x400600120008412),
      B(0xA00002102810020, 0xB1080240015408),
      B(0x810080200806, 0x410440804080046)
  };
  Bitboard BishopMagicInit[SQUARE_NB] = {
      B(0x2001040305000010, 0x830200040400082),
      B(0x1042400080E01200, 0x2004904010811400),
      B(0x400010120200, 0x880080D080018000),
      B(0x240190C00100040, 0x100A020140044404),
      B(0x1018010404010004, 0x1001010018081E0),
      B(0x41200A804C0904, 0x40000322000008),
      B(0x4001180A004, 0x8000001106000000),
      B(0x6006020020030600, 0x1840002100004841),
      B(0x4200200100, 0x4001041808002000),
      B(0x4100020050124600, 0x1001802902400CA0),
      B(0x448C0081440161, 0x200206010008000),
      B(0x400008008008408, 0x1000080210100080),
      B(0x200280C01008200, 0x210200813000080),
      B(0x1A000204400, 0x222200401023000),
      B(0x10081040640A00, 0x8410021881400000),
      B(0x1840400318080008, 0x800800840080000),
      B(0x4204050C040, 0x6500600200140000),
      B(0x1012100040204, 0x402404444400000),
      B(0x6000012680008240, 0x410140000004220),
      B(0x1000020810040008, 0x2D0011000060000),
      B(0x1020020400, 0x400108059001001),
      B(0x400020001100808, 0x480204800200000B),
      B(0x10000010030084, 0x2042000848900022),
      B(0x10000010030084, 0x2042000848900022),
      B(0x100D801402400, 0x1512404009000400),
      B(0x8000208005112400, 0xA02040401000000),
      B(0x1000420002800200, 0x4CA000183020000),
      B(0x800811480020, 0x408801010224001),
      B(0xC805200810900100, 0x9000084204004020),
      B(0x8200160204100004, 0x8040004004002022),
      B(0x104514013080080, 0x146410040001000),
      B(0x140844000080002, 0x1008102020040001),
      B(0x4040400041A2002, 0x8040000A8802510),
      B(0x801014041008002, 0x80068008025200),
      B(0xA00540A414040, 0x4101040010A0000),
      B(0x6484008010810002, 0x1100506884024000),
      B(0x2800401008006000, 0x1005420884029020),
      B(0x6822091010004421, 0x2000458080480),
      B(0x40101000200101, 0x10020100001C4E0),
      B(0x100400008C42, 0x4000100009008000),
      B(0x851220018800400, 0x1681800040080080),
      B(0x64200002010, 0x900020200040002),
      B(0x20800080000022, 0x80040810002010),
      B(0xA88408000802080, 0x20808001000000),
      B(0x200000400C005040, 0x100140020290108),
      B(0x224100000800408, 0x4204802004400020),
      B(0x80080620010210, 0x91080088804040),
      B(0x4008002100010, 0x80AC201001000001),
      B(0x10008200902C046, 0x8080D03004000010),
      B(0x3002100081000180, 0x2210002121528408),
      B(0x8C101800804420, 0x1019880200043008),
      B(0x200022000920D0, 0x8000800081300020),
      B(0x1D40800880000, 0x400040001400050),
      B(0x2020004100040, 0x200008040008008),
      B(0x4840800040100001, 0x100100040203040),
      B(0x40084001105, 0x8800080088000089),
      B(0x4000128008020008, 0x4004200200440020),
      B(0x210040008520000, 0x820219001080022),
      B(0x1494040018002116, 0x400101047020008),
      B(0x510008001910C224, 0x80200148118000),
      B(0xC0301002301000, 0x4211A08004801),
      B(0x50008E0C01001080, 0x100C004102845100),
      B(0x400600020060400, 0x88024100250050),
      B(0x8202920002002040, 0x810012000003),
      B(0x800004208800200, 0x18AA00201000048),
      B(0x402100800100002, 0x411000081000400),
      B(0x101000022004044, 0x9000100040000),
      B(0x41068001001, 0xC00400010001),
      B(0x310210001040, 0x1A1200020010000),
      B(0xA082409200004048, 0x490040800124101),
      B(0x18844820E0040212, 0x1000404420D10000),
      B(0x802908A40003348, 0x20200040104140),
      B(0x1800404028205003, 0xC020010401089020),
      B(0x802100044D01000, 0x8C41888000800040),
      B(0x1D0161011410081, 0x10008000100200),
      B(0x401000480040100, 0x286800404002212),
      B(0x821030000100009, 0x2000090200A00000),
      B(0x200020800200800, 0x2000480900841012),
      B(0x80A000048030080, 0x200000120200008),
      B(0x40B1400008020020, 0x148000200008004),
      B(0xA021700002002010, 0x3040E400040100),
      B(0x400242C200200640, 0x20440210200281),
      B(0x80AC140040206240, 0x120000102801401),
      B(0x2020340040832040, 0x10402100A44000),
      B(0x420100400040220, 0x80014C8004000106),
      B(0x504300822421120, 0x8004004008400100),
      B(0x2001100008040, 0x2020104302000000),
      B(0xA500802000A, 0x2008008000114100),
      B(0x8A0020000200, 0x9C00101001002408),
      B(0x104000001001008, 0x9001000204040060),
      B(0x1000820080108200, 0xA401000008100001),
      B(0x2008600009000480, 0x9008020001400000),
      B(0x4000800200040200, 0xA00030400308082),
      B(0x4004300202004709, 0x1000100180010020),
      B(0xC014800100440010, 0x402020280002C010),
      B(0x220208010884680, 0x1040280000042110),
      B(0x40B0018019202801, 0x1008408000100040),
      B(0x8269010206080044, 0x8001810000000040),
      B(0x4000020880081040, 0x208A44000028000),
      B(0x4004004E9004220A, 0x2104004001400024),
      B(0x8035006008C0904, 0x402002001080120),
      B(0x1800884002, 0x404400820000000),
      B(0x8088000004008910, 0x8024100401000000),
      B(0x142200086000100, 0x28021040020002E),
      B(0x1000409141004018, 0x100410820080040A),
      B(0x1800801800140, 0x810801060C0801),
      B(0x1000C00100402220, 0x808023420000000),
      B(0x8A0A202414305008, 0x100040200000021),
      B(0xC0208024050, 0x8003088008020401),
      B(0x8044004201440101, 0x400820080C024022),
      B(0x406018884120099, 0xB00088018002000),
      B(0x2000800010403010, 0xC5A002002010010),
      B(0x800020040840, 0x201800202800200),
      B(0x201280120020008D, 0x258809001000040),
      B(0x9100002020181, 0x80400082204000),
      B(0x104010080201001, 0x40080080181080),
      B(0x8440248092000430, 0xA200804900100000),
      B(0x2031010C01000C20, 0x200310A560082008),
      B(0x400202081811400, 0x40081802050000C),
      B(0x1011002100821300, 0x2400825040804100)
  };
  Bitboard CannonMagicHInit[SQUARE_NB] = {
      B(0x120000880110000, 0x1008000000020020),
      B(0x24200C080840A052, 0x2004004000010008),
      B(0xC030024000228800, 0x4000010400000020),
      B(0x1A0020802008802, 0x206010208000),
      B(0x12002000D001024, 0x80100800090138),
      B(0x4220010000241010, 0x3098000602001500),
      B(0x401010004801040, 0x8000280480100000),
      B(0x820082024921836, 0x220028000),
      B(0x100400502411400, 0x220402120240D14),
      B(0x880202020010404, 0xA80202510000),
      B(0x140002801000018, 0x1000346490040),
      B(0x120000880110000, 0x1008000000020020),
      B(0xD01004008030400, 0x104000408104420),
      B(0x8420060100020000, 0x800280400000120),
      B(0x4010020018010, 0x40A00001100000),
      B(0x40006A0004000200, 0x40000000110),
      B(0xD01004008030400, 0x104000408104420),
      B(0x8908A20028110011, 0x800080000001A114),
      B(0x200042000080F009, 0x20001000004000),
      B(0x2820008820100, 0x10002400058000B9),
      B(0x6083100420008050, 0x4040012600280080),
      B(0x216020000000446, 0x4080204000000211),
      B(0x340140003002089, 0x2402008000000911),
      B(0xD01004008030400, 0x104000408104420),
      B(0x1404040B20001000, 0x8000824010800011),
      B(0x8C0488120024214, 0x8414880202291),
      B(0x1010000060050000, 0x4000004050002602),
      B(0x4022983A0060000, 0x80000040010400),
      B(0x1404040B20001000, 0x8000824010800011),
      B(0x6020101802002840, 0x31000003000004),
      B(0x9000420008840, 0x4881300000000210),
      B(0xA200808865, 0x41C0048023000128),
      B(0x31801100400000, 0x8802DC001221240),
      B(0x884000080200920, 0x1004002410401001),
      B(0x2400040000884, 0x421006208040C0),
      B(0x1404040B20001000, 0x8000824010800011),
      B(0x24100400060009, 0x112008025042410),
      B(0x1800040009040200, 0x180000A1004E408A),
      B(0x24100400060009, 0x112008025042410),
      B(0x4060402008080, 0xC240080000110000),
      B(0x20080100920020, 0x2002248010242052),
      B(0x10001010802050, 0x880000001C98420),
      B(0x4000800100420022, 0x502022010A00D0),
      B(0x4C18104500200885, 0x400880800),
      B(0x8080810081020090, 0x8000000000000),
      B(0x8000062812080201, 0x8004C8300800),
      B(0x1800040009040200, 0x180000A1004E408A),
      B(0x24100400060009, 0x112008025042410),
      B(0x80102204040, 0x1000000900000000),
      B(0x2080000004202804, 0x120880003461),
      B(0x102004090A4030, 0x801020589240),
      B(0x20001100814000A0, 0x420202000820004),
      B(0x100800000A000120, 0x208000800010000),
      B(0x1008205000040802, 0x80002000400040),
      B(0x1480000098008401, 0xA0010000581010),
      B(0x30C0008200100820, 0x102800080904834),
      B(0x4810821884000500, 0x4400000200000212),
      B(0x1811D00128A0180, 0x2500848803000000),
      B(0x41618A0300040040, 0x21200200A421801),
      B(0x80102204040, 0x1000000900000000),
      B(0xA1808E0100108000, 0x2008000505000002),
      B(0x8C890020410000A0, 0xA010000048000400),
      B(0x40006002210044, 0x600008000408000),
      B(0x1200447220090042, 0x80001000160012),
      B(0x48410010AB000000, 0x9200600000000100),
      B(0x2040000000240003, 0x8020080288000600),
      B(0x9080000088848088, 0x4010210500000041),
      B(0xA1808E0100108000, 0x2008000505000002),
      B(0x480100400024, 0x1004800018200000),
      B(0x808403080080200, 0x802601000000500),
      B(0x8C890020410000A0, 0xA010000048000400),
      B(0xA1808E0100108000, 0x2008000505000002),
      B(0x100A40000004008, 0x2800200400200480),
      B(0x100A40000004008, 0x2800200400200480),
      B(0x400014006000000, 0x10006000810001F5),
      B(0xC410062001414, 0x820080041B01044),
      B(0x20000800310, 0x430040000201000),
      B(0xA40010008000008, 0x4002200028000040),
      B(0xC00102000008021C, 0x10C2000A010E024),
      B(0x80004200104008, 0x50A00800C400020),
      B(0x20200080012542, 0x910F0040000402C0),
      B(0xB040100504000300, 0x24802002000040),
      B(0x800001000014008, 0x400031004000),
      B(0x100A40000004008, 0x2800200400200480),
      B(0x84008002041081C0, 0x8080500200000000),
      B(0x440090001012001, 0x4020004010),
      B(0x100A0028088020, 0x80040E00010020),
      B(0x2180808000810, 0xB018040A00040000),
      B(0x40C80920304C4001, 0x42800B200800000),
      B(0x85000425001000, 0x4810048020001100),
      B(0x600C000801000004, 0x8015084010200020),
      B(0x20020050000240C0, 0x100202008600800),
      B(0x38000050001220, 0x9200010200145900),
      B(0x1042108040005, 0x1402A0802201001),
      B(0x824240000C20400, 0x1000000400080010),
      B(0x84008002041081C0, 0x8080500200000000),
      B(0x400804A1000008, 0x1024104A0200010),
      B(0x8000402308483, 0x20006020100100),
      B(0x80880120000080, 0x8000240100084),
      B(0x5840020004882001, 0x1004528000A00010),
      B(0x8001018800300002, 0x84010040804),
      B(0x180D10004000A008, 0xA001080008020004),
      B(0x400080B, 0x10A0000004010000),
      B(0x8080000200000, 0x2001000082004E0),
      B(0x40040001000C2000, 0x2024800001004008),
      B(0x400804A1000008, 0x1024104A0200010),
      B(0x8000402308483, 0x20006020100100),
      B(0x400804A1000008, 0x1024104A0200010),
      B(0x2000200000, 0x1201011000802),
      B(0x100100000000C4, 0x208004084048201),
      B(0x400084000044, 0x100810140300),
      B(0x29040C0C01010, 0x300204010820080),
      B(0x1A808000020200, 0x1000000005210040),
      B(0x20000400150000, 0x85008020),
      B(0x40C040008184014, 0x8002AA00024010),
      B(0x202000081B00804, 0x10001002008),
      B(0x40011000210060, 0x6080C40000021004),
      B(0x2000200000, 0x1201011000802),
      B(0x4100480203840, 0x300080100804),
      B(0x2000200000, 0x1201011000802),
  };
  Bitboard CannonMagicVInit[SQUARE_NB] = {
      B(0x202000812104400, 0x24800B01C0000303),
      B(0x340020400010D, 0x88060150C00400),
      B(0x400802040609, 0x49010200501A0002),
      B(0x8002680301000208, 0x628006C0C020200),
      B(0x20400209001C0804, 0xA044000800143110),
      B(0xC400082060010202, 0x4000480401014000),
      B(0x22500200144040, 0x8204820084704C00),
      B(0x8C1204009030020, 0x328400805000000),
      B(0x84800800D0001640, 0x200080040060108),
      B(0x804810208020040, 0x140010108020000),
      B(0x1102010B008004, 0x300208006220020),
      B(0x140080404A0A2428, 0x6308010100080),
      B(0x20444002120408, 0xA080010508010001),
      B(0x82011044000D02, 0x4112028620110809),
      B(0x81010831000C02, 0x408802085000000),
      B(0x81010831000C02, 0x408802085000000),
      B(0x920008920600040, 0x8053801004000028),
      B(0x81140283208300, 0x10040C004200420),
      B(0x103080022201, 0xC01000081312620),
      B(0x2200221100008, 0x1000408104000A4),
      B(0x4402088080042008, 0x210401501040340),
      B(0x898400202170001, 0x80040404208000),
      B(0x20080004051012, 0x5100048200081800),
      B(0x2320020000401018, 0x108501021040210),
      B(0x21080410A422021, 0x83040180008800),
      B(0x44E8100000408224, 0x20010008040400),
      B(0x1800240002810405, 0x23004820000020),
      B(0x80A0100400110, 0x80104020100C4028),
      B(0x1002050001222C0, 0x5100818004024020),
      B(0x104000200040, 0xC010A09800102000),
      B(0x1020003A058120, 0x450900809000302),
      B(0x40040045008B1, 0x202800400383010),
      B(0x4640200220034, 0x8800485420304000),
      B(0x5001042100084288, 0x110820001240080A),
      B(0x2002C04004010120, 0xA15008020880001),
      B(0x2800004080C4190, 0x890808280020080),
      B(0x40C0401000104000, 0x2020880008002580),
      B(0x40020C002400802, 0x801104010000000),
      B(0x44842000040080, 0x2050011084000400),
      B(0x4110040800000401, 0x2023810029008000),
      B(0x20884000840, 0x8017102004008000),
      B(0x10411104000480, 0x1414042000201001),
      B(0x220040000008, 0x800306021000000),
      B(0x41400A0008080, 0x501000298ACAD10),
      B(0x800240012831810, 0x80120004468050E),
      B(0x800005020801008, 0x20102400240000),
      B(0x20C00040C114C010, 0x88080820200C00),
      B(0x1044010100820081, 0x20080841004000),
      B(0x8041048400022, 0x8020836040005002),
      B(0x2001004010205, 0x8001002884042009),
      B(0x128088400087, 0x20008002201002),
      B(0x8084108040402000, 0x80809000A080400),
      B(0x408081840880, 0x201002088000040),
      B(0xA40180010280, 0x241004006000010),
      B(0x4204100080048140, 0x2002C4F104202020),
      B(0x100140A10204, 0x980200800840060),
      B(0x1005140010202048, 0x1442280800202815),
      B(0x2000082025008600, 0x1108400040600003),
      B(0x1005050648000, 0x200020240008002),
      B(0x202010208044000, 0x8210404060008),
      B(0x8011040402000210, 0xC840180408016004),
      B(0x404098801028, 0x80020A0001000400),
      B(0x404098801028, 0x80020A0001000400),
      B(0x80101002180140, 0x40C2080820000C0),
      B(0x208202081260800, 0x14090E4C04000050),
      B(0x4221201084004C2, 0x110480A011060),
      B(0x8000008421090204, 0x1C01010800024),
      B(0x8000008421090204, 0x1C01010800024),
      B(0x200180C840088A0, 0x401100400820000),
      B(0x10084043A021070, 0x202041600080200),
      B(0x210E6202001040C, 0x10100800080B0),
      B(0x848008021204002, 0x801004308100BAD),
      B(0xC082C0390A000601, 0x4040080189008),
      B(0x431200240210402D, 0x58102820000),
      B(0x202020100A0019B0, 0x4010C0D018000000),
      B(0x800800908402203, 0x102948C84C184),
      B(0x26801100080845, 0x4009702022A00820),
      B(0x8880520010401040, 0x1060084832052000),
      B(0x100100022042081, 0x10000600008C121),
      B(0x46020384100040, 0x800200320882021),
      B(0xC0002010148, 0x4200800800040003),
      B(0x2002208020090040, 0x40820210021410),
      B(0x9000A41160002004, 0x2A09000100080043),
      B(0x800004010008001, 0x1108002020104600),
      B(0x800540C000A4E041, 0x18021180000401),
      B(0x808200900A900202, 0x8364202140012005),
      B(0x1DBA52000081010, 0x4008000023000010),
      B(0x4100110204401481, 0x800040091020001C),
      B(0x4100110204401481, 0x800040091020001C),
      B(0x4101100020400482, 0x2000402302100120),
      B(0x100408000A020212, 0xA000400111000020),
      B(0x2000010488080104, 0x3000404410208100),
      B(0x2684220180008DD0, 0x422040200004000A),
      B(0x2021200C0424, 0x1010100000080200),
      B(0x8908020020801006, 0x3010800020C2000),
      B(0x4000030008062044, 0x244010202688000),
      B(0x242101200408009, 0x8150040000200015),
      B(0x42004C02180204, 0x210208014241040),
      B(0x4E1A01C208410804, 0x8890041000012004),
      B(0x2080200401000080, 0x8001098429008004),
      B(0xA01400121804104, 0x280200C400000500),
      B(0xD0080408040420, 0x1006040100224000),
      B(0x28400205000800C9, 0x6021101401040075),
      B(0x4000900040020104, 0x88129801100D0C),
      B(0x8000004002180410, 0x400380200400204),
      B(0x4002A430043008, 0x400200340100020),
      B(0x401960004140A42, 0x100880710000464),
      B(0x58014090102, 0xB8D30004010080),
      B(0xA004C08000244000, 0x11280100E0000040),
      B(0x2102008089208804, 0x110001004080040),
      B(0x700010084E003004, 0x8080864112000D40),
      B(0x4080881000200C20, 0x30324040880E0600),
      B(0x2024A40401810820, 0x3000888002000000),
      B(0x8200100400014, 0x4400340800252844),
      B(0x24A00804288281, 0x410103002201140),
      B(0x4080005022A08, 0x1000402200100264),
      B(0x200080032244040, 0x200502189010001),
      B(0x28108110404001, 0x400600120008412),
      B(0xA00002102810020, 0xB1080240015408),
      B(0x810080200806, 0x410440804080046),
  };
  Bitboard HorseMagicInit[SQUARE_NB] = {
      B(0x3C080482A592000C, 0x540104000020000),
      B(0x2802C40008000420, 0x4A00000001818009),
      B(0x1083040280804000, 0x120004C20100880),
      B(0x6840940880000892, 0x2014A01080800C2),
      B(0x8401489004000180, 0x2000800000400000),
      B(0x820161C800000110, 0x8000100000204020),
      B(0x610011A122000109, 0x1000004020008004),
      B(0x83282004023000, 0xE000020004848446),
      B(0x6840940880000892, 0x2014A01080800C2),
      B(0x4020120800800002, 0x88008000010020),
      B(0x30025B140A1000, 0x3141801401000040),
      B(0x41104D1810100050, 0x8141002010910),
      B(0x4200828A298400, 0x400340001040C000),
      B(0x8016A4900110040, 0x844812001068020),
      B(0x2250035820400A2, 0x8012010080900),
      B(0x820080083A009000, 0x880404091080110),
      B(0x80401500AF0020, 0x240000082201A04),
      B(0x668020020C081005, 0x4008001004100021),
      B(0x240100910000000, 0x82000A0030454000),
      B(0xA24091400008, 0x200014880004A921),
      B(0x840110042200410, 0x100080000A400000),
      B(0x40024024102000, 0x1000000002180404),
      B(0x92828423000530, 0x118800020110),
      B(0x1122404A1C90A8, 0x822040280020D00),
      B(0x41201A40900A000, 0x80C0480040605100),
      B(0x2504A85005488280, 0x3028112120022800),
      B(0x210180080626B048, 0x8000401000014000),
      B(0x1000410401040200, 0x41014000050C0106),
      B(0x1040650210802200, 0x80C0041000000),
      B(0x4020C10110900002, 0x2140C2001050009),
      B(0x191180092200022, 0x6010008400400800),
      B(0x8010821088080202, 0xCA240011008208),
      B(0x8C0488120024214, 0x8414880202291),
      B(0x8C0488120024214, 0x8414880202291),
      B(0x22080C8A0161401, 0x200C10004C002002),
      B(0x8430818023034080, 0x210090800000801),
      B(0x4845087008200, 0x40661480000),
      B(0x1202804428812050, 0x100022038020000),
      B(0x400016001201080, 0x24002200402060),
      B(0x680E041300800800, 0xE00130080004000),
      B(0x3409080200, 0x282840210000000),
      B(0x803310108400, 0x85200000080100A0),
      B(0xE180008A04162104, 0x9088240412404),
      B(0x20080100920020, 0x2002248010242052),
      B(0x8A000400C2410, 0x1000024086014300),
      B(0x1821040024663, 0x100000100010009),
      B(0x4000822310611, 0x120280406014008),
      B(0x1004008010818D08, 0x800000141892000),
      B(0x8010800004024042, 0x44B106008800896),
      B(0xA0063423444, 0x41002C15811008),
      B(0x2040012381001282, 0x4804080104A4000),
      B(0x10840101820880, 0xA800008000020020),
      B(0x10840101820880, 0xA800008000020020),
      B(0x60201D8300408190, 0x2010020920200000),
      B(0x4048100200090090, 0x2008090100000900),
      B(0x24200000280210, 0xD440050008004000),
      B(0x1280001000580020, 0x2200040089000A4),
      B(0x10208018C1020A20, 0x84C0432240610014),
      B(0x10208018C1020A20, 0x84C0432240610014),
      B(0x4108000010209089, 0x913000000024840),
      B(0x410C208008008E02, 0xE8000000000001),
      B(0x802208004005, 0x94206000022080),
      B(0xC00290018902002, 0x4204100000000000),
      B(0x2102801400093816, 0x9810004001000202),
      B(0x8008304000015800, 0x4A5C000000020000),
      B(0x1020108380800514, 0x1144210000000080),
      B(0xC0001000008090, 0x2812060000204000),
      B(0x1001100200003100, 0x246240060A004004),
      B(0xA00020A008002030, 0x2440C40000110B00),
      B(0x80502104000C008, 0x8222200042100010),
      B(0xC020200088014, 0x422094000000480),
      B(0x1029002000001030, 0x8105841120000210),
      B(0x49040D, 0x2310808A14042C0),
      B(0x200040200080A02C, 0xB890290400080000),
      B(0x2240180C0800002, 0x4151050280000100),
      B(0x2240180C0800002, 0x4151050280000100),
      B(0x8220224180420006, 0x4024501212011000),
      B(0x1806810A0881000, 0x802002048400080),
      B(0x400400A080842, 0x9305000401180000),
      B(0x10008001444110, 0x4420401040041833),
      B(0x2000002C02010E00, 0x400408D08009804),
      B(0x69D008200020100, 0x100842240049021),
      B(0x42C24450020000, 0xD38400880090884),
      B(0x485800800100001, 0x2484086522018840),
      B(0x900200020820042, 0x22302421400040C0),
      B(0x50B0413001818000, 0x452014040800C40),
      B(0x8004040021008, 0x20088A08000290),
      B(0x600C000801000004, 0x8015084010200020),
      B(0x208000C00, 0xE004804021100100),
      B(0x20001000040204, 0x948110C0B2081),
      B(0x268502400100021, 0x80A201840802080),
      B(0x408C000008, 0x8822102408014),
      B(0x1182080410100000, 0x608002046A0100),
      B(0x100820A083C00002, 0x3100100410A00),
      B(0x8401040000400124, 0x2000081288202200),
      B(0xB014040003000800, 0x11960D1101210),
      B(0x10040001900C000, 0x85603C1001280),
      B(0x2000844000000100, 0x2000024C60800800),
      B(0x120004234800900, 0x210010841040),
      B(0x8010300040000002, 0x4200008222104100),
      B(0x1000120402200100, 0x209080CC040108B4),
      B(0x110049A00000800, 0x80000420022180A8),
      B(0x80001C00080384, 0x1400101111081001),
      B(0x8011200008100428, 0x2020000880800922),
      B(0x10001000000204C8, 0x280C11104240),
      B(0x50100C82C000500, 0x28000280618DD1),
      B(0x8800498020000, 0x20500A0200320128),
      B(0x20010104000860, 0x8021720186008),
      B(0x4000000000100080, 0x35040084270C04),
      B(0x4500080000800, 0x280100002482C842),
      B(0x10400000000000, 0x20080051100130C2),
      B(0x10400000000000, 0x20080051100130C2),
      B(0x2000002110202014, 0x121004004004681),
      B(0x400202001006D40, 0x82240082202424),
      B(0x4500080000800, 0x280100002482C842),
      B(0xC6000000D00804, 0x1050020C0081090C),
      B(0x200080000000042, 0x10800661),
      B(0x2000001011200200, 0x2A420000802A0222),
      B(0x802020001202412, 0x2400404148426),
      B(0x8000440801040002, 0x444002800010052A),
  };
  Bitboard ElephantMagicInit[SQUARE_NB] = {
      B(0x64D2990200008, 0x4401880001C000),
      B(0x29BAA00010020, 0x200000400800600),
      B(0x3024240000000, 0x4100400010080),
      B(0xA490A00480020, 0x20084001041010A4),
      B(0x328C021008042, 0x100000000C10204),
      B(0x1964090001018, 0x7002040148001205),
      B(0x800302098404080, 0x4983020000000001),
      B(0x8812244630A02080, 0x8200006204003C08),
      B(0x41120231008000, 0x240441401020),
      B(0x840091030C00040, 0x1400008200023400),
      B(0x8001040E77030200, 0x100040090022000),
      B(0x602022139D835040, 0x101002010025900),
      B(0x405707C48400, 0x40010000008001),
      B(0x982003456A82050, 0x60800820040030),
      B(0x204184849200088, 0x101800004006),
      B(0x300222470949200, 0x2A0800200200800),
      B(0x400001211914000, 0x8200001407001),
      B(0x2000008614831020, 0x4000020001404000),
      B(0x84000024A2048048, 0x1200102000042),
      B(0x424010A58422008, 0x88440242212A0110),
      B(0x20020812C0C4408, 0x4121400000080010),
      B(0x680200062042420, 0x2001100000800000),
      B(0x200010060AEC855, 0x8083002040200000),
      B(0x4000008BAA85810, 0x82000805C0200A90),
      B(0x81450B200A025400, 0x4400101050000040),
      B(0x820A2241409010, 0x888420030000),
      B(0x909203000028, 0xC000004C00200041),
      B(0x8021400A84880240, 0x100180002010020),
      B(0x8001A20061410000, 0x14008499A000000),
      B(0x8201444800A00080, 0x402010040588120),
      B(0x100C06280020, 0x60010104840130),
      B(0x520040800080044, 0x8220000080001402),
      B(0x102021410040202, 0x2004400410006000),
      B(0x5401832090020400, 0x300010020001),
      B(0x180003105A84C108, 0x1012008800081000),
      B(0x480C10210026904, 0xA006000004200418),
      B(0x48050820210843A6, 0x108001004000C00),
      B(0x1030101182206324, 0x4401008921502002),
      B(0x40281060800800, 0x406000201260022),
      B(0xC29002440040C820, 0x400001002008020),
      B(0x40000400800241, 0xC220000000400280),
      B(0x40880126014208, 0x2A8004C008940000),
      B(0x121028100114080, 0x5010280481100082),
      B(0x4000088280442, 0x908420140008041),
      B(0x808C42400C0020, 0x3028100840801000),
      B(0x4000000410078488, 0x501000000620000),
      B(0x90080001421020A4, 0x4118400101060406),
      B(0x280420004855, 0xD200100400820000),
      B(0xA0063423444, 0x41002C15811008),
      B(0x200061201808102, 0x4286969000200002),
      B(0x10208018C1020A20, 0x84C0432240610014),
      B(0x4001A04880402000, 0x8100824080000001),
      B(0x60201D8300408190, 0x2010020920200000),
      B(0x20018C04908019, 0x2010884002002040),
      B(0x800000000C40810, 0x680100081150000D),
      B(0x2002002000040040, 0x8810049000010600),
      B(0x41618A0300040040, 0x21200200A421801),
      B(0x10208018C1020A20, 0x84C0432240610014),
      B(0x10208018C1020A20, 0x84C0432240610014),
      B(0x5A04001400412854, 0x8A44006000010002),
      B(0x13000C0810072432, 0x50049001021104),
      B(0x400048801142130, 0x4C1204100226010C),
      B(0x80001048, 0x408800104000080),
      B(0x8104868204040412, 0x22244202000081),
      B(0x8104868204040412, 0x22244202000081),
      B(0x4140001000240440, 0x80209004410004E),
      B(0x800800000100, 0xB111820100000002),
      B(0x404240004220, 0x2110402802050080),
      B(0x284010400004040, 0x100245002502020),
      B(0x14880A100114010, 0x400208080010024),
      B(0x4100004040440648, 0x10030D838041A80),
      B(0x32004000210, 0x4010225C88014000),
      B(0x2240180C0800002, 0x4151050280000100),
      B(0x2010A12002000042, 0x189051442010000),
      B(0x4060050080121883, 0x8250C10001000141),
      B(0x10000000044100, 0x8401084010261009),
      B(0xA00028040000, 0x2003224000002000),
      B(0x2060009001000020, 0x1000432022020228),
      B(0x404200000883080, 0x1080800848245000),
      B(0x240000402080, 0xCA0820814210502),
      B(0x200040200080A02C, 0xB890290400080000),
      B(0x800000000300482, 0x9203008100100013),
      B(0x8000210202042000, 0x22642104004C2400),
      B(0x1040400805000401, 0x2A0300102C80010),
      B(0x8010A01088020000, 0x122106105A06A030),
      B(0x8000C00001010494, 0x130A1A20404120),
      B(0x4B084010844290, 0x10A08008900840),
      B(0x1180001802460000, 0xB08000034C82004),
      B(0x4001880060028029, 0x204040002401000),
      B(0x8021A0001308002A, 0x97001822040040),
      B(0xC00000009A020AC1, 0x1000080900400),
      B(0x60010110001990, 0x4000880900400000),
      B(0x10290402401200, 0x230080402C08),
      B(0x4220000219012000, 0x140204804100008),
      B(0x1400200100002, 0x8E62200414128),
      B(0x402808502004403, 0x20049100C0284520),
      B(0xB30041004280280, 0x10020464DB200308),
      B(0x440010800808, 0xA0102E295812100),
      B(0x10008000B000, 0x2000058583220200),
      B(0x2000844000000100, 0x2000024C60800800),
      B(0x110000400100028, 0x24052304508004),
      B(0x8458000000840004, 0x118006463400001),
      B(0x804008000040050, 0x41044890228000),
      B(0x20000050000400, 0x80A101824A00086),
      B(0x600080404000020, 0x100007322480005),
      B(0xD082200020020008, 0x642000630120001),
      B(0x10000100040230, 0x8048114733320002),
      B(0x20200442002A880A, 0x8200002CB4B8052),
      B(0x290080000000, 0xA41297838F40D),
      B(0x800205000080, 0xF221232039874400),
      B(0x1444002004880C20, 0xC4100049144200),
      B(0x4500080000800, 0x280100002482C842),
      B(0x281240881008, 0x204084004C101900),
      B(0x1444002004880C20, 0xC4100049144200),
      B(0x4500080000800, 0x280100002482C842),
      B(0xC0010928430540, 0x92041902180),
      B(0x1051001208A, 0x4900064800C20640),
      B(0x882020418C00000, 0x30004040092A821),
      B(0x224404002004268C, 0x202500204C7D254),
      B(0x290080000000, 0xA41297838F40D),
  };
  Bitboard JanggiElephantMagicInit[SQUARE_NB] = {
      B(0xC502282200061400, 0x2D07081241D90200),
      B(0xC502282200061400, 0x2D07081241D90200),
      B(0x8084810022440C2, 0x81402202004),
      B(0x80204010A800500, 0x5000021001740218),
      B(0x8048100401208000, 0x2001000390000044),
      B(0x202080020000000, 0x4010800010090424),
      B(0x4081A0480073200, 0x100000A010406000),
      B(0x4081A0480073200, 0x100000A010406000),
      B(0x2040450004000C40, 0x8400000006302),
      B(0x84010410018201, 0xA00A00000100000),
      B(0x840091030C00040, 0x1400008200023400),
      B(0x801058C0A0022, 0xC1920480010034),
      B(0x80B4004800840800, 0x4080210A42040010),
      B(0x400402221000445, 0x80321200408040),
      B(0x4028142401012A00, 0x4005009000104448),
      B(0x1440102040800220, 0x82800010A082000),
      B(0x4100040300C00200, 0x800805100120000),
      B(0x8200080061100, 0x2000101400000),
      B(0x2000100410070001, 0x40818200B0900410),
      B(0x400088020080000, 0x4A000402000CA0),
      B(0x1402040410004000, 0x9840044504040),
      B(0x20800088A00A0400, 0x1000020100180),
      B(0x2001820520308201, 0x2008003404349000),
      B(0x4004808022100, 0x8001000008081080),
      B(0x102041041100425, 0x840400180B100104),
      B(0x8806446000800214, 0x404402100010000),
      B(0x8200141409C04101, 0x209030004A00D00),
      B(0x8806004800880080, 0x1560004201000A01),
      B(0x4200050600200090, 0x1CD0000000000421),
      B(0x4820100022408100, 0x101404080320),
      B(0x2A000A0A08080080, 0x1C02808000C2C0),
      B(0x8808425040040014, 0x2021000100020),
      B(0x5282104044A0020, 0x6B402104200008),
      B(0x4001091040068120, 0x202000004003031),
      B(0x4001091040068120, 0x202000004003031),
      B(0x98040200A0214344, 0xA00300840010),
      B(0x82508040A40808A, 0x40010000110042),
      B(0x4400100101023, 0x450C8480040022),
      B(0x210588880010800, 0x800A000108018102),
      B(0x9400010144400, 0xC00010100018000),
      B(0x20A0400100040004, 0x1242000101002040),
      B(0x8022900040001001, 0x100000014000260),
      B(0x51004124000A080, 0x40098400000002),
      B(0x2158040001080022, 0x80009238401222),
      B(0xA0103A0000802220, 0x20000200400010),
      B(0x1101001208240, 0x100000800001064),
      B(0x821020002090081, 0x5840D0010290280),
      B(0x821020002090081, 0x5840D0010290280),
      B(0x10400C1042000400, 0x4005000000440200),
      B(0x844022008804820, 0x1000800100118000),
      B(0x10802A9800800139, 0x4802840100842200),
      B(0x4000A008200081, 0x4001100200402000),
      B(0x200000008108400, 0x1000C00008080020),
      B(0x120C11500100081, 0x440300308041100),
      B(0x8080040080060100, 0xC00101B0040028),
      B(0x901420A00110000, 0x8200010044700280),
      B(0x140080080410000, 0x808040000C001001),
      B(0x80210C0200A0008, 0x88088004600201),
      B(0x8000004202020301, 0x2100142104002000),
      B(0x1101011210004880, 0x8500840400000000),
      B(0x40208802004800, 0x8080806009011240),
      B(0x800000140408880, 0xC001018004060040),
      B(0xC008080420500, 0x8024A10000000000),
      B(0x2800000000400010, 0x44001C00400408),
      B(0xA804008001200408, 0x202000020001000),
      B(0xC08288805004080, 0x200042000800004),
      B(0xA40A01000080012, 0x8800080042408),
      B(0x2200100000100810, 0x800200010000100),
      B(0x9881800004040001, 0x8058100100884004),
      B(0x820000044020014, 0x4AA00010245012),
      B(0x820000044020014, 0x4AA00010245012),
      B(0x4000080240000808, 0x10100022054000),
      B(0x5002000840101, 0x202020004000A00),
      B(0x1188008200008402, 0x8088100020A2204),
      B(0x304012004044080, 0x8028108818006010),
      B(0x102210000008400, 0x1008000200380002),
      B(0x51410E114200, 0x100C00084000000),
      B(0x5001242320218, 0x800025000040040),
      B(0x4008000200008190, 0x400020021000000),
      B(0x10910022F0040, 0x450084400040001),
      B(0x180010810000040, 0x4004100040040),
      B(0x1088801424062010, 0x400084010030401),
      B(0x3000120408000040, 0x10802001080A4051),
      B(0x200008420, 0x40C0100020008804),
      B(0x1048C000004000, 0x4220120804004000),
      B(0x404A180000000E, 0x4C30412008110102),
      B(0x400000404202005, 0x800808550EC40044),
      B(0x282000200212010, 0x8001C0C102000210),
      B(0x9012240000008100, 0x280CA04010040000),
      B(0x2000C04001020C00, 0x2002010101042000),
      B(0x1010000204408408, 0x8008004800E0C4A),
      B(0x800286801000025, 0x8402401040050088),
      B(0x40002000A0880000, 0x8400300108082086),
      B(0x2080004404011, 0x20C080400100001),
      B(0xB0010218100800, 0x8040200482C14103),
      B(0x8011035000000C20, 0x4200044043200040),
      B(0x804008000040050, 0x41044890228000),
      B(0x80000400A0020020, 0x5308022021000000),
      B(0x2118200000008004, 0x4141014004423D00),
      B(0x90C0000200008040, 0x41041062000082),
      B(0x1D000100941204, 0x12402001200420),
      B(0x8C0040400400065, 0x22300B408100000),
      B(0x8C0040400400065, 0x22300B408100000),
      B(0x802802044600000, 0x1210100401030082),
      B(0x9400488010000000, 0x8005404902040000),
      B(0x2214020200001, 0x40102100820200),
      B(0x2022000000800000, 0x6400440108480),
      B(0x110000400100028, 0x24052304508004),
      B(0x848820140010000, 0x201012500A000),
      B(0x848820140010000, 0x201012500A000),
      B(0x100100000000C4, 0x208004084048201),
      B(0x100500000000290, 0x10102818208000),
      B(0x2800414000C000, 0x20004005001301),
      B(0x698180005101241, 0x10002014800210),
      B(0x20000080000009, 0x440340C040),
      B(0x1C0220200290020, 0x42100004004011C0),
      B(0x200E620018320208, 0x440410402),
      B(0xD04101010004024, 0x20000121104010A4),
      B(0x220400000A80040, 0x806080020810010C),
      B(0xA000200000000080, 0x1040801A0081208),
  };
#undef B
#endif

#endif // #ifndef MAGIC_H_INCLUDED