/*
 * Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

.text

/* Main function of the elevator control.
 * This function will be called whenever an input port changes.
 */
.globl elevator_control_main
elevator_control_main:
	call elevator_set_direction
	cmpb $0, elevator_door_phase
	jne _elevator_button_functions
	call elevator_move
	call elevator_set_floor
_elevator_button_functions:
	call elevator_update_floor_led
	call elevator_update_button_lights
	ret

/* This callback function should close the door again.
 * It should get called via time_call_after, after the 
 * door was opened and 5 seconds have passed.
 */
elevator_door_timer_done:
	ret
	

/* This function should update the 8 Segment LED with the current 
 * position that the elevator is in (found in elevator_floor 
 * variable)
 */
.globl elevator_update_floor_led
elevator_update_floor_led:
	ret

/* This function should check, if the elevator has reached a
 * floor and should update the elevator_floor variable
 * accordingly.
 * You can use the "cabin position sensor floor X" to check if the
 * elevator is at a floor position.
 */
.globl elevator_set_floor
elevator_set_floor:
	ret

/* This function should update the button lights after one button 
 * was pressed.
 */
elevator_update_button_lights:
	ret

/* calculate the destination bitmask and return it in variable %al. 
 * The destination bitmask should have the following content: 
 * Bit pos.:  87654321.
 * Content:   0000021E
 * 0: set to 0.
 * 2: bit set, if either second floor call button or 2nd floor destination
 *    button was pressed.
 * 1: bit set, if either first floor downwards call button, or first floor
 *    upwards call button, or first floor destination button was pressed.
 * E: bit set, if either ground floor call button, or ground floor destination
 *    button was pressed.
 */
.globl elevator_destination_bitmask
elevator_destination_bitmask:
	ret

/* This function should set the direction indicators lights based on
 * the requested destination. In case the elevator could move
 * both upwards and downwards, the direction the elevator has
 * at the moment should be kept.
 * Also, the variable elevator_direction should be set to a value
 * indicating the direction, which you can use later on again. 
 * Choose sane values for this.
 */
elevator_set_direction:
	ret


/* This function should turn on the motor if 
 * - the doors are closed and
 * - the elevator can move to a target.
 * It should also set the direction flag of the elevator.
 * As a safety mechanism, it should force the motor off,
 * in case any door is open.
 */
elevator_move:
	ret

/* This function should turn off the destination button 
 * lights.
 */
elevator_turnoff_destination_lights:
	ret

/* This function should turn off the call lights. */
elevator_turnoff_call_lights:
	ret

/* This function should stop the elevator, if it has reached a 
 * destination level and should open the door.
 * It should also turn off the corresponding
 * lights on the buttons, both inside and outside the elevator.
 * Finally, it should set up a callback handler that is called after 5
 * seconds which will close the door again. Use time_call_after to do
 * this (edx: pointer to callback, eax number of seconds after which the
 * callback is called).
 */
elevator_open_door:
	ret

.data
/* floor, the elevator is currently in.
 * 0=Ground floor, 1=1st floor, 2=2nd floor */
.globl elevator_floor
elevator_floor:
	.byte 0

/* direction of elevator. Define contents to your own liking.
 */
elevator_direction:
	.byte 0

/* 0: door closed, elevator can move
 * 1: door opening, waiting 5 seconds
 */
elevator_door_phase:
	.byte 0
