/*
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __IO_H_INCLUDED
#define __IO_H_INCLUDED

#define outb_p	outb
#define outw_p	outw
#define outl_p	outl
#define inb_p	inb
#define inw_p	inw
#define inl_p	inl

static inline __attribute__((__always_inline__)) void
outb(unsigned char val, unsigned short port)
{
	__asm__ __volatile__ (
		"outb %0, %1\n"
		: /* no output */
		: "a" (val), "d" (port)
	);
}

static inline __attribute__((__always_inline__)) void
outw(unsigned short val, unsigned short port)
{
	__asm__ __volatile__ (
		"outw %0, %1\n"
		: /* no output */
		: "a" (val), "d" (port)
	);
}

static inline __attribute__((__always_inline__)) void
outl(unsigned long val, unsigned short port)
{
	__asm__ __volatile__ (
		"outl %0, %1\n"
		: /* no output */
		: "a" (val), "d" (port)
	);
}

static inline __attribute__((__always_inline__)) unsigned char
inb(unsigned short port)
{
	unsigned char val;

	__asm__ __volatile__ (
		"inb %1\n"
		: "=a" (val)
		: "d" (port)
	);

	return val;
}

static inline __attribute__((__always_inline__)) unsigned short
inw(unsigned short port)
{
	unsigned short val;

	__asm__ __volatile__ (
		"inw %1\n"
		: "=a" (val)
		: "d" (port)
	);

	return val;
}

static inline __attribute__((__always_inline__)) unsigned long
inl(unsigned short port)
{
	unsigned long val;

	__asm__ __volatile__ (
		"inl %1\n"
		: "=a" (val)
		: "d" (port)
	);

	return val;
}

static inline __attribute__((__always_inline__)) void
eoi(void)
{
	unsigned char al;

	__asm__ __volatile__ (
		"movb $0x20, %0\n"
		"outb %0, $0x20\n"
		"outb %0, $0xa0\n"
		: "=a" (al)
		: /* No input */
	);
}

#if 0
static inline __attribute__((__always_inline__)) void
outsb(unsigned short port, void *addr, unsigned long count)
{
	__asm__ __volatile__ (
		"rep; outsb\n"
		: "=S" (addr), "=c" (count)
		: "d" (port), "0" (addr), "1" (count)
		: "memory"
	);
}

static inline __attribute__((__always_inline__)) void
outsw(unsigned short port, void *addr, unsigned long count)
{
	__asm__ __volatile__ (
		"rep; outsw\n"
		: "=S" (addr), "=c" (count)
		: "d" (port), "0" (addr), "1" (count)
		: "memory"
	);
}

static inline __attribute__((__always_inline__)) void
outsl(unsigned short port, void *addr, unsigned long count)
{
	__asm__ __volatile__ (
		"rep; outsl\n"
		: "=S" (addr), "=c" (count)
		: "d" (port), "0" (addr), "1" (count)
		: "memory"
	);
}
static inline __attribute__((__always_inline__)) void
insb(unsigned short port, void *addr, unsigned long count)
{
	__asm__ __volatile__ (
		"rep; insb\n"
		: "=D" (addr), "=c" (count)
		: "d" (port), "0" (addr), "1" (count)
		: "memory"
	);
}

static inline __attribute__((__always_inline__)) void
insw(unsigned short port, void *addr, unsigned long count)
{
	__asm__ __volatile__ (
		"rep; insw\n"
		: "=D" (addr), "=c" (count)
		: "d" (port), "0" (addr), "1" (count)
		: "memory"
	);
}

static inline __attribute__((__always_inline__)) void
insl(unsigned short port, void *addr, unsigned long count)
{
	__asm__ __volatile__ (
		"rep; insl\n"
		: "=D" (addr), "=c" (count)
		: "d" (port), "0" (addr), "1" (count)
		: "memory"
	);
}
#endif

#endif /* __IO_H_INCLUDED */	
