/*
 * Copyright (C) 2003-2013 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>

#include "glue-gui.h"

#include "pci_ti_1520_gui.h"
#ifdef HAVE_GTK
#include "pci_ti_1520_gui_gtk.h"
#endif

void *
pci_ti_1520_gui_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_cardbus_conn *port_card0,
	struct sig_cardbus_conn *port_card1,
	struct sig_pci_conn *port_pci,
	struct sig_string *port_change0,
	struct sig_string *port_change1
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return pci_ti_1520_gui_gtk_create(page, name, port_manage,
				port_card0, port_card1, port_pci,
				port_change0, port_change1);
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
pci_ti_1520_gui_destroy(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return pci_ti_1520_gui_gtk_destroy(_cpssp);
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
pci_ti_1520_gui_suspend(void *_cpssp, FILE *fComp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return pci_ti_1520_gui_gtk_resume(_cpssp, fComp);
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
pci_ti_1520_gui_resume(void *_cpssp, FILE *fComp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return pci_ti_1520_gui_gtk_resume(_cpssp, fComp);
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
