/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef __FERITE_OPS__
#define __FERITE_OPS__

#define FERITE_BINARY_OP( opname ) FeriteVariable *__ferite_op_##opname (FeriteScript *script, FeriteVariable *a, FeriteVariable *b)
#define FERITE_UNARY_OP( opname ) FeriteVariable *__ferite_op_##opname (FeriteScript *script, FeriteVariable *a)
#define FERITE_OP_CALL( opname ) (void *)__ferite_op_##opname

FeriteVariable *__ferite_new_object( FeriteScript *script, FeriteClass *nclass, FeriteVariable **plist );

FERITE_UNARY_OP( not_op );
FERITE_UNARY_OP( left_incr );
FERITE_UNARY_OP( right_incr );
FERITE_UNARY_OP( left_decr );
FERITE_UNARY_OP( right_decr );
FERITE_UNARY_OP( positive_var );
FERITE_UNARY_OP( negative_var );
FERITE_UNARY_OP( eval );
FERITE_UNARY_OP( include );

FERITE_BINARY_OP( add );
FERITE_BINARY_OP( minus );
FERITE_BINARY_OP( mult );
FERITE_BINARY_OP( divide );
FERITE_BINARY_OP( modulus );
FERITE_BINARY_OP( assign );
FERITE_BINARY_OP( add_assign );
FERITE_BINARY_OP( minus_assign );
FERITE_BINARY_OP( mult_assign );
FERITE_BINARY_OP( divide_assign );
FERITE_BINARY_OP( binary_or );
FERITE_BINARY_OP( binary_and );
FERITE_BINARY_OP( binary_xor );
FERITE_BINARY_OP( logical_or );
FERITE_BINARY_OP( logical_and );

FERITE_BINARY_OP( equals );
FERITE_BINARY_OP( case );
FERITE_BINARY_OP( notequals );
FERITE_BINARY_OP( less_than );
FERITE_BINARY_OP( less_than_equals );
FERITE_BINARY_OP( greater_than );
FERITE_BINARY_OP( greater_than_equals );

FERITE_BINARY_OP( array_index );

FERITE_BINARY_OP( left_shift );
FERITE_BINARY_OP( right_shift );
FERITE_BINARY_OP( left_shift_assign );
FERITE_BINARY_OP( right_shift_assign );
FERITE_BINARY_OP( binary_and_assign );
FERITE_BINARY_OP( binary_or_assign );
FERITE_BINARY_OP( binary_xor_assign );

#endif /* __FERITE_OPS__ */
