#!/bin/sh

moduledir="modules"

case "$1" in

  bootstrap)
    # generate the subdirs stuff for configure.in
    echo "Generating module list...";
    echo "echo \"\"" > config.m4
    echo "echo \"Configuring ferite modules...\"" >> config.m4
	echo "echo \"\"" >> config.m4
	echo "modules=\"\"" >> config.m4
	modulemakefiles=""
    for dir in *; do
      if test -d "$dir"; then
        cd $dir;
        if test -f "config.m4"; then
		   echo "echo \"checking module $dir ...\"" >> ../config.m4
		   echo "sinclude($moduledir/$dir/config.m4)" >> ../config.m4
	       modulemakefiles="$modulemakefiles$moduledir\/$dir\/Makefile \\\\\\
 "
        fi
		if test -f "Makefile.am"; then
		   if test ! -f "$dir.fec"; then
		      modulelist="$modulelist $dir";
		   fi
#           modulelist="$modulelist $dir";
		fi
        cd ..
      fi
    done
	echo "AC_SUBST(modules)" >> config.m4
	echo "echo \"\"" >> config.m4
	echo "MODULE_MAKEFILES=\"$modulemakefiles\"" >> config.m4
    cat Makefile.am.stub | sed -e "s/%modules%/$modulelist/" > Makefile.am
	cat ../configure.ac.stub | sed -e "s/%modules%/$modulemakefiles/g" > ../configure.ac
	cat ../old.configure.in.stub | sed -e "s/%modules%/$modulemakefiles/g" > ../old.configure.in
    ;;
  rebuild)
    # go through all the directories, generate the c code for them, and then
    # generate the makefiles, now we have to do this because configure wont...
    echo ""
    echo "------- GENERATING MAKEFILES (this might take some time) -------"
    echo ""
    for dir in *; do
      if test -d "$dir"; then
         cd $dir;
	     make maintainer-clean
         if test -f "$dir.fec"; then
		    ../../builder/builder -k -m $dir `echo \`for file in *.[ch]; do echo "-a $file "; done\` | egrep -v "^-a $dir" | sed -e "s/-a \*\.\[ch\]//"` $dir.fec > /dev/null
		 fi
         cd ..
      fi
    done
    echo ""
  	echo "----------------------------------------------------------------"
    echo ""
    ;;
  build)
    dir=$2
	if test -d "$dir"; then
	  cd $dir;
	  make clean
	  if test -f "$dir.fec"; then
	      ../../builder/builder -k -m $dir `echo \`for file in *.[ch]; do echo "-a $file "; done\` | egrep -v "^-a $dir" | sed -e "s/-a \*\.\[ch\]//"` $dir.fec > /dev/null
	  fi
      cd ..
    fi
    ;;    
  *)
    echo "Usage: build_modules (bootstrap|rebuild)";
    exit 1
    ;;
    
esac

exit 0  
