/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.Codec;

public class RPZACodec
extends BaseCodec
implements Codec {
    public byte[] compress(byte[] input, int x, int y, int[] dims, Object options) throws FormatException {
        throw new FormatException("RPZA compression not supported.");
    }

    public byte[] decompress(byte[] data, Object options) throws FormatException {
        if (options == null || !(options instanceof int[])) {
            return null;
        }
        int[] o = (int[])options;
        int x = o[0];
        int y = o[1];
        int stride = x;
        int rowInc = stride - 4;
        int streamPtr = 8;
        int colorA = 0;
        int[] color4 = new int[4];
        int rowPtr = 0;
        int pixelPtr = 0;
        int blockPtr = 0;
        int[] pixels = new int[x * y];
        byte[] rtn = new byte[x * y * 3];
        while (data[streamPtr] != -31) {
            ++streamPtr;
        }
        streamPtr += 4;
        int totalBlocks = (x + 3) / 4 * ((y + 3) / 4);
        while (streamPtr < data.length) {
            int opcode = data[streamPtr++];
            int nBlocks = (opcode & 0x1F) + 1;
            if ((opcode & 0x80) == 0) {
                if (streamPtr >= data.length) break;
                colorA = opcode << 8 | data[streamPtr++];
                opcode = 0;
                if (streamPtr >= data.length) break;
                if ((data[streamPtr] & 0x80) != 0) {
                    opcode = 32;
                    nBlocks = 1;
                }
            }
            switch (opcode & 0xE0) {
                case 128: {
                    while (nBlocks-- > 0) {
                        if ((pixelPtr += 4) >= x) {
                            pixelPtr = 0;
                            rowPtr += stride * 4;
                        }
                        --totalBlocks;
                    }
                    break;
                }
                case 160: {
                    short s;
                    int pixelX;
                    int pixelY;
                    colorA = DataTools.bytesToInt(data, streamPtr, 2, false);
                    streamPtr += 2;
                    while (nBlocks-- > 0) {
                        blockPtr = rowPtr + pixelPtr;
                        for (pixelY = 0; pixelY < 4; ++pixelY) {
                            for (pixelX = 0; pixelX < 4 && blockPtr < pixels.length; ++blockPtr, ++pixelX) {
                                pixels[blockPtr] = colorA;
                                s = (short)(pixels[blockPtr] & Short.MAX_VALUE);
                                this.unpack(s, rtn, blockPtr, pixels.length);
                            }
                            blockPtr += rowInc;
                        }
                        if ((pixelPtr += 4) >= x) {
                            pixelPtr = 0;
                            rowPtr += stride * 4;
                        }
                        --totalBlocks;
                    }
                    break;
                }
                case 32: 
                case 192: {
                    short s;
                    int pixelX;
                    int pixelY;
                    if ((opcode & 0xE0) == 192) {
                        colorA = DataTools.bytesToInt(data, streamPtr, 2, false);
                        streamPtr += 2;
                    }
                    int colorB = DataTools.bytesToInt(data, streamPtr, 2, false);
                    streamPtr += 2;
                    color4[0] = colorB;
                    color4[1] = 0;
                    color4[2] = 0;
                    color4[3] = colorA;
                    int ta = colorA >> 10 & 0x1F;
                    int tb = colorB >> 10 & 0x1F;
                    color4[1] = color4[1] | 11 * ta + 21 * tb >> 5 << 10;
                    color4[2] = color4[2] | 21 * ta + 11 * tb >> 5 << 10;
                    ta = colorA >> 5 & 0x1F;
                    tb = colorB >> 5 & 0x1F;
                    color4[1] = color4[1] | 11 * ta + 21 * tb >> 5 << 5;
                    color4[2] = color4[2] | 21 * ta + 11 * tb >> 5 << 5;
                    ta = colorA & 0x1F;
                    tb = colorB & 0x1F;
                    color4[1] = color4[1] | 11 * ta + 21 * tb >> 5;
                    color4[2] = color4[2] | 21 * ta + 11 * tb >> 5;
                    while (nBlocks-- > 0) {
                        blockPtr = rowPtr + pixelPtr;
                        for (pixelY = 0; pixelY < 4 && streamPtr < data.length; ++pixelY) {
                            byte index = data[streamPtr++];
                            for (pixelX = 0; pixelX < 4; ++pixelX) {
                                int idx = index >> 2 * (3 - pixelX) & 3;
                                if (blockPtr >= pixels.length) break;
                                pixels[blockPtr] = color4[idx];
                                s = (short)(pixels[blockPtr] & Short.MAX_VALUE);
                                this.unpack(s, rtn, blockPtr, pixels.length);
                                ++blockPtr;
                            }
                            blockPtr += rowInc;
                        }
                        if ((pixelPtr += 4) >= x) {
                            pixelPtr = 0;
                            rowPtr += stride * 4;
                        }
                        --totalBlocks;
                    }
                    break;
                }
                case 0: {
                    short s;
                    int pixelX;
                    int pixelY;
                    blockPtr = rowPtr + pixelPtr;
                    for (pixelY = 0; pixelY < 4; ++pixelY) {
                        for (pixelX = 0; pixelX < 4; ++pixelX) {
                            if (pixelY != 0 || pixelX != 0) {
                                colorA = DataTools.bytesToInt(data, streamPtr, 2, false);
                                streamPtr += 2;
                            }
                            if (blockPtr >= pixels.length) break;
                            pixels[blockPtr] = colorA;
                            s = (short)(pixels[blockPtr] & Short.MAX_VALUE);
                            this.unpack(s, rtn, blockPtr, pixels.length);
                            ++blockPtr;
                        }
                        blockPtr += rowInc;
                    }
                    if ((pixelPtr += 4) >= x) {
                        pixelPtr = 0;
                        rowPtr += stride * 4;
                    }
                    --totalBlocks;
                }
            }
        }
        return rtn;
    }

    private void unpack(short s, byte[] array, int offset, int len) {
        array[offset] = (byte)(255 - ((s & 0x7C00) >> 10));
        array[offset + len] = (byte)(255 - ((s & 0x3E0) >> 5));
        array[offset + 2 * len] = (byte)(255 - (s & 0x1F));
    }
}

