	INTEGER FUNCTION GCF_ARG_EVAL_ORDER( ifcn, item )

*
*
*  This software was developed by the Thermal Modeling and Analysis
*  Project(TMAP) of the National Oceanographic and Atmospheric
*  Administration's (NOAA) Pacific Marine Environmental Lab(PMEL),
*  hereafter referred to as NOAA/PMEL/TMAP.
*
*  Access and use of this software shall impose the following
*  obligations and understandings on the user. The user is granted the
*  right, without any fee or cost, to use, copy, modify, alter, enhance
*  and distribute this software, and any derivative works thereof, and
*  its supporting documentation for any purpose whatsoever, provided
*  that this entire notice appears in all copies of the software,
*  derivative works and supporting documentation.  Further, the user
*  agrees to credit NOAA/PMEL/TMAP in any publications that result from
*  the use of this software or in any product that includes this
*  software. The names TMAP, NOAA and/or PMEL, however, may not be used
*  in any advertising or publicity to endorse or promote any products
*  or commercial entity unless specific written permission is obtained
*  from NOAA/PMEL/TMAP. The user also understands that NOAA/PMEL/TMAP
*  is not obligated to provide the user with any support, consulting,
*  training or assistance of any kind with regard to the use, operation
*  and performance of this software nor to provide the user with any
*  updates, revisions, new versions or "bug fixes".
*
*  THIS SOFTWARE IS PROVIDED BY NOAA/PMEL/TMAP "AS IS" AND ANY EXPRESS
*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL NOAA/PMEL/TMAP BE LIABLE FOR ANY SPECIAL,
*  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
*  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
*  CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
*  CONNECTION WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE. 
*
*
* Some grid changing functions require that arguments are evaluated in
* an order other than the one in which they appear in the function call.
* For example, SAMPLEI(field, indices) requires that the "indices" argument
* be evaluated first, and then used to guide the process of obtaing "field"
* In this function we supply the re-ordered sequence for evaluation

* programmer - steve hankin
* NOAA/PMEL, Seattle, WA - Tropical Modeling and Analysis Program
*
* V510: 9/99 *sh*

        IMPLICIT NONE
	include 'ferret.parm'
	include 'errmsg.parm'
	include 'grid_chg_fcns.parm'

* calling argument declarations
	INTEGER	ifcn, item

* internal variable declarations
	INTEGER next

* default result
	next = item

	IF ( ifcn .GE. p_samplei
     . .AND. ifcn .LE. p_samplen ) THEN		! SAMPLE*
	   IF (item .EQ. 1) THEN
	      next = 2			! get index list first
	   ELSEIF (item .EQ. 2) THEN
	      next = 1
	   ENDIF
	ENDIF  

	GCF_ARG_EVAL_ORDER = next
	RETURN

	END
