"""Unit tests for FFC. This test compares values computed by the two UFC
functions evaluate_basisi and evaluate_basis_derivatives generated by FFC to the
values tabulated by FIAT and to reference values computed by an older version of FFC."""

__author__ = "Kristian B. Oelgaard (k.b.oelgaard@gmail.com)"
__date__ = "2010-02-01"
__copyright__ = "Copyright (C) 2010 Kristian B. Oelgaard"
__license__  = "GNU GPL version 3 or any later version"

import unittest
from test_against_fiat import main as fiat_main
from ffc.log import CRITICAL, INFO

class EvaluateBasisTests(unittest.TestCase):

    def testAgainsFiat(self):
        "Test evaluate basis agains FIAT.FiniteElement.tabulate()."

        error = fiat_main(INFO)
        self.assertEqual(error, 0, "Errors while testing evaluate_basis against FIAT, see fiat_errors.log for details")

if __name__ == "__main__":
    unittest.main()
