/*
 *	fhist - file history and comparison tools
 *	Copyright (C) 1991, 1992, 1993, 1994, 1998, 1999, 2000 Peter Miller;
 *	All rights reserved.
 *
 *	Derived from a work
 *	Copyright (C) 1990 David I. Bell.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for common/fileio.h
 *
 * Definitions for local file handling routines.
 */

#ifndef FILEIO_H
#define FILEIO_H

#include <ac/stdio.h>

#include <main.h>


/*
 * Function Prototypes
 */
void seekf _((FILE *, long, const char *));
int skipf _((FILE *, long, const char *));
char *readlinef _((FILE *, long *, int, const char *, int *));
long readf _((FILE *, char *, long, const char *, int *));
void writefx _((FILE *, char *, long, const char *));
int copyf _((FILE *, FILE *, long, const char *, const char *));
void copyfx _((FILE *, FILE *, long, const char *, const char *));
int typef _((FILE *, const char *));
void typefx _((FILE *, const char *));

#endif /* FILEIO_H */
