#ifndef FIGURINE_STK_H
#define FIGURINE_STK_H

/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: stk.h,v $
 * Revision 1.2  2000/12/06 20:56:08  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:32  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:32  moz
 * CVS Import
 *
 * Revision 1.11  2000/03/09 01:06:18  moz
 * Compile fixes.
 *
 * Revision 1.10  2000/02/18 04:08:10  moz
 * Compile fix.
 *
 * Revision 1.9  2000/01/30 17:24:40  moz
 * stk_open_message passes back check_dial.
 *
 * Revision 1.8  1999/11/15 02:12:51  moz
 * Name change.
 *
 * Revision 1.7  1999/08/17 00:38:21  moz
 * Proto fix.
 *
 * Revision 1.6  1999/06/16 00:58:04  moz
 * Prototype for stk_unmap_tooltip().
 *
 * Revision 1.5  1999/05/19 17:11:27  moz
 * 1.0 Checkin.
 *
 * Revision 1.4  1999/05/04 22:23:20  moz
 * STK_MENU_CANCELLED added.
 *
 * Revision 1.3  1999/04/27 21:15:42  moz
 * New prototypes for API.
 *
 * Revision 1.2  1999/04/23 01:06:22  moz
 * Send a CHOICE_PRESSED message define.
 *
 * Revision 1.1  1999/03/30 00:10:10  moz
 * Initial revision
 *
 */

/* Header file for the S Toolkit */ 
/* This is for the generic toolkit */
/* Describes the API of STK  */  

#include <X11/Xlib.h>
 
/* defines  */ 

#define MENUBAR_MENUS_LIMIT 5 /* hard limit of five top-level menus on the bar  */ 
#define ICONPANEL_ICONS_LIMIT 15 /* hard limit of sixteen icons  */  
#define MENU_LABEL_LIMIT 20 /* hard limit of labels in menus */  

/* placement of dialog elements */ 

#define JLEFTDROP 1
#define JRIGHTDROP 2
#define JLEFT 3
#define JRIGHT 4
#define JCENTRE 5

/* for communication  */

#define STK_MENU_CHOSEN 1
#define STK_ICON_CHOSEN 2
#define STK_ICON_DOUBLECLICKED 3
#define STK_BUTTON_PRESSED 4
#define STK_DIALOG_BUTTON_CLICKED 5
#define STK_DIALOG_TEXT_LIST_SELECTION 6
#define STK_DIALOG_TEXT_ENTRY_RETURN 7
#define STK_DIALOG_CHOICE_CLICKED 8 
#define STK_DIALOG_SLID 9 
#define STK_CHOICE_PRESSED 10 
#define STK_MENU_CANCELLED 11 

typedef struct _stkMenuBar
	{
	char *label[MENUBAR_MENUS_LIMIT]; 
	} stkMenuBar;

typedef struct _stkMenu
	{
	char *label[MENU_LABEL_LIMIT];
	int tag[MENU_LABEL_LIMIT];
	} stkMenu;
	
typedef struct _stkIcon
	{
	char **xpm_data;
	Pixmap pixmap; 
	int tag; 
	uint x;
	uint y;
	uint w;
	uint h;
	Boolean pressable; 
	Boolean binary; 
	char *tooltip; 
	} stkIcon;

typedef struct _stkIconPanel
	{
	uint x;
	uint y;
	uint iconnum; 
	stkIcon *icons;
	} stkIconPanel;
	 
typedef struct _stkIconMenu
	{
	uint iconnum;
	stkIcon *icons;
	} stkIconMenu;
	

	 
/* api for stk */

#ifdef PROTOTYPES 
void stk_init(WindowStruct *,XFontStruct *, ulong, ulong, ulong, ulong, Display *);
/* return -1 on failure, else pixel height of object created */  
int stk_create_menu_bar(WindowStruct, stkMenuBar *);
Boolean stk_notify(XEvent *); 
Window stk_create_menu(char *, stkMenu *, WindowStruct *, uint, uint);         
int stk_create_icon(stkIcon *,Window,Boolean, long); 
int stk_create_icon_panel(WindowStruct, stkIconPanel *);
Window stk_create_icon_menu(stkIconMenu *, int);
void stk_display_icon_menu(Window, int, int, Boolean, int);
void stk_attach_icon_menu(int, Window, Window); 
void stk_undisplay_icon_menu(Window);
void stk_display_menu(void *, Window, int, int, int);
void stk_change_menu_label(Window, char *, char *); 
void stk_tooltips(Boolean); 
void stk_unmap_tooltip(void); 
void stk_select_icon(int,Window);
void stk_delete_icon(int,Window); 
void stk_unselect_icon(int,Window);
void stk_finish(void); 
void stk_swap_pixmap(int, Window, int, Window);
void stk_set_pixmap(int, Window, Pixmap); 
 
Window stk_create_dialog(long, long);
void stk_add_dialog_title(Window, char *);
void stk_open_dialog(Window,void *); 
void stk_close_dialog(Window); 
Window stk_add_text_slider(Window, char *, int, int, int); 
void stk_add_textlist_member(Window, char *); 
void stk_clear_textlist(Window);
void stk_select_textlist_member(Window, char *); 
Window stk_add_text_entry(Window, char *, char *, int, int); 
Window stk_add_choice(Window, char *, int, int); 
Window stk_add_button(Window, char *, int, int, Boolean,int); 
void stk_set_text_entry(Window, char *); 
void stk_get_text_entry(Window, char *); 
void stk_get_textlist_selection(Window, char *); 
void stk_redraw_dialog_w(Window); 
void stk_unselect_textlist(Window); 
Window stk_create_colour_icon_menu(VColour *,int, int); 
void stk_enable_menu_label(Window, int);
void stk_disable_menu_label(Window, int);
void stk_show_icon(int tag, Window parent); 
void stk_hide_icon(int tag, Window parent); 
void stk_set_x(int tag, Window parent, int); 
Window stk_add_radio_choice(Window dw, char *label, char *l1, char *l2, char *l3, char *l4, int justification, int hjustification);
void stk_choice_on(Window,int); 
void stk_choice_off(Window,int); 
Boolean stk_get_choice(Window, int); 
Window stk_add_slider(Window dw, char *label, char *start, char *end, uint pstart, int justification, int hjustification); 
void stk_set_slider_pos(Window vw, double pos);
int stk_get_textlist_selection_num(Window tw);
void stk_open_message(char *message, char *sone, char *stwo, char *sthree, Window *dial, Window *one, Window *two, Window *three, void *call);
void stk_open_info(char *message); 
#endif 

#endif
